/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import zipeditor.PreferenceInitializer;
import zipeditor.Utils;
import zipeditor.ZipEditorPlugin;
import zipeditor.actions.ActionMessages;
import zipeditor.model.Node;

public class FileOpener {
    private static final int MAX_RECENTLY_USED_FILTERS = 5;
    private final IWorkbenchPage fPage;
    private final Node fNode;

    public FileOpener(IWorkbenchPage page, Node node) {
        this.fPage = page;
        this.fNode = node;
    }

    public void openFromOther(IFileStore file, Editor editor) {
        if (editor.getDescriptor() == null) {
            try {
                this.processCommand(file, editor);
                this.addToRecentlyUsedExecutables(editor);
                ZipEditorPlugin.getDefault().addFileMonitor(new File(file.toURI()), this.fNode);
            }
            catch (Exception e) {
                ZipEditorPlugin.log(e);
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)ActionMessages.getString("FileOpener.0"), (String)ActionMessages.getString("FileOpener.1"), (IStatus)ZipEditorPlugin.createErrorStatus(e.getClass().getName(), e));
            }
        } else if (!file.fetchInfo().isDirectory() && file.fetchInfo().exists()) {
            IEditorInput input = Utils.createEditorInput(file);
            String editorId = editor.getDescriptor().getId();
            try {
                this.fPage.openEditor(input, editorId);
                ZipEditorPlugin.getDefault().addFileMonitor(new File(file.toURI()), this.fNode);
                this.addToRecentlyUsedExecutables(editor);
            }
            catch (PartInitException e) {
                ZipEditorPlugin.log((Object)e);
            }
        }
    }

    private void processCommand(IFileStore file, Editor editor) throws Exception {
        String commandString = editor.getPath();
        commandString = this.replaceAll(commandString, "$p", file.toString());
        commandString = this.replaceAll(commandString, "$f", file.getName());
        commandString = this.replaceAll(commandString, "$z", this.fNode.getModel().getZipPath().getAbsolutePath());
        int dotIndex = file.getName().lastIndexOf(46);
        if ((commandString = this.replaceAll(commandString, "$n", file.getName().substring(0, dotIndex != -1 ? dotIndex : file.getName().length()))).equals(editor.getPath())) {
            commandString = String.valueOf(commandString) + ' ' + file.toString();
        }
        String outCommand = null;
        int pipeIndex = commandString.indexOf(124);
        if (pipeIndex != -1) {
            outCommand = commandString.substring(pipeIndex + 1);
            commandString = commandString.substring(0, pipeIndex);
        }
        int extIndex = commandString.indexOf("$x");
        String ext = null;
        if (extIndex != -1) {
            int endIndex = (ext = commandString.substring(extIndex + 2).trim()).indexOf(32);
            ext = ext.substring(0, endIndex == -1 ? ext.length() : endIndex);
            commandString = String.valueOf(commandString.substring(0, extIndex)) + commandString.substring(commandString.indexOf(ext) + ext.length());
        }
        Process process = Runtime.getRuntime().exec(commandString);
        if (outCommand == null) {
            return;
        }
        final InputStream stdIn = process.getInputStream();
        final InputStream stdErr = process.getErrorStream();
        int defaultEditorIndex = outCommand.indexOf("$i");
        int editorIdIndex = outCommand.indexOf("$e");
        if (defaultEditorIndex != -1 || editorIdIndex != -1) {
            String editorId = "org.eclipse.ui.DefaultTextEditor";
            if (editorIdIndex != -1 && (editorId = outCommand.substring(editorIdIndex + 2).trim()).indexOf(32) != -1) {
                editorId = editorId.substring(0, editorId.indexOf(32)).trim();
            }
            File tmpFile = File.createTempFile("internal", ext, this.fNode.getModel().getTempDir());
            final FileOutputStream out = new FileOutputStream(tmpFile);
            Thread.sleep(100L);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Utils.readAndWrite(stdErr, out, false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, "ErrReader").start();
            Thread.sleep(100L);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Utils.readAndWrite(stdIn, out, false);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, "InReader").start();
            process.waitFor();
            Thread.sleep(100L);
            out.flush();
            if (out.getChannel().isOpen()) {
                out.close();
            }
            this.fPage.openEditor(Utils.createEditorInput(Utils.getFileStore(tmpFile)), editorId);
        } else {
            Process outCommandProcess = Runtime.getRuntime().exec(outCommand);
            BufferedOutputStream out = new BufferedOutputStream(outCommandProcess.getOutputStream());
            Utils.readAndWrite(stdIn, out, true);
        }
    }

    private String replaceAll(String string, String what, String replacement) {
        int index = string.indexOf(what);
        if (index == -1) {
            return string;
        }
        return String.valueOf(string.substring(0, index)) + replacement + this.replaceAll(string.substring(index + what.length()), what, replacement);
    }

    private void addToRecentlyUsedExecutables(Editor editor) {
        IPreferenceStore store = ZipEditorPlugin.getDefault().getPreferenceStore();
        Editor[] recentlyUsedEditors = (Editor[])PreferenceInitializer.split(store.getString("recentlyUsedEditors"), ",", Editor.class);
        List<Editor> newEditors = new ArrayList<Editor>(Arrays.asList(recentlyUsedEditors));
        int i = 0;
        while (i < recentlyUsedEditors.length) {
            if (editor.getLabel().equals(recentlyUsedEditors[i].getLabel())) {
                newEditors.remove(i);
            }
            ++i;
        }
        newEditors.add(0, (Editor)((Object)editor.toString()));
        if (newEditors.size() > 5) {
            newEditors = newEditors.subList(0, 5);
        }
        store.setValue("recentlyUsedEditors", PreferenceInitializer.join(newEditors.toArray(), ","));
    }

    public static class Editor {
        private String path;
        private String label;
        private IEditorDescriptor descriptor;

        protected Editor(IEditorDescriptor descriptor) {
            this.descriptor = descriptor;
            this.label = descriptor.getLabel();
        }

        public Editor(String string) {
            int _1st = string.indexOf(255);
            if (_1st != -1) {
                this.label = string.substring(0, _1st);
                this.path = string.substring(_1st + 1);
            } else {
                _1st = string.indexOf(254);
                if (_1st != -1) {
                    this.label = string.substring(0, _1st);
                }
                this.descriptor = PlatformUI.getWorkbench().getEditorRegistry().findEditor(string.substring(_1st + 1));
            }
        }

        protected Editor(String label, String path) {
            this.label = label;
            this.path = path;
        }

        public String getLabel() {
            return this.label;
        }

        public String getPath() {
            return this.path;
        }

        public IEditorDescriptor getDescriptor() {
            return this.descriptor;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean equals(Object obj) {
            return obj != null && obj.toString().equals(this.toString());
        }

        public String toString() {
            return String.valueOf(this.label) + (this.descriptor != null ? String.valueOf('\u00fe') + this.descriptor.getId() : String.valueOf('\u00ff') + this.path);
        }
    }
}

