/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.gom.smartlaunch.handler;

import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.CycleBaseHandler;
import org.eclipse.ui.internal.WorkbenchPage;
import org.tizen.common.gom.launch.GomLaunchData;
import org.tizen.common.gom.smartlaunch.GomSmartLaunchManager;
import org.tizen.common.gom.smartlaunch.GomSmartLauncher;
import org.tizen.common.gom.smartlaunch.GomSmartUILauncher;
import org.tizen.common.gom.smartlaunch.messages.GomMessages;
import org.tizen.sdblib.IDevice;

public class GomSmartLaunchCycleHandler
extends CycleBaseHandler {
    private String[] columns = new String[]{GomMessages.SMARTLAUNCH_CYCLE_COLUMNS_1, GomMessages.SMARTLAUNCH_CYCLE_COLUMNS_2, GomMessages.SMARTLAUNCH_CYCLE_COLUMNS_3, GomMessages.SMARTLAUNCH_CYCLE_COLUMNS_4};
    private String[] sampleColumns = new String[]{"Profile", "ProjectProject", "LaunchConfigurationLaunchConfiguration", "emulator-xxxxx"};
    private static final String TIZEN_SMART_LAUNCH_UP_ID = "org.tizen.common.gom.smartlaunch.ui.tizensmartlauncher.up";
    private static final String TIZEN_SMART_LAUNCH_DOWN_ID = "org.tizen.common.gom.smartlaunch.ui.tizensmartlauncher.down";

    protected void addItems(Table table, WorkbenchPage page) {
        List<GomLaunchData> list = GomSmartLaunchManager.getDefault().getLaunchList();
        this.setTable(table, list);
    }

    protected ParameterizedCommand getBackwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(TIZEN_SMART_LAUNCH_UP_ID);
        ParameterizedCommand commandBack = new ParameterizedCommand(command, null);
        return commandBack;
    }

    protected ParameterizedCommand getForwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(TIZEN_SMART_LAUNCH_DOWN_ID);
        ParameterizedCommand commandForward = new ParameterizedCommand(command, null);
        return commandForward;
    }

    protected String getTableHeader(IWorkbenchPart activePart) {
        return null;
    }

    protected void openDialog(WorkbenchPage page, IWorkbenchPart activePart) {
        Shell shell = null;
        if (activePart != null) {
            shell = activePart.getSite().getShell();
        }
        if (shell == null) {
            shell = this.window.getShell();
        }
        final Shell dialog = new Shell(shell, 0);
        Display display = dialog.getDisplay();
        dialog.setLayout((Layout)new FillLayout());
        final Table table = new Table((Composite)dialog, 65540);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        int i = 0;
        while (i < this.columns.length) {
            this.createTableColumn(table, this.sampleColumns[i], this.columns[i]);
            ++i;
        }
        this.addItems(table, page);
        int tableItemCount = table.getItemCount();
        switch (tableItemCount) {
            case 0: {
                this.cancel(dialog);
                return;
            }
            case 1: {
                table.setSelection(0);
                break;
            }
            default: {
                int i2;
                if (this.gotoDirection) {
                    i2 = this.getCurrentItemIndex() + 1;
                    if (i2 >= tableItemCount) {
                        i2 = 0;
                    }
                } else {
                    i2 = this.getCurrentItemIndex() - 1;
                    if (i2 < 0) {
                        i2 = tableItemCount - 1;
                    }
                }
                table.setSelection(i2);
            }
        }
        table.pack();
        dialog.pack();
        Rectangle tableBounds = table.getBounds();
        tableBounds.height = Math.min(tableBounds.height, table.getItemHeight() * 22);
        table.setBounds(tableBounds);
        dialog.setBounds(dialog.computeTrim(tableBounds.x, tableBounds.y, tableBounds.width, tableBounds.height));
        table.setFocus();
        table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                GomSmartLaunchCycleHandler.this.cancel(dialog);
            }
        });
        table.addMouseMoveListener(new MouseMoveListener(){
            TableItem lastItem = null;

            public void mouseMove(MouseEvent e) {
                if (table.equals(e.getSource())) {
                    TableItem o;
                    if (this.lastItem == null ^ (o = table.getItem(new Point(e.x, e.y))) == null) {
                        table.setCursor(o == null ? null : table.getDisplay().getSystemCursor(21));
                    }
                    if (o == null) {
                        this.lastItem = null;
                    } else if (!o.equals(this.lastItem)) {
                        this.lastItem = o;
                        table.setSelection(new TableItem[]{this.lastItem});
                    }
                }
            }
        });
        this.setDialogLocation(dialog, activePart);
        IContextService contextService = (IContextService)this.window.getWorkbench().getService(IContextService.class);
        try {
            dialog.open();
            this.addMouseListener(table, dialog);
            contextService.registerShell(dialog, 1);
            this.addKeyListener(table, dialog);
            this.addTraverseListener(table);
            while (!dialog.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            if (!dialog.isDisposed()) {
                this.cancel(dialog);
            }
            contextService.unregisterShell(dialog);
        }
    }

    private TableColumn createTableColumn(Table table, String sampleText, String text) {
        TableColumn tc = new TableColumn(table, 0);
        tc.setResizable(true);
        tc.setText(sampleText);
        tc.pack();
        tc.setText(text);
        return tc;
    }

    private void setTable(Table table, List<GomLaunchData> list) {
        this.setTableItem(table, list);
    }

    private void setTableItem(Table table, List<GomLaunchData> list) {
        if (list.size() == 0) {
            return;
        }
        int i = list.size() - 1;
        while (i >= 0) {
            GomLaunchData info = list.get(i);
            TableItem item = new TableItem(table, 0);
            item.setText(0, info.getMode());
            item.setText(1, info.getProject().getName());
            item.setText(2, info.getLaunchConfiguration().getName());
            IDevice device = info.getDevice();
            item.setText(3, device == null ? "" : info.getDevice().getDeviceName());
            item.setData((Object)info);
            --i;
        }
    }

    protected void activate(IWorkbenchPage page, Object selectedItem) {
        if (page == null || selectedItem == null) {
            return;
        }
        if (selectedItem instanceof GomLaunchData) {
            GomLaunchData data = (GomLaunchData)selectedItem;
            if (GomSmartUILauncher.isExistDevice()) {
                GomSmartLauncher.smartLaunch(data);
            }
        }
    }
}

