/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.FileEntryAdapterFactory;
import org.tizen.common.connection.preference.TizenConnectionExplorerPreferencePage;
import org.tizen.common.connection.toolbar.DeviceDescriptor;
import org.tizen.common.connection.toolbar.TargetToolBarManager;
import org.tizen.common.connection.toolbar.VMChangeListener;
import org.tizen.common.util.OSChecker;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.sdblib.IDebugBridgeChangeListener;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IDeviceChangeListener;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.service.FileEntry;

public class ConnectionPlugin
extends AbstractUIPlugin
implements IStartup,
IDebugBridgeChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionPlugin.class);
    public static final String PLUGIN_ID = "org.tizen.common.connection";
    public static final String ID_LOGS_VIEW = "org.tizen.common.connection.log.LogView";
    public static final String ID_CONNECTION_VIEW = "org.tizen.common.connection.explorer.ConnectionExplorer";
    private static ConnectionPlugin plugin;
    private IDevice currentDevice = null;
    private final ArrayList<ISelectionListener> listeners = new ArrayList();
    private TargetToolBarManager toolbarManager = null;
    private VMChangeListener<VMProperty> vmKeeperListener = null;
    public int os;
    public static final int LINUX = 0;
    public static final int WINDOWS = 1;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.os = OSChecker.isWindows() ? 1 : 0;
        IAdapterManager manager = Platform.getAdapterManager();
        FileEntryAdapterFactory factory = new FileEntryAdapterFactory();
        manager.registerAdapters((IAdapterFactory)factory, FileEntry.class);
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("pushpull_timeout", 30000);
        store.setDefault("emulator_manager_path", TizenConnectionExplorerPreferencePage.VALUE_EMULATOR_MANAGER_PATH_DEFAULT);
        store.setDefault("terminal_path", TizenConnectionExplorerPreferencePage.VALUE_TERMINAL_PATH_DEFAULT);
        store.setDefault("string_buffer_length", 20000);
    }

    public void stop(BundleContext context) throws Exception {
        int deviceCnt;
        if (this.toolbarManager != null) {
            DeviceDescriptor device;
            if (this.vmKeeperListener != null) {
                this.vmKeeperListener.removeVMChangeListener();
                this.vmKeeperListener = null;
            }
            if ((device = this.toolbarManager.getDefaultDeviceDescriptor()) != null) {
                this.toolbarManager.saveDefaultDescriptorToPreferenceStore(device.getSerialId());
            }
            SmartDevelopmentBridge.removeDeviceChangeListener((IDeviceChangeListener)this.toolbarManager);
        }
        if ((deviceCnt = SmartDevelopmentBridge.getBridge().getDevices().length) == 0) {
            SmartDevelopmentBridge.disconnectBridge();
        }
        plugin = null;
        super.stop(context);
    }

    public static ConnectionPlugin getDefault() {
        return plugin;
    }

    public void setCurrentDevice(IDevice device) {
        this.currentDevice = device;
    }

    public IDevice getCurrentDevice() {
        return this.currentDevice;
    }

    public void addSelectionListener(ISelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(ISelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void notifySelectionListeners(FileEntry file) {
        ISelectionListener[] listenersCopy;
        ISelectionListener[] iSelectionListenerArray = listenersCopy = this.listeners.toArray(new ISelectionListener[this.listeners.size()]);
        int n = listenersCopy.length;
        int n2 = 0;
        while (n2 < n) {
            ISelectionListener listener = iSelectionListenerArray[n2];
            try {
                listener.selectionChanged(file);
            }
            catch (Exception e) {
                logger.error("Failed to invoke selectionChanged", (Throwable)e);
            }
            ++n2;
        }
    }

    public TargetToolBarManager getTargetToolBarManager() {
        if (this.toolbarManager == null) {
            this.toolbarManager = new TargetToolBarManager();
            try {
                this.vmKeeperListener = new VMChangeListener();
                this.vmKeeperListener.addVMChangeListener();
            }
            catch (Throwable e) {
                logger.error("vm library has error occurred: " + e.getMessage());
            }
        }
        return this.toolbarManager;
    }

    public static ImageDescriptor getImageDescriptorFromPlugin(String path) {
        return ConnectionPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void earlyStartup() {
        SmartDevelopmentBridge.getBridge().getDevices();
        SmartDevelopmentBridge.addDebugBridgeChangeListener((IDebugBridgeChangeListener)this);
    }

    public void bridgeChanged(SmartDevelopmentBridge bridge) {
        ConnectionPlugin cp;
        IDevice[] devices = bridge.getDevices();
        if (devices.length != 0 && (cp = ConnectionPlugin.getDefault()) != null) {
            cp.setCurrentDevice(devices[0]);
        }
        SmartDevelopmentBridge.removeDebugBridgeChangeListener((IDebugBridgeChangeListener)this);
    }

    public static interface ISelectionListener {
        public void selectionChanged(FileEntry var1);
    }
}

