/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.log;

import org.tizen.common.connection.log.LogPanel;
import org.tizen.common.connection.log.SearchOption;
import org.tizen.common.connection.log.model.LogMessage;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.util.LogLevel;

public class LogFilter {
    public static final int FILTER_NONE = -1;
    public static final int FILTER_PID = 0;
    public static final int FILTER_TAG = 1;
    public static final int FILTER_MESSAGE = 2;
    public static final boolean[] FILTER_LOG_LEVEL_ALL = new boolean[]{true, true, true, true, true, true};
    public static boolean[] FILTER_LOG_LEVEL_DEFAULT;
    private String pidInput;
    private String tagInput;
    private String msgInput;
    private String[] pidFilters;
    private String[] tagFilters;
    private String[] msgFilters;
    private int comboFilter = 2;
    private String keywordFilter = "";
    private boolean[] logLevelFilter = FILTER_LOG_LEVEL_DEFAULT;
    private SearchOption pidSearchOption = SearchOption.OR;
    private SearchOption tagSearchOption = SearchOption.OR;
    private SearchOption msgSearchOption = SearchOption.OR;

    static {
        int defaultIndex = LogPanel.DEFAULT_LOG_LEVEL.getPriority() - 2;
        int length = LogLevel.values().length;
        FILTER_LOG_LEVEL_DEFAULT = new boolean[length];
        int i = 0;
        while (i < length) {
            LogFilter.FILTER_LOG_LEVEL_DEFAULT[i] = i >= defaultIndex;
            ++i;
        }
    }

    public String getPidInput() {
        return this.pidInput;
    }

    public String getTagInput() {
        return this.tagInput;
    }

    public String getMsgInput() {
        return this.msgInput;
    }

    public String[] getPidFilters() {
        return this.pidFilters;
    }

    public String[] getTagFilters() {
        return this.pidFilters;
    }

    public String[] getMsgFilters() {
        return this.pidFilters;
    }

    public int getComboFilter() {
        return this.comboFilter;
    }

    public String getKeywordFilter() {
        return this.keywordFilter;
    }

    public boolean[] getLogLevelFilter() {
        return this.logLevelFilter;
    }

    public void setPidFilter(String pidInput) {
        this.pidInput = pidInput;
        if (pidInput != null) {
            if (pidInput.contains(",") || pidInput.contains(" ")) {
                this.pidSearchOption = SearchOption.OR;
            } else if (pidInput.contains("+")) {
                this.pidSearchOption = SearchOption.AND;
                this.pidFilters = pidInput.split("[+]", 0);
                return;
            }
            this.pidFilters = pidInput.split("[\\s,]", 0);
        } else {
            this.pidFilters = null;
        }
    }

    public void setTagFilter(String tagInput) {
        this.tagInput = tagInput;
        if (tagInput != null) {
            if (tagInput.contains(",") || tagInput.contains(" ")) {
                this.tagSearchOption = SearchOption.OR;
            } else if (tagInput.contains("+")) {
                this.tagSearchOption = SearchOption.AND;
                this.tagFilters = tagInput.split("[+]", 0);
                return;
            }
            this.tagFilters = tagInput.split("[\\s,]", 0);
        } else {
            this.tagFilters = null;
        }
    }

    public void setMsgFilter(String msgInput) {
        this.msgInput = msgInput;
        if (msgInput != null) {
            if (msgInput.contains(",") || msgInput.contains(" ")) {
                this.msgSearchOption = SearchOption.OR;
            } else if (msgInput.contains("+")) {
                this.msgSearchOption = SearchOption.AND;
                this.msgFilters = msgInput.split("[+]", 0);
                return;
            }
            this.msgFilters = msgInput.split("[\\s,]", 0);
        } else {
            this.msgFilters = null;
        }
    }

    public void setComboFilter(int comboFilter) {
        this.comboFilter = comboFilter;
    }

    public void setKeywordFilter(String keywordFilter) {
        this.keywordFilter = keywordFilter;
    }

    public void setLogLevelFilter(boolean[] logLevelFilter) {
        this.logLevelFilter = logLevelFilter;
    }

    public boolean filteredByDefaultKeyword(LogMessage logMessage) {
        if (logMessage == null) {
            return false;
        }
        if (this.pidFilters != null || this.tagFilters != null || this.msgFilters != null) {
            if (this.pidFilters != null && !this.existKeyword(logMessage.data.getPidString(), this.pidFilters, this.pidSearchOption)) {
                return false;
            }
            if (this.tagFilters != null && !this.existKeyword(logMessage.data.getTag(), this.tagFilters, this.tagSearchOption)) {
                return false;
            }
            return this.msgFilters == null || this.existKeyword(logMessage.msg, this.msgFilters, this.msgSearchOption);
        }
        return true;
    }

    private boolean existKeyword(String log, String[] filters, SearchOption searchOption) {
        if (searchOption == SearchOption.AND) {
            String[] stringArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                if (!log.toLowerCase().contains(filter.toLowerCase())) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (searchOption == SearchOption.OR) {
            String[] stringArray = filters;
            int n = filters.length;
            int n3 = 0;
            while (n3 < n) {
                String filter = stringArray[n3];
                if (log.toLowerCase().contains(filter.toLowerCase())) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        return true;
    }

    public boolean filteredByLoglevel(LogMessage logMessage) {
        if (logMessage == null) {
            return false;
        }
        if (this.logLevelFilter != FILTER_LOG_LEVEL_ALL) {
            int index = logMessage.data.getLogLevel().getPriority() - 2;
            return this.logLevelFilter[index];
        }
        return true;
    }

    public boolean filteredByKeyword(LogMessage logMessage) {
        if (logMessage == null) {
            return false;
        }
        if (StringUtil.isEmpty((CharSequence)this.keywordFilter)) {
            return true;
        }
        String msg = null;
        String filter = this.keywordFilter.toLowerCase();
        switch (this.comboFilter) {
            case 0: {
                msg = logMessage.data.getPidString();
                break;
            }
            case 1: {
                msg = logMessage.data.getTag().toLowerCase();
                break;
            }
            case 2: {
                msg = logMessage.msg.toLowerCase();
                break;
            }
            default: {
                return false;
            }
        }
        if (filter != null) {
            if (filter.contains(",") || filter.contains(" ")) {
                String[] filters = filter.split("[\\s,]", 0);
                return this.existKeyword(msg, filters, SearchOption.OR);
            }
            if (filter.contains("+")) {
                String[] filters = filter.split("[+]", 0);
                return this.existKeyword(msg, filters, SearchOption.AND);
            }
            return msg.contains(filter);
        }
        return true;
    }

    public boolean filteredByLogLevelAndKeyword(LogMessage logMessage) {
        return this.filteredByLoglevel(logMessage) && this.filteredByKeyword(logMessage);
    }
}

