/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.wizard;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.sign.ui.wizard.CertificateBaseWizardPage;
import org.tizen.common.sign.ui.wizard.CertificateCreationWizard;
import org.tizen.common.sign.ui.wizard.Messages;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.StringUtil;

public class DistributorCertImportPage
extends CertificateBaseWizardPage {
    private Text textCertPath;
    private Text textPasswd;

    protected DistributorCertImportPage(String pageName) {
        super(pageName);
        this.setDescription(Messages.DIST_CERT_IMPORT_DESC);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 30);
        formData.right = new FormAttachment(100, -30);
        formData.top = new FormAttachment(0, 30);
        Composite firstComp = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 14;
        layout.horizontalSpacing = 10;
        firstComp.setLayout((Layout)layout);
        firstComp.setLayoutData((Object)formData);
        Label lCertPath = new Label(firstComp, 0);
        lCertPath.setFont(TizenFonts.getBoldFont());
        lCertPath.setText(Messages.DIST_CERT_IMPORT_CERT_PATH);
        new Label(firstComp, 0);
        this.textCertPath = new Text(firstComp, 2048);
        this.textCertPath.setLayoutData((Object)new GridData(768));
        this.textCertPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DistributorCertImportPage.this.validate();
            }
        });
        Button btBrowse = new Button(firstComp, 8);
        btBrowse.setText(Messages.CERT_IMPORT_PAGE_BROWSE);
        GridData layoutData = new GridData();
        layoutData.widthHint = 80;
        btBrowse.setLayoutData((Object)layoutData);
        btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog dlg = new FileDialog(DistributorCertImportPage.this.getShell(), 4096);
                dlg.setFilterExtensions(new String[]{"*.p12"});
                dlg.setFilterPath(SigningPathUtil.getDistributorCertificatePath());
                String filepath = dlg.open();
                if (!StringUtil.isEmpty((CharSequence)filepath)) {
                    DistributorCertImportPage.this.textCertPath.setText(filepath);
                }
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment(0, 30);
        formData.right = new FormAttachment(100, -30);
        formData.top = new FormAttachment((Control)firstComp, 38);
        Composite secondComp = new Composite(composite, 0);
        layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 14;
        secondComp.setLayout((Layout)layout);
        secondComp.setLayoutData((Object)formData);
        Label lPasswd = new Label(secondComp, 0);
        lPasswd.setFont(TizenFonts.getBoldFont());
        lPasswd.setText(Messages.CERT_IMPORT_PAGE_PASSWD);
        this.textPasswd = new Text(secondComp, 0x400800);
        this.textPasswd.setLayoutData((Object)new GridData(768));
        this.textPasswd.setMessage(Messages.CERT_IMPORT_PAGE_PASSWD_GUIDE);
        this.textPasswd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DistributorCertImportPage.this.validate();
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment(0, 30);
        formData.right = new FormAttachment(100, -30);
        formData.top = new FormAttachment((Control)secondComp, 4);
        Label lError = this.createErrorLabel(composite);
        lError.setLayoutData((Object)formData);
        this.textPasswd.setData("label", (Object)lError);
        this.setControl((Control)composite);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public String getCertPath() {
        return this.textCertPath.getText();
    }

    public String getPassword() {
        return this.textPasswd.getText();
    }

    public void validate() {
        boolean bCanFinish = !this.textCertPath.getText().isEmpty();
        ((CertificateCreationWizard)this.getWizard()).setCanFinish(bCanFinish);
        this.getWizard().getContainer().updateButtons();
    }
}

