/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.ui.dialog.Messages;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.StringUtil;

public class CertificateEditionDialog
extends Dialog {
    private Label lDescription;
    private Text textCertPath;
    private Text textCertPasswd;
    private String certPath;
    private String certPasswd;
    private boolean isDistributor;
    private SigningProfileItem originCert;

    public CertificateEditionDialog(Shell parentShell, SigningProfileItem cert, boolean isDist) {
        super(parentShell);
        this.originCert = cert;
        this.isDistributor = isDist;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.CERT_EDIT_DLG_TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(680, 400);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        CertificateEditionDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.createTitleArea(composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        this.setInput();
        return composite;
    }

    public void setDescription(String description) {
        this.lDescription.setText(description);
    }

    private Control createTitleArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 20;
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 40;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.lDescription = new Label(composite, 0);
        layoutData = new GridData(772);
        layoutData.grabExcessVerticalSpace = true;
        this.lDescription.setLayoutData((Object)layoutData);
        this.lDescription.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.setDescription(Messages.CERT_EDIT_DLG_DESC);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 30;
        layout.marginWidth = 30;
        layout.verticalSpacing = 40;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createPathComposite(composite);
        this.createPasswordComposite(composite);
        return composite;
    }

    private void createPathComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 15;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label lCertPath = new Label(composite, 0);
        lCertPath.setFont(TizenFonts.getBoldFont());
        lCertPath.setText(Messages.CERT_EDIT_DLG_FILEPATH);
        GridData labelLayout = new GridData(769);
        labelLayout.horizontalSpan = 2;
        lCertPath.setLayoutData((Object)labelLayout);
        this.textCertPath = new Text(composite, 2048);
        GridData layoutData = new GridData(768);
        this.textCertPath.setLayoutData((Object)layoutData);
        this.textCertPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CertificateEditionDialog.this.validate();
            }
        });
        Button btBrowse = new Button(composite, 8);
        btBrowse.setText(Messages.CERT_EDIT_DLG_BROWSE);
        btBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog dlg = new FileDialog(CertificateEditionDialog.this.getShell(), 4096);
                dlg.setFilterExtensions(new String[]{"*.p12"});
                if (CertificateEditionDialog.this.isDistributor) {
                    dlg.setFilterPath(SigningPathUtil.getDistributorCertificatePath());
                } else {
                    dlg.setFilterPath(SigningProfileUtil.getAuthorCertStorePath().toPortableString());
                }
                String filepath = dlg.open();
                if (!StringUtil.isEmpty((CharSequence)filepath)) {
                    CertificateEditionDialog.this.textCertPath.setText(filepath);
                }
            }
        });
    }

    private void createPasswordComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label lPasswd = new Label(composite, 0);
        lPasswd.setFont(TizenFonts.getBoldFont());
        lPasswd.setText(Messages.CERT_EDIT_DLG_PASSWD);
        lPasswd.setLayoutData((Object)new GridData(768));
        this.textCertPasswd = new Text(composite, 0x400800);
        this.textCertPasswd.setLayoutData((Object)new GridData(768));
        this.textCertPasswd.setMessage(Messages.CERT_EDIT_DLG_PASSWD_GUIDE);
        this.textCertPasswd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CertificateEditionDialog.this.validate();
            }
        });
    }

    private void setInput() {
        if (this.originCert != null) {
            this.textCertPath.setText(this.originCert.getKeyLocation());
            this.textCertPasswd.setText(new String(this.originCert.getPassword()));
        }
    }

    public String getCertPath() {
        return this.certPath;
    }

    public String getCertPasswd() {
        return this.certPasswd;
    }

    protected void okPressed() {
        this.certPath = this.textCertPath.getText();
        this.certPasswd = this.textCertPasswd.getText();
        super.okPressed();
    }

    protected void validate() {
        boolean isOK = !this.textCertPath.getText().isEmpty();
        this.getButton(0).setEnabled(isOK);
    }
}

