/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.imageSelector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.imageSelector.ISItem;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class ImageSelector
extends Canvas {
    private List<ISItem> items;
    private List<ISItem> originalItems;
    private Font font = new Font((Device)this.getDisplay(), "Lucida Sans", 24, 0);
    private static final int DEFAULT_WIDTH = 148;
    private int maxItemWidth = 148;
    private int index = -1;
    private double sigma;
    private double rho;
    private double expMultiplier;
    private double expMember;
    private float spacing = 0.4f;
    private Color gradientStart;
    private Color gradientEnd;
    private double animationStep = -1.0;
    private static final int TIMER_INTERVAL = 50;
    private int pageIncrement = 5;

    public ImageSelector(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x20000000);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTGraphicUtil.dispose((Resource)ImageSelector.this.font);
                SWTGraphicUtil.dispose((Resource)ImageSelector.this.gradientStart);
                SWTGraphicUtil.dispose((Resource)ImageSelector.this.gradientEnd);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ImageSelector.this.paintControl(e);
            }
        });
        this.addKeyListener();
        this.addMouseListeners();
        this.setSigma(0.5);
        this.gradientStart = new Color((Device)this.getDisplay(), 0, 0, 0);
        this.gradientEnd = new Color((Device)this.getDisplay(), 110, 110, 110);
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
        this.rho = 1.0;
        this.computeEquationParts();
        this.rho = this.computeModifierUnbounded(0.0);
        this.computeEquationParts();
        this.redraw();
    }

    private void computeEquationParts() {
        this.expMultiplier = Math.sqrt(Math.PI * 2) / this.sigma / this.rho;
        this.expMember = 4.0 * this.sigma * this.sigma;
    }

    private double computeModifierBounded(double x) {
        double result = this.computeModifierUnbounded(x);
        if (result > 1.0) {
            result = 1.0;
        } else if (result < -1.0) {
            result = -1.0;
        }
        return result;
    }

    private double computeModifierUnbounded(double x) {
        return this.expMultiplier * Math.exp(-x * x / this.expMember);
    }

    private void paintControl(PaintEvent e) {
        Image image = new Image((Device)this.getDisplay(), this.getClientArea());
        GC gc = new GC((Drawable)image);
        this.drawBackground(gc);
        this.drawItems(gc);
        if (this.animationStep < 0.0) {
            this.drawTitle(gc);
        }
        e.gc.drawImage(image, 0, 0);
        image.dispose();
        gc.dispose();
    }

    private void drawBackground(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.gradientStart);
        gc.setBackground(this.gradientEnd);
        gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height / 2, true);
        gc.setForeground(this.gradientEnd);
        gc.setBackground(this.gradientStart);
        gc.fillGradientRectangle(rect.x, rect.height / 2, rect.width, rect.height / 2, true);
    }

    private void drawItems(GC gc) {
        if (this.animationStep < 0.0) {
            this.items.clear();
            this.items.addAll(this.originalItems);
            int i = 0;
            while (i < this.items.size()) {
                ISItem item = this.items.get(i);
                item.setzPosition((float)(i - this.index) * this.spacing);
                ++i;
            }
            Collections.sort(this.items);
        }
        for (ISItem item : this.items) {
            this.drawItem(gc, item);
        }
    }

    private void drawItem(GC gc, ISItem item) {
        int size = this.computeSize(item);
        int centerX = this.computeZPosition(item);
        int centerY = this.getClientArea().height / 2;
        if (size <= 0 || centerX < 0 || centerX > this.getBounds().width) {
            item.resetCornerToNull();
            return;
        }
        int alpha = this.computeAlpha(item);
        Image newImage = SWTGraphicUtil.createReflectedResizedImage(item.getImage(), size, size);
        gc.setAlpha(alpha);
        int x = centerX - newImage.getBounds().width / 2;
        int y = centerY - newImage.getBounds().height / 2;
        gc.drawImage(newImage, x, y);
        item.setUpperLeftCorner(x, y);
        item.setLowerRightCorner(x + newImage.getBounds().width, (int)((double)y + (double)newImage.getBounds().height / 1.5));
        newImage.dispose();
    }

    private int computeZPosition(ISItem item) {
        int totalWidth = this.getClientArea().width / 2;
        int centerX = this.getClientArea().width / 2;
        return (int)((double)centerX + item.getzPosition() * (double)totalWidth);
    }

    private int computeSize(ISItem item) {
        return (int)(this.computeModifierBounded(item.getzPosition()) * (double)this.maxItemWidth);
    }

    private int computeAlpha(ISItem item) {
        return (int)(255.0 - 150.0 * Math.abs(item.getzPosition()));
    }

    private void drawTitle(GC gc) {
        String title = this.originalItems.get(this.index).getText();
        if (title == null || title.trim().equals("")) {
            return;
        }
        gc.setFont(this.getFont());
        Point textSize = gc.stringExtent(title);
        gc.setAntialias(1);
        gc.setFont(this.getFont());
        gc.setForeground(this.getDisplay().getSystemColor(1));
        gc.setAlpha(255);
        int centerX = this.getClientArea().width / 2;
        int centerY = (this.getClientArea().height + this.maxItemWidth) / 2;
        gc.drawString(title, centerX - textSize.x / 2, centerY - textSize.y / 2, true);
    }

    private void addKeyListener() {
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000001: 
                    case 0x1000003: {
                        ImageSelector.this.scrollAndAnimateBy(-1);
                        break;
                    }
                    case 0x1000002: 
                    case 0x1000004: {
                        ImageSelector.this.scrollAndAnimateBy(1);
                        break;
                    }
                    case 0x1000007: {
                        ImageSelector.this.scrollBy(-1 * ImageSelector.this.index);
                        break;
                    }
                    case 0x1000008: {
                        ImageSelector.this.scrollBy(ImageSelector.this.index);
                        break;
                    }
                    case 0x1000005: {
                        ImageSelector.this.scrollBy(-1 * ImageSelector.this.pageIncrement);
                        break;
                    }
                    case 0x1000006: {
                        ImageSelector.this.scrollBy(ImageSelector.this.pageIncrement);
                        break;
                    }
                }
            }
        });
    }

    private void scrollBy(int increment) {
        this.index += increment;
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index >= this.items.size()) {
            this.index = this.items.size() - 1;
        }
        this.redraw();
    }

    private void scrollAndAnimateBy(final int increment) {
        double step;
        if (this.index == 0 && increment < 0 || this.index == this.items.size() - 1 && increment > 0) {
            return;
        }
        this.animationStep = step = (double)Math.abs(increment) / 6.0;
        this.setCursor(this.getDisplay().getSystemCursor(1));
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ImageSelector.this.items.clear();
                ImageSelector.this.items.addAll(ImageSelector.this.originalItems);
                int i = 0;
                while (i < ImageSelector.this.items.size()) {
                    ISItem item = (ISItem)ImageSelector.this.items.get(i);
                    item.setzPosition(((double)(i - ImageSelector.this.index) + ImageSelector.this.animationStep * (increment > 0 ? -1.0 : 1.0)) * (double)ImageSelector.this.spacing);
                    ++i;
                }
                Collections.sort(ImageSelector.this.items);
                if (!ImageSelector.this.isDisposed()) {
                    ImageSelector.this.redraw();
                }
                ImageSelector imageSelector = ImageSelector.this;
                imageSelector.animationStep = imageSelector.animationStep + step;
                if (ImageSelector.this.animationStep >= 1.0) {
                    ImageSelector.this.animationStep = -1.0;
                    ImageSelector imageSelector2 = ImageSelector.this;
                    imageSelector2.index = imageSelector2.index + increment;
                    ImageSelector.this.setCursor(ImageSelector.this.getDisplay().getSystemCursor(0));
                } else if (!ImageSelector.this.isDisposed()) {
                    ImageSelector.this.getDisplay().timerExec(50, (Runnable)this);
                }
            }
        });
    }

    private void addMouseListeners() {
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                for (ISItem item : ImageSelector.this.items) {
                    if (item.getUpperLeftCorner() == null || item.getLowerRightCorner() == null || e.x < item.getUpperLeftCorner().x || e.x > item.getLowerRightCorner().x || e.y < item.getUpperLeftCorner().y || e.y > item.getLowerRightCorner().y) continue;
                    ImageSelector.this.setCursor(ImageSelector.this.getDisplay().getSystemCursor(21));
                    return;
                }
                ImageSelector.this.setCursor(ImageSelector.this.getDisplay().getSystemCursor(0));
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                for (ISItem item : ImageSelector.this.items) {
                    if (item.getUpperLeftCorner() == null || item.getLowerRightCorner() == null || e.x < item.getUpperLeftCorner().x || e.x > item.getLowerRightCorner().x || e.y < item.getUpperLeftCorner().y || e.y > item.getLowerRightCorner().y) continue;
                    ImageSelector.this.scrollAndAnimateBy(ImageSelector.this.originalItems.indexOf(item) - ImageSelector.this.index);
                    return;
                }
            }
        });
        this.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                ImageSelector.this.scrollBy(-1 * event.count);
            }
        });
    }

    public List<ISItem> getItems() {
        return this.originalItems;
    }

    public void setItems(List<ISItem> items) {
        this.items = new ArrayList<ISItem>(items);
        this.originalItems = items;
        this.index = this.items.size() / 2;
        this.redraw();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        SWTGraphicUtil.dispose((Resource)this.font);
        this.font = font;
        this.redraw();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        this.redraw();
    }

    public int getMaxItemWidth() {
        return this.maxItemWidth;
    }

    public void setMaxItemWidth(int maxItemWidth) {
        this.maxItemWidth = maxItemWidth;
        this.redraw();
    }

    public double getSigma() {
        return this.sigma;
    }

    public float getSpacing() {
        return this.spacing;
    }

    public void setSpacing(float spacing) {
        this.spacing = spacing;
        this.redraw();
    }

    public Color getGradientStart() {
        return this.gradientStart;
    }

    public void setGradientStart(Color gradientStart) {
        SWTGraphicUtil.dispose((Resource)this.gradientStart);
        this.gradientStart = gradientStart;
        this.redraw();
    }

    public Color getGradientEnd() {
        return this.gradientEnd;
    }

    public void setGradientEnd(Color gradientEnd) {
        SWTGraphicUtil.dispose((Resource)this.gradientEnd);
        this.gradientEnd = gradientEnd;
        this.redraw();
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public void setPageIncrement(int pageIncrement) {
        this.pageIncrement = pageIncrement;
    }
}

