/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import java.text.ParseException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import zipeditor.Messages;
import zipeditor.MultiElementPropertyPage;
import zipeditor.ZipLabelProvider;
import zipeditor.model.Node;
import zipeditor.model.NodeProperty;

public abstract class NodePropertyPage
extends MultiElementPropertyPage {
    private Text fName;
    private Text fPath;
    private Text fType;
    private Text fDate;
    private Text fSize;

    protected Control createPropertiesSection(Composite parent) {
        Group control = new Group(parent, 0);
        control.setLayout((Layout)new GridLayout(2, false));
        MultiElementPropertyPage.MultiplePropertyAccessor accessor = new MultiElementPropertyPage.MultiplePropertyAccessor(Node.class);
        this.createLabel((Composite)control, NodeProperty.PNAME.toString(), 1);
        this.fName = this.createText((Composite)control, 30, 1, true);
        this.setFieldText(this.fName, accessor.getAccessor("name"));
        this.createLabel((Composite)control, NodeProperty.PTYPE.toString(), 1);
        this.fType = this.createText((Composite)control, 30, 1, false);
        this.setFieldText(this.fType, new MultiElementPropertyPage.PropertyAccessor(){

            @Override
            public Object getPropertyValue(Object object) {
                return ZipLabelProvider.getTypeLabel((Node)((Object)object));
            }
        });
        this.createLabel((Composite)control, NodeProperty.PPATH.toString(), 1);
        this.fPath = this.createText((Composite)control, 30, 1, false);
        this.setFieldText(this.fPath, accessor.getAccessor("path"));
        this.createLabel((Composite)control, NodeProperty.PDATE.toString(), 1);
        this.fDate = this.createText((Composite)control, 30, 1, true);
        this.setFieldText(this.fDate, new MultiElementPropertyPage.PropertyAccessor(){

            @Override
            public Object getPropertyValue(Object object) {
                return NodePropertyPage.this.formatDate(((Node)((Object)object)).getTime());
            }
        });
        this.createLabel((Composite)control, NodeProperty.PSIZE.toString(), 1);
        this.fSize = this.createText((Composite)control, 30, 1, false);
        this.setFieldText(this.fSize, new NodePropertyAccessor(this){

            @Override
            public Object getSinglePropertyValue(Node node) {
                return new Long(node.getSize());
            }
        }, true);
        return control;
    }

    protected Node[] getNodes() {
        IAdaptable[] elements = this.getElements();
        Node[] nodes = new Node[elements.length];
        int i = 0;
        while (i < nodes.length) {
            nodes[i] = (Node)((Object)elements[i].getAdapter(Node.class));
            ++i;
        }
        return nodes;
    }

    protected String formatDate(long time) {
        return ZipLabelProvider.formatDate(time);
    }

    protected long parseDate(String string) throws ParseException {
        return ZipLabelProvider.DATE_FORMAT.parse(string).getTime();
    }

    protected Label createLabel(Composite parent, String text, int hspan) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData(768);
        data.horizontalSpan = hspan;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createText(Composite parent, int width, int hspan, boolean editable) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = hspan;
        data.widthHint = this.convertWidthInCharsToPixels(width);
        text.setLayoutData((Object)data);
        text.setEditable(editable);
        return text;
    }

    public boolean performOk() {
        Node[] nodes = this.getNodes();
        String name = this.fName.getText();
        Long time = null;
        String dateText = this.fDate.getText();
        if (dateText.trim().length() > 0 && !this.nonEqualStringLabel.equals(dateText)) {
            try {
                time = new Long(this.parseDate(dateText));
                this.setErrorMessage(null);
            }
            catch (ParseException parseException) {
                String pattern = ZipLabelProvider.DATE_FORMAT.format(new Long(System.currentTimeMillis()));
                this.setErrorMessage(Messages.getFormattedString("NodePropertyPage.0", new Object[]{dateText, pattern}));
                return false;
            }
        }
        int i = 0;
        while (i < nodes.length) {
            if (!this.nonEqualStringLabel.equals(name)) {
                nodes[i].setName(name);
            }
            if (time != null) {
                nodes[i].setTime(time);
            }
            ++i;
        }
        return true;
    }

    protected abstract class NodePropertyAccessor
    implements MultiElementPropertyPage.PropertyAccessor {
        protected NodePropertyAccessor() {
        }

        @Override
        public Object getPropertyValue(Object object) {
            Node node = (Node)((Object)object);
            if (node.isFolder()) {
                Node[] children = node.getChildren();
                Object aggregate = this.getSinglePropertyValue(node);
                int i = 0;
                while (i < children.length) {
                    aggregate = this.aggregatePropertyValues(this.getPropertyValue((Object)children[i]), aggregate);
                    ++i;
                }
                return aggregate;
            }
            return this.getSinglePropertyValue(node);
        }

        protected Object aggregatePropertyValues(Object value1, Object value2) {
            if (value1 instanceof Number && value2 instanceof Number) {
                return new Long(((Number)value1).longValue() + ((Number)value2).longValue());
            }
            return value1;
        }

        protected abstract Object getSinglePropertyValue(Node var1);
    }
}

