/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.IFrameSource;
import zipeditor.TableFrame;

public class TableViewerFrameSource
implements IFrameSource {
    private TableViewer fViewer;

    public TableViewerFrameSource(TableViewer viewer) {
        this.fViewer = viewer;
    }

    public void connectTo(FrameList frameList) {
        frameList.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TableViewerFrameSource.this.handlePropertyChange(event);
            }
        });
    }

    protected TableFrame createFrame(Object input) {
        return new TableFrame(this.fViewer, input);
    }

    protected void frameChanged(TableFrame frame) {
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.setInput(frame.getInput());
        this.fViewer.setSelection(frame.getSelection(), true);
        this.fViewer.getControl().setRedraw(true);
    }

    protected Frame getCurrentFrame(int flags) {
        Object input = this.fViewer.getInput();
        TableFrame frame = this.createFrame(input);
        if ((flags & 1) != 0) {
            frame.setSelection(this.fViewer.getSelection());
        }
        return frame;
    }

    public Frame getFrame(int whichFrame, int flags) {
        switch (whichFrame) {
            case 1: {
                return this.getCurrentFrame(flags);
            }
            case 3: {
                return this.getParentFrame(flags);
            }
            case 2: {
                return this.getSelectionFrame(flags);
            }
        }
        return null;
    }

    protected Frame getParentFrame(int flags) {
        Object input = this.fViewer.getInput();
        ITreeContentProvider provider = (ITreeContentProvider)this.fViewer.getContentProvider();
        Object parent = provider.getParent(input);
        if (parent == null) {
            return null;
        }
        TableFrame frame = this.createFrame(parent);
        if ((flags & 1) != 0) {
            frame.setSelection(this.fViewer.getSelection());
        }
        return frame;
    }

    protected Frame getSelectionFrame(int flags) {
        IStructuredSelection sel = (IStructuredSelection)this.fViewer.getSelection();
        if (sel.size() == 1) {
            Object o = sel.getFirstElement();
            TableFrame frame = this.createFrame(o);
            if ((flags & 1) != 0) {
                frame.setSelection(this.fViewer.getSelection());
            }
            return frame;
        }
        return null;
    }

    public TableViewer getViewer() {
        return this.fViewer;
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        if ("currentFrame".equals(event.getProperty())) {
            this.frameChanged((TableFrame)((Object)event.getNewValue()));
        }
    }
}

