/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.sdblib.IDevice;

public class ConnectionExplorerOperation {
    private final Logger logger = LoggerFactory.getLogger(ConnectionExplorerOperation.class);

    public void openShell(IDevice device) {
        this.logger.info("open the shell");
        String sdbPath = InstallPathConfig.getSDBPath();
        String serial = device.getSerialNumber();
        String termPath = ConnectionPlugin.getDefault().getPreferenceStore().getString("terminal_path");
        ProcessBuilder procSdb = new ProcessBuilder(new String[0]);
        if (OSChecker.isWindows()) {
            termPath = String.format("%s %s -s %s shell", termPath, sdbPath, serial);
        } else if (OSChecker.isMAC()) {
            File term = new File(termPath);
            procSdb.directory(term.getParentFile());
            procSdb.command(termPath, serial);
        } else {
            termPath = String.format("%s %s -s %s shell", termPath, sdbPath, serial);
        }
        this.logger.info(procSdb.command().toString());
        try {
            String[] cmdArgs = termPath.split("\\s+");
            List<String> cmdList = Arrays.asList(cmdArgs);
            procSdb.command(cmdList);
            procSdb.start();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            DialogUtil.openErrorDialog((String)("Failed to open shell :\n" + e.getMessage()));
        }
    }
}

