/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.IOUtil;

public class ThreadFindReachable
extends Thread {
    public String ip;
    public boolean isReachable = false;
    public int port;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public ThreadFindReachable(String _ip) {
        this.setName(this.getClass().getName());
        this.ip = _ip;
    }

    @Override
    public void run() {
        InetAddress inet = null;
        Socket socket = null;
        Object in = null;
        Object dis = null;
        try {
            try {
                inet = InetAddress.getByName(this.ip);
                this.logger.debug("Start Thread for checking reachable ip: " + this.ip);
                if (inet.isReachable(4000)) {
                    this.logger.debug("Is reachable ip: " + this.ip);
                    socket = new Socket();
                    InetSocketAddress destAddr = new InetSocketAddress(this.ip, 26101);
                    this.logger.debug("before connect ip: " + this.ip);
                    socket.connect(destAddr, 20000);
                    this.logger.debug("after connect ip: " + this.ip);
                    this.isReachable = true;
                } else {
                    this.logger.debug("Is not reachable ip: " + this.ip);
                }
            }
            catch (IOException e) {
                this.logger.debug("Failed to connect: " + this.ip, (Throwable)e);
                IOUtil.tryClose((Object[])new Object[]{dis});
                IOUtil.tryClose((Object[])new Object[]{in});
                IOUtil.tryClose((Object[])new Object[]{socket});
                return;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{dis});
            IOUtil.tryClose((Object[])new Object[]{in});
            IOUtil.tryClose((Object[])new Object[]{socket});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{dis});
        IOUtil.tryClose((Object[])new Object[]{in});
        IOUtil.tryClose((Object[])new Object[]{socket});
    }
}

