/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;
import zipeditor.actions.ActionMessages;

public class DeferredMenuManager
extends MenuManager {
    private static final QualifiedName ID_PROPERTY_NAME = new QualifiedName(DeferredMenuManager.class.getName(), "type");
    private static final QualifiedName MENU_PROPERTY_NAME = new QualifiedName(DeferredMenuManager.class.getName(), "menu");
    private static int useCount;
    private Action fPendingAction = new Action(ActionMessages.getString("DeferredMenuManager.1")){};
    private int fCreateCount = useCount;

    public DeferredMenuManager(IContributionManager parent, String text, String id) {
        super(text, id);
        this.setParent(parent);
        this.fPendingAction.setId(this.getPendingId());
        super.add((IAction)this.fPendingAction);
    }

    public void add(IAction action) {
        this.removePendingAction();
        super.add(action);
    }

    private void removePendingAction() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DeferredMenuManager.this.remove(DeferredMenuManager.this.getPendingId());
            }
        });
    }

    public String getPendingId() {
        return String.valueOf(this.fPendingAction.getClass().getName()) + this.fPendingAction.hashCode();
    }

    public synchronized void finish() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IContributionItem[] items = DeferredMenuManager.this.getItems();
                if (items.length == 1 && DeferredMenuManager.this.getPendingId().equals(items[0].getId())) {
                    DeferredMenuManager.this.dispose();
                    DeferredMenuManager.this.removeAll();
                    DeferredMenuManager.this.getParent().remove((IContributionItem)DeferredMenuManager.this);
                } else {
                    DeferredMenuManager.this.remove(DeferredMenuManager.this.getPendingId());
                    DeferredMenuManager.this.update(false);
                }
            }
        });
    }

    public static void addToMenu(IMenuManager parentMenu, String parentId, String menuText, String menuId, MenuJob job) {
        DeferredMenuManager subMenu;
        Assert.isNotNull((Object)parentMenu);
        Assert.isNotNull((Object)((Object)job));
        DeferredMenuManager menuFromRunningJob = DeferredMenuManager.getMenuFromRunningJob(job.fFamily, job.fProperty);
        DeferredMenuManager deferredMenuManager = subMenu = menuFromRunningJob != null ? menuFromRunningJob : new DeferredMenuManager((IContributionManager)parentMenu, menuText, menuId);
        if (menuFromRunningJob == null) {
            job.setSystem(true);
            job.setProperty(ID_PROPERTY_NAME, job.fProperty);
            job.setProperty(MENU_PROPERTY_NAME, (Object)subMenu);
            job.fMenuManager = subMenu;
            job.schedule();
        } else {
            ++useCount;
        }
        if (parentId != null && parentMenu.find(parentId) != null) {
            parentMenu.appendToGroup(parentId, (IContributionItem)subMenu);
        } else {
            parentMenu.add((IContributionItem)subMenu);
        }
    }

    public boolean isVisible() {
        if (useCount == this.fCreateCount) {
            return super.isVisible();
        }
        if (this.getItems().length == 0) {
            super.add((IAction)this.fPendingAction);
        }
        return true;
    }

    public static boolean isRunning(Object jobFamily, Object propertyValue) {
        return DeferredMenuManager.getMenuFromRunningJob(jobFamily, propertyValue) != null;
    }

    private static DeferredMenuManager getMenuFromRunningJob(Object jobFamily, Object propertyValue) {
        Job[] jobs = Platform.getJobManager().find(jobFamily);
        DeferredMenuManager menuFromRunningJob = null;
        int i = 0;
        while (i < jobs.length) {
            Object property = jobs[i].getProperty(ID_PROPERTY_NAME);
            if (property == propertyValue || property != null && property.equals(propertyValue)) {
                menuFromRunningJob = (DeferredMenuManager)((Object)jobs[i].getProperty(MENU_PROPERTY_NAME));
            }
            ++i;
        }
        return menuFromRunningJob;
    }

    public static abstract class MenuJob
    extends Job {
        private DeferredMenuManager fMenuManager;
        protected Object fFamily;
        protected Object fProperty;

        public MenuJob(Object family, Object propertyValue) {
            super(ActionMessages.getString("DeferredMenuManager.0"));
            Assert.isNotNull((Object)family);
            this.fFamily = family;
            this.fProperty = propertyValue;
        }

        protected abstract IStatus addToMenu(IProgressMonitor var1, IMenuManager var2);

        protected IStatus run(IProgressMonitor monitor) {
            Assert.isNotNull((Object)((Object)this.fMenuManager));
            this.addToMenu(monitor, (IMenuManager)this.fMenuManager);
            this.fMenuManager.finish();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return this.fFamily.equals(family);
        }
    }
}

