/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui.helper;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.tizen.common.lv.model.LVResourceVO;

public class LVResourceEditingSupport
extends EditingSupport {
    private TableViewer viewer;
    private FileDialogCellEditor cellEditor;

    public LVResourceEditingSupport(TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
        this.cellEditor = new FileDialogCellEditor((Composite)viewer.getTable());
    }

    protected boolean canEdit(Object arg0) {
        return true;
    }

    protected CellEditor getCellEditor(Object object) {
        return this.cellEditor;
    }

    protected Object getValue(Object object) {
        if (object instanceof LVResourceVO) {
            return ((LVResourceVO)object).getResourcePath();
        }
        return "";
    }

    protected void setValue(Object element, Object resource) {
        if (element instanceof LVResourceVO && resource instanceof String) {
            ((LVResourceVO)element).setResourcePath((String)resource);
        }
        this.viewer.update(element, null);
    }

    private class FileDialogCellEditor
    extends DialogCellEditor {
        FileDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control paramControl) {
            return new FileDialog(paramControl.getShell()).open();
        }
    }
}

