/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui.resource;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.lv.message.LVMessages;
import org.tizen.common.lv.ui.LVResourceTab;
import org.tizen.common.ui.widget.CanvasButton;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ImageUtil;

public class ResourceTile
extends Canvas {
    private static final Color BACKGROUND = Display.getCurrent().getSystemColor(1);
    private static final Color BACKGROUND_GRAY = Display.getCurrent().getSystemColor(15);
    private int BUTTON_TOP = 20;
    private int BUTTON_LEFT = 25;
    private int BUTTON_RIGHT = -25;
    private int BUTTON_BOTTOM = -36;
    private int NAME_TOP = 65;
    private final Logger logger = LoggerFactory.getLogger(ResourceTile.class);
    private IProject project;
    private String filePath;
    private IFile file;
    private String name;
    private CanvasButton button;
    private Image image;
    private Image addImage;
    private Image defaultImage;
    private FileDialog fileSetdialog;
    private PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent event) {
            int x = event.gc.textExtent((String)((ResourceTile)ResourceTile.this).name).x;
            x = x < ResourceTile.this.getSize().x ? ResourceTile.this.getSize().x / 2 - x / 2 : 0;
            event.gc.drawText(ResourceTile.this.name, x, ResourceTile.this.NAME_TOP);
        }
    };

    public ResourceTile(Composite parent, IProject prj, String filePath, String locale) {
        super(parent, 0x20000000);
        this.project = prj;
        this.filePath = filePath;
        this.setLayout((Layout)new FormLayout());
        this.setBackground(BACKGROUND);
        this.fileSetdialog = new FileDialog(parent.getShell(), 65536);
        this.fileSetdialog.setText(LVMessages.RESOURCE_SET_SELECT_FILE);
        this.button = new CanvasButton((Composite)this, null, null);
        this.button.setBackground(BACKGROUND);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, this.BUTTON_TOP);
        formData.left = new FormAttachment(0, this.BUTTON_LEFT);
        formData.right = new FormAttachment(100, this.BUTTON_RIGHT);
        formData.bottom = new FormAttachment(100, this.BUTTON_BOTTOM);
        this.button.setLayoutData((Object)formData);
        this.setLocale(locale);
        this.button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                ResourceTile.this.setSelection();
                if (event.button != 1 || ResourceTile.this.file.exists()) {
                    return;
                }
                ResourceTile.this.setResourceUsingDialog();
            }

            public void mouseDoubleClick(MouseEvent event) {
                if (event.button != 1 || !ResourceTile.this.file.exists()) {
                    return;
                }
                ResourceTile.this.setResourceUsingDialog();
            }
        });
        this.addPaintListener(this.paintListener);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent paramMouseEvent) {
                ResourceTile.this.setSelection();
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode != 127) {
                    return;
                }
                if (ResourceTile.this.file.exists() && DialogUtil.openQuestionDialog((String)LVMessages.DELETE_RESOURCE_TITLE, (String)String.format(LVMessages.DELETE_RESOURCE_MESSAGE, ResourceTile.this.file.getProjectRelativePath())) == 64) {
                    try {
                        ResourceTile.this.file.delete(false, null);
                    }
                    catch (CoreException coreException) {
                        DialogUtil.openErrorDialog((String)String.format(LVMessages.CANNOT_DELETE_RESOURCE, ResourceTile.this.file.getProjectRelativePath()));
                    }
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent paramDisposeEvent) {
                ResourceTile.this.disposeResource((Resource)ResourceTile.this.image);
                ResourceTile.this.disposeResource((Resource)ResourceTile.this.addImage);
                ResourceTile.this.disposeResource((Resource)ResourceTile.this.defaultImage);
            }
        });
    }

    private void disposeResource(Resource resource) {
        if (resource != null) {
            resource.dispose();
        }
    }

    private void setResourceUsingDialog() {
        String filePath;
        String fileExtension = this.file.getFileExtension();
        if (fileExtension != null) {
            this.fileSetdialog.setFilterExtensions(new String[]{"*." + fileExtension, "*.*"});
        }
        if ((filePath = this.fileSetdialog.open()) == null) {
            return;
        }
        try {
            FileUtil.copyTo((String)filePath, (String)this.file.getLocation().toOSString());
            this.project.refreshLocal(2, null);
        }
        catch (IOException e) {
            this.logger.debug(e.getMessage());
            DialogUtil.openErrorDialog((String)String.format(LVMessages.ERROR_RESOURCE_SET, String.valueOf(this.file.getName()) + this.file.getFileExtension()));
        }
        catch (CoreException e) {
            this.logger.debug(e.getMessage());
            DialogUtil.openErrorDialog((String)String.format(LVMessages.ERROR_RESOURCE_SET, String.valueOf(this.file.getName()) + this.file.getFileExtension()));
        }
    }

    private void setSelection() {
        this.setFocus();
        this.setBackground(BACKGROUND_GRAY);
        this.button.setBackground(BACKGROUND_GRAY);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
        ISelectionProvider selProvider = viewPart.getSite().getSelectionProvider();
        selProvider.setSelection((ISelection)new StructuredSelection((Object)this.file));
        ResourceTile grayedTile = LVResourceTab.getGrayedTile();
        if (grayedTile != null && !grayedTile.isDisposed() && !((Object)((Object)grayedTile)).equals((Object)this)) {
            grayedTile.removeGray();
        }
        LVResourceTab.setGrayedTile(this);
    }

    public boolean setFocus() {
        return super.forceFocus();
    }

    public void setGray() {
        this.setBackground(BACKGROUND_GRAY);
        this.button.setBackground(BACKGROUND_GRAY);
    }

    public void removeGray() {
        this.setBackground(BACKGROUND);
        this.button.setBackground(BACKGROUND);
    }

    public void setLocale(String locale) {
        this.file = this.getResourceFileFromLocale(locale);
        this.name = this.file.getName();
        try {
            ImageData data = null;
            if (this.file.exists()) {
                data = new ImageData(this.file.getLocation().toOSString());
                this.image = new Image((Device)Display.getCurrent(), data);
                this.button.setImages(this.image, this.image);
            } else {
                this.addImage = ImageUtil.getImage((String)"org.tizen.common.lv", (String)"icons/elcl16/resource_add.png");
                this.button.setImages(this.addImage, this.addImage);
            }
        }
        catch (SWTException sWTException) {
            this.defaultImage = ImageUtil.getImage((String)"org.tizen.common.lv", (String)"icons/elcl16/file_add.png");
            this.button.setImages(this.defaultImage, this.defaultImage);
        }
    }

    private IFile getResourceFileFromLocale(String locale) {
        String localePath = "";
        if (locale != null && !locale.equals("default")) {
            localePath = "locales" + File.separator + locale + File.separator;
        }
        return this.project.getFile(String.valueOf(localePath) + this.filePath);
    }
}

