/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.run;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.run.IAuthProcessor;
import org.tizen.common.rest.util.OutputUtil;
import org.tizen.common.util.Assert;
import org.tizen.common.util.SWTUtil;

public class OAuthProcessor
implements IAuthProcessor {
    private static final String ACCESS_TOKEN = "access_token";
    private static final String REGEX_ACCESS_TOKEN = "access_token=(\\w+)";
    private static final Pattern accessTokenPattern = Pattern.compile("access_token=(\\w+)");
    private static final String HEADER_KEY_LOCATION = "location";
    private static final String PARAM_CODE = "code";
    private static final String PARAM_CLIENT_ID = "client_id";
    private static final String PARAM_CLIENT_SECRET = "client_secret";
    private static final String PARAM_GRANT_TYPE = "grant_type";
    private static final String PARAM_REDIRECT_URI = "redirect_uri";
    private MessageConsoleStream console;
    private Rectangle parentBounds;

    @Override
    public boolean authentication(Rectangle parentBounds, MessageConsoleStream console, DefaultHttpClient httpClient, String appId) {
        this.console = console;
        this.parentBounds = parentBounds;
        IPreferenceStore store = RestPlugin.getDefault().getPreferenceStore();
        String method = this.getValue(store, "PREF_KEY_AUTH_OAUTH_METHOD", appId);
        boolean accessTokenSelected = "PREF_VALUE_AUTH_OAUTH_METHOD_ACCESS_TOKEN".equals(method);
        boolean openBrowserForToken = Boolean.parseBoolean(this.getValue(store, "PREF_KEY_AUTH_OAUTH_OPEN_BROWSER_FOR_TOKEN", appId));
        String accessToken = this.getValue(store, "PREF_KEY_AUTH_OAUTH_ACCESS_TOKEN", appId);
        if (accessTokenSelected) {
            return this.authenticationWithAccessToken(httpClient, store, appId, accessToken, openBrowserForToken);
        }
        return this.authenticationWithAuthorizationCode(httpClient, store, appId);
    }

    private void openBrowser(boolean openBrowser, String url) {
        if (openBrowser && url.length() > 0) {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(url));
            }
            catch (PartInitException e) {
                RestPlugin.log(e);
            }
            catch (MalformedURLException e) {
                RestPlugin.log(e);
            }
        }
    }

    private boolean authenticationWithAccessToken(DefaultHttpClient httpClient, IPreferenceStore store, String appId, final String accessToken, final boolean openBrowserForToken) {
        String result;
        final String tokenUrl = this.getValue(store, "PREF_KEY_AUTH_OAUTH_TOKEN_URL", appId);
        try {
            Assert.hasText((String)tokenUrl);
        }
        catch (IllegalArgumentException e) {
            RestPlugin.log(e);
            return false;
        }
        FutureTask<String> task = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                OAuthProcessor.this.openBrowser(openBrowserForToken, tokenUrl);
                Shell shell = OAuthProcessor.this.createNewShell();
                InputDialog dialog = new InputDialog(shell, RestUIMessages.OAuthProcessor_inputDialog_token_title, RestUIMessages.OAuthProcessor_inputDialog_token_desc, accessToken, null);
                if (dialog.open() == 0) {
                    return dialog.getValue();
                }
                return null;
            }
        });
        task.run();
        try {
            result = task.get();
        }
        catch (InterruptedException e) {
            RestPlugin.log(e);
            return false;
        }
        catch (ExecutionException e) {
            RestPlugin.log(e);
            return false;
        }
        return this.authenticationWithAccessToken(httpClient, store, appId, result);
    }

    private boolean authenticationWithAccessToken(DefaultHttpClient httpClient, IPreferenceStore store, String appId, final String accessToken) {
        if (accessToken == null || accessToken.length() == 0) {
            return false;
        }
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_ACCESS_TOKEN", accessToken, appId);
        httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.setHeader("Authorization", "Bearer " + accessToken);
            }
        });
        return true;
    }

    private boolean authenticationWithAuthorizationCode(DefaultHttpClient httpClient, IPreferenceStore store, String appId) {
        String result;
        final boolean openBrowserForCode = Boolean.parseBoolean(this.getValue(store, "PREF_KEY_AUTH_OAUTH_OPEN_BROWSER_FOR_CODE", appId));
        final String codeUrl = this.getValue(store, "PREF_KEY_AUTH_OAUTH_CODE_URL", appId);
        String tokenUrlByCode = this.getValue(store, "PREF_KEY_AUTH_OAUTH_TOKEN_URL_BY_CODE", appId);
        String paramAs = this.getValue(store, "PREF_KEY_AUTH_OAUTH_PARAM_AS", appId);
        String clientId = this.getValue(store, "PREF_KEY_AUTH_OAUTH_CLIENT_ID", appId);
        String clientSecret = this.getValue(store, "PREF_KEY_AUTH_OAUTH_CLIENT_SECRET", appId);
        String redirectUri = this.getValue(store, "PREF_KEY_AUTH_OAUTH_REDIRECT_URI", appId);
        String grantType = this.getValue(store, "PREF_KEY_AUTH_OAUTH_GRANT_TYPE", appId);
        final String code = this.getValue(store, "PREF_KEY_AUTH_OAUTH_CODE", appId);
        String location = this.getValue(store, "PREF_KEY_AUTH_OAUTH_LOCATION_ACCESS_TOKEN", appId);
        try {
            Assert.hasText((String)codeUrl);
            Assert.hasText((String)tokenUrlByCode);
        }
        catch (IllegalArgumentException e) {
            RestPlugin.log(e);
            return false;
        }
        FutureTask<String> task = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() throws Exception {
                OAuthProcessor.this.openBrowser(openBrowserForCode, codeUrl);
                Shell shell = OAuthProcessor.this.createNewShell();
                InputDialog dialog = new InputDialog(shell, RestUIMessages.OAuthProcessor_inputDialog_code_title, RestUIMessages.OAuthProcessor_inputDialog_code_desc, code, null);
                if (dialog.open() == 0) {
                    return dialog.getValue();
                }
                return null;
            }
        });
        task.run();
        try {
            result = task.get();
        }
        catch (InterruptedException e) {
            RestPlugin.log(e);
            return false;
        }
        catch (ExecutionException e) {
            RestPlugin.log(e);
            return false;
        }
        try {
            Assert.hasText((String)result);
        }
        catch (IllegalArgumentException e) {
            RestPlugin.log(e);
            return false;
        }
        this.setValue(store, "PREF_KEY_AUTH_OAUTH_CODE", result, appId);
        boolean locationUrlSelected = "PREF_VALUE_AUTH_OAUTH_LOCATION_URL".equals(location);
        boolean paramAsUrl = "PREF_VALUE_AUTH_OAUTH_PARAM_AS_URL".equals(paramAs);
        HttpPost postMethod = new HttpPost(tokenUrlByCode);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (clientId.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair(PARAM_CLIENT_ID, clientId));
        }
        if (result.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair(PARAM_CODE, result));
        }
        if (redirectUri.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair(PARAM_REDIRECT_URI, redirectUri));
        }
        if (grantType.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair(PARAM_GRANT_TYPE, grantType));
        }
        if (clientSecret.length() > 0) {
            params.add((NameValuePair)new BasicNameValuePair(PARAM_CLIENT_SECRET, clientSecret));
        }
        if (paramAsUrl) {
            URI uri = this.makeUriWithQueryString(postMethod.getURI(), params);
            postMethod.setURI(uri);
        } else {
            this.fillParameters((HttpRequestBase)postMethod, params);
        }
        this.printRequest((HttpRequestBase)postMethod, params);
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)postMethod);
            String accessToken = this.parseAccessToken(response, locationUrlSelected);
            return this.authenticationWithAccessToken(httpClient, store, appId, accessToken);
        }
        catch (ClientProtocolException e) {
            RestPlugin.log(e);
            return false;
        }
        catch (IOException e) {
            RestPlugin.log(e);
            return false;
        }
    }

    private Shell createNewShell() {
        Shell shell = SWTUtil.getShell();
        Point size = shell.getSize();
        int x = this.parentBounds.x + this.parentBounds.width / 2 - size.x / 2;
        int y = this.parentBounds.y + this.parentBounds.height / 2 - size.y / 2;
        shell.setLocation(new Point(x, y));
        return shell;
    }

    private void printRequest(HttpRequestBase method, List<NameValuePair> params) {
        this.console.println("### OAuth Authentication Request ###");
        this.console.println(method.getURI().toString());
        this.console.println("### Request headers ###");
        Header[] headerArray = method.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header h = headerArray[n2];
            this.console.println(h.toString());
            ++n2;
        }
        this.console.println("### Request parameters ###");
        int i = 0;
        while (i < params.size()) {
            this.console.println(params.get(i).toString());
            ++i;
        }
    }

    private void fillParameters(HttpRequestBase method, List<NameValuePair> paramList) {
        if (paramList != null && paramList.size() > 0) {
            if (method instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase entityMethod = (HttpEntityEnclosingRequestBase)method;
                UrlEncodedFormEntity entity = null;
                try {
                    entity = new UrlEncodedFormEntity(paramList, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.fillInStackTrace();
                }
                if (entity != null) {
                    entityMethod.setEntity((HttpEntity)entity);
                }
            } else if (method instanceof HttpGet) {
                URI uri = this.makeUriWithQueryString(method.getURI(), paramList);
                method.setURI(uri);
            } else {
                BasicHttpParams params = new BasicHttpParams();
                for (NameValuePair pair : paramList) {
                    params.setParameter(pair.getName(), (Object)pair.getValue());
                }
                method.setParams((HttpParams)params);
            }
        }
    }

    private URI makeUriWithQueryString(URI srcUri, List<NameValuePair> paramList) {
        if (paramList != null && paramList.size() > 0) {
            String uriStr = String.valueOf(srcUri.toString()) + "?";
            String query = "";
            Iterator<NameValuePair> itor = paramList.iterator();
            while (itor.hasNext()) {
                NameValuePair pair = itor.next();
                String key = pair.getName();
                String value = pair.getValue();
                try {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                query = String.valueOf(query) + key + "=" + value;
                if (!itor.hasNext()) continue;
                query = String.valueOf(query) + "&";
            }
            URI uri = URI.create(String.valueOf(uriStr) + query);
            return uri;
        }
        return srcUri;
    }

    private String parseResponse(HttpResponse response, boolean printBody) throws ParseException, IOException {
        StatusLine status = response.getStatusLine();
        this.console.println("### Response Status ###\n" + status);
        Header[] headers = response.getAllHeaders();
        this.console.println("### Response Header ###");
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header h = headerArray[n2];
            this.console.println(h.toString());
            ++n2;
        }
        HttpEntity entity = response.getEntity();
        String content = EntityUtils.toString((HttpEntity)entity);
        if (printBody) {
            this.console.println("### Response Contents ###");
            this.console.println(String.valueOf(content) + "\n");
        }
        return content;
    }

    private String parseAccessToken(HttpResponse response, boolean locationUrlSelected) throws ParseException, IOException {
        if (locationUrlSelected) {
            this.parseResponse(response, false);
            String accessToken = null;
            if (response.getFirstHeader(HEADER_KEY_LOCATION) != null) {
                String location = response.getFirstHeader(HEADER_KEY_LOCATION).getValue();
                this.console.println("location header : " + location);
                Matcher m = accessTokenPattern.matcher(location);
                if (m.find()) {
                    accessToken = m.group(1);
                }
            }
            return accessToken;
        }
        String content = this.parseResponse(response, true);
        Map map = OutputUtil.fromJson(Map.class, content);
        return (String)map.get(ACCESS_TOKEN);
    }

    private String getValue(IPreferenceStore store, String key, String appId) {
        key = this.getKeyByAppId(key, appId);
        return store.getString(key);
    }

    private void setValue(IPreferenceStore store, String key, String value, String appId) {
        key = this.getKeyByAppId(key, appId);
        store.setValue(key, value);
    }

    private String getKeyByAppId(String originalKey, String appId) {
        String result = originalKey;
        if (appId != null && appId.length() > 0) {
            result = String.valueOf(result) + "." + appId;
        }
        return result;
    }
}

