/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.util.IOUtil;
import org.tizen.sdblib.util.FilenameUtil;

public class Resource
implements IResource {
    protected String path;
    private FileHandler fh;

    public Resource(FileHandler fh, String path) {
        this.fh = fh;
        this.path = path;
    }

    @Override
    public String getName() {
        return FilenameUtil.getFilename((String)this.path);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public InputStream getContents() throws IOException {
        return this.getFileHandler().read(this.path);
    }

    @Override
    public void setContents(InputStream in) throws IOException {
        this.getFileHandler().write(this.path, in);
    }

    @Override
    public void setContents(byte[] contents) throws IOException {
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(contents);
            this.setContents(bais);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(bais);
            throw throwable;
        }
        IOUtil.tryClose(bais);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.fh).append((Object)this.path).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)obj;
        return new EqualsBuilder().append((Object)this.fh, (Object)other.fh).append((Object)this.path, (Object)other.path).isEquals();
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public FileHandler getFileHandler() {
        return this.fh;
    }
}

