/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.log;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.connection.log.LogPanel;
import org.tizen.common.connection.log.LogTab;
import org.tizen.common.connection.log.LogUIMessages;
import org.tizen.common.ui.dialog.FileDialogUtils;
import org.tizen.common.util.StringUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.util.DeviceUtil;

public class AddViewDialog
extends Dialog {
    private static final int DLG_WIDTH = 400;
    private Shell parent;
    private Shell shell;
    private String dialogName = null;
    private boolean bOk = false;
    private LogTab oldTab = null;
    private static final String TEMPNAME = "LogTab-#";
    private static int cnt = 0;
    private String tabName = null;
    private String device = null;
    private String pidKeyword = null;
    private String tagKeyword = null;
    private String msgKeyword = null;
    private Text tabNameText;
    private Text tagText;
    private Text pidText;
    private Text msgText;
    private Button okButton;

    public AddViewDialog(Shell pParent) {
        super(pParent, 67680);
    }

    public AddViewDialog(Shell pParent, String deviceName) {
        super(pParent, 67680);
        this.device = deviceName;
        this.dialogName = "Add LogTab";
    }

    public AddViewDialog(Shell pParent, LogTab tab) {
        super(pParent, 67680);
        if (tab != null) {
            this.dialogName = "Edit LogTab";
            this.tabName = tab.getLogTabName();
            if (tab.getDeviceSerialNumber() == null) {
                return;
            }
            this.device = tab.getDeviceSerialNumber();
            this.pidKeyword = tab.getLogFilter().getPidInput();
            this.tagKeyword = tab.getLogFilter().getTagInput();
            this.msgKeyword = tab.getLogFilter().getMsgInput();
            this.oldTab = tab;
        }
    }

    public boolean open() {
        this.createUI();
        if (this.parent == null || this.shell == null) {
            return false;
        }
        this.shell.pack();
        Rectangle r = this.parent.getBounds();
        int dlgHeight = this.shell.getBounds().height;
        int cx = r.x + r.width / 2;
        int x = cx - 200;
        int cy = r.y + r.height / 2;
        int y = cy - dlgHeight / 2;
        this.shell.setBounds(x, y, 400, dlgHeight);
        this.shell.open();
        Display display = this.parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.bOk;
    }

    private void createUI() {
        this.parent = this.getParent();
        this.shell = new Shell(this.parent, this.getStyle());
        this.shell.setText(this.dialogName);
        this.shell.setLayout((Layout)new GridLayout(1, false));
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        Group top = new Group((Composite)this.shell, 4);
        top.setText("LogTab");
        top.setLayoutData((Object)new GridData(1808));
        top.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label((Composite)top, 0);
        l.setText("Name:");
        this.tabNameText = new Text((Composite)top, 2052);
        if (this.tabName != null) {
            this.tabNameText.setText(this.tabName);
        }
        this.tabNameText.setLayoutData((Object)new GridData(768));
        l = new Label((Composite)top, 0);
        l.setText("Device:");
        final Combo dCombo = new Combo((Composite)top, 0x100000C);
        GridData gd = new GridData(768);
        dCombo.setLayoutData((Object)gd);
        IDevice[] devices = SmartDevelopmentBridge.getBridge().getDevices();
        if (devices.length != 0) {
            IDevice[] iDeviceArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                IDevice d = iDeviceArray[n2];
                if (DeviceUtil.isOnline((IDevice)d)) {
                    dCombo.add(d.getSerialNumber());
                }
                ++n2;
            }
            if (this.device != null) {
                int i = 0;
                while (i < devices.length) {
                    if (this.device.equals(devices[i].getSerialNumber())) {
                        dCombo.select(i);
                        break;
                    }
                    ++i;
                }
            } else {
                dCombo.select(0);
                this.device = dCombo.getItem(0);
            }
        }
        Group mid = new Group((Composite)this.shell, 4);
        mid.setText("Search keywords");
        mid.setLayoutData((Object)new GridData(1808));
        mid.setLayout((Layout)new GridLayout(2, false));
        l = new Label((Composite)mid, 0);
        l.setText("Tag:");
        this.tagText = new Text((Composite)mid, 2052);
        if (this.tagKeyword != null) {
            this.tagText.setText(this.tagKeyword);
        }
        this.tagText.setMessage(LogUIMessages.Log_TAB_FILTER);
        this.tagText.setToolTipText(LogUIMessages.Log_TAB_FILTER_TOOLTIP);
        this.tagText.setLayoutData((Object)new GridData(768));
        l = new Label((Composite)mid, 0);
        l.setText("Pid:");
        this.pidText = new Text((Composite)mid, 2052);
        if (this.pidKeyword != null) {
            this.pidText.setText(this.pidKeyword);
        }
        this.pidText.setMessage(LogUIMessages.Log_TAB_FILTER);
        this.pidText.setToolTipText(LogUIMessages.Log_TAB_FILTER_TOOLTIP);
        this.pidText.setLayoutData((Object)new GridData(768));
        l = new Label((Composite)mid, 0);
        l.setText("Message:");
        this.msgText = new Text((Composite)mid, 2052);
        if (this.msgKeyword != null) {
            this.msgText.setText(this.msgKeyword);
        }
        this.msgText.setMessage(LogUIMessages.Log_TAB_FILTER);
        this.msgText.setToolTipText(LogUIMessages.Log_TAB_FILTER_TOOLTIP);
        this.msgText.setLayoutData((Object)new GridData(768));
        Composite bottomComp = new Composite((Composite)this.shell, 0);
        bottomComp.setLayoutData((Object)new GridData(64));
        bottomComp.setLayout((Layout)new GridLayout(2, true));
        this.okButton = new Button(bottomComp, 0);
        this.okButton.setText("OK");
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newName = AddViewDialog.this.tabNameText.getText();
                for (LogTab tab : LogPanel.logTabList) {
                    int ret;
                    if (!tab.getLogTabName().equals(newName) || AddViewDialog.this.oldTab != null && AddViewDialog.this.oldTab == tab || (ret = FileDialogUtils.checkTabName((String)newName)) != 0) continue;
                    return;
                }
                AddViewDialog.this.bOk = true;
                if (StringUtil.isEmpty((CharSequence)AddViewDialog.this.tabNameText.getText())) {
                    StringBuilder stringBuilder = new StringBuilder(AddViewDialog.TEMPNAME);
                    int n = cnt;
                    cnt = n + 1;
                    AddViewDialog.this.tabName = stringBuilder.append(n).toString();
                } else {
                    AddViewDialog.this.tabName = AddViewDialog.this.tabNameText.getText();
                }
                if (StringUtil.isEmpty((CharSequence)AddViewDialog.this.tagText.getText())) {
                    AddViewDialog.this.tagKeyword = null;
                } else {
                    AddViewDialog.this.tagKeyword = AddViewDialog.this.tagText.getText();
                }
                if (StringUtil.isEmpty((CharSequence)AddViewDialog.this.pidText.getText())) {
                    AddViewDialog.this.pidKeyword = null;
                } else {
                    AddViewDialog.this.pidKeyword = AddViewDialog.this.pidText.getText();
                }
                if (StringUtil.isEmpty((CharSequence)AddViewDialog.this.msgText.getText())) {
                    AddViewDialog.this.msgKeyword = null;
                } else {
                    AddViewDialog.this.msgKeyword = AddViewDialog.this.msgText.getText();
                }
                AddViewDialog.this.device = dCombo.getItem(dCombo.getSelectionIndex());
                AddViewDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(this.okButton);
        Button cancelButton = new Button(bottomComp, 0);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddViewDialog.this.shell.close();
            }
        });
    }

    public String getName() {
        return this.tabName;
    }

    public String getDevice() {
        return this.device;
    }

    public String getPidKeyword() {
        return this.pidKeyword;
    }

    public String getTagKeyword() {
        return this.tagKeyword;
    }

    public String getMsgKeyword() {
        return this.msgKeyword;
    }

    public void setName(String name) {
        this.tabName = name;
    }
}

