/*
 * Command line interface
 *
 * Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Contact: 
 * BonYong Lee <bonyong.lee@samsung.com>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Contributors:
 * - S-Core Co., Ltd
 *
 */
package org.tizen.cli.util;

import static org.tizen.common.util.ObjectUtil.nvl;
import static org.tizen.common.util.StringUtil.nvl;

import java.util.Collection;

import org.tizen.common.config.Preference;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.prompter.GenericOption;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.template.CommonTemplate;
import org.tizen.common.verrari.template.StandardTemplate;

public class
TemplateModelProvider
implements IModelProvider
{
    protected static final Object NULL = new Object();
    
    protected final ExecutionContext context;
    
    
    public
    TemplateModelProvider(
        final ExecutionContext context
    )
    {
        this.context = context;
    }

    @Override
    public boolean isEmpty()
    {
        return false;
    }

    @Override
    public Collection<String> keys()
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public
    Object
    getModel(
        final String key
    )
    {
        Object obj = context.getValue( key );
        if ( NULL.equals( obj ) )
        {
            return null;
        } else if ( null != obj )
        {
            return obj;
        }
        
        obj = Preference.getValue( key, null );
        if ( null != obj )
        {
            return obj;
        }
        
        obj = inputFromUser( key );
        
        this.context.setValue( key, nvl( obj, NULL ) );
        
        return obj;
    }

    protected Object inputFromUser( final String key )
    {
        final Prompter prompter = this.context.getPrompter();
        final GenericOption opt = new GenericOption();

        CommonTemplate current = CommonTemplate.getCurrentTemplate();
        String message = "Input " + key + " ?";
        if ( null != current )
        {
            message = nvl( current.getMessage( key ), message );
        }
        prompter.interact( message, opt );
        
        return opt.getAnswer();
    }

}
