/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.builder;

import java.util.Collection;
import java.util.HashSet;
import org.tizen.common.builder.error.BuildErrorInfo;
import org.tizen.common.builder.error.Location;
import org.tizen.common.file.IResource;
import org.tizen.common.util.CollectionMap;

public class BuildResult {
    CollectionMap<IResource, IResource> in2out = new CollectionMap();
    private Collection<BuildErrorInfo> buildErrInfos = new HashSet<BuildErrorInfo>();
    public static final int SEVERITY_ERROR = 2;
    public static final int SEVERITY_WARNING = 1;
    private Status result = Status.UNKNOWN;

    public BuildResult(Status result) {
        this.result = result;
    }

    public void addDependency(IResource in, IResource out) {
        this.in2out.put((Object)in, (Object)out);
        this.result = Status.SUCCESS;
    }

    public Collection<IResource> getInputs() {
        return this.in2out.keySet();
    }

    public Collection<IResource> getOutputs(IResource input) {
        return this.in2out.get((Object)input);
    }

    public Status getResult() {
        return this.result;
    }

    public Collection<BuildErrorInfo> getBuildErrorInfos() {
        return this.buildErrInfos;
    }

    public void addBuildErrorInfo(IResource resource, int lineNumber, int offset, int severity, String message) {
        this.buildErrInfos.add(new BuildErrorInfo(new Location(resource, lineNumber, offset), severity, message));
        if (!Status.ERROR.equals((Object)this.result)) {
            if (severity == 2) {
                this.result = Status.ERROR;
            } else if (severity == 1) {
                this.result = Status.WARNING;
            }
        }
    }

    public void setResult(Status result) {
        this.result = result;
    }

    public String toString() {
        return this.getResult().toString();
    }

    public static enum Status {
        UNKNOWN,
        SUCCESS,
        ERROR,
        WARNING;

    }
}

