/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.lv.ITizenLocalizer;
import org.tizen.common.lv.ITizenLocalizerAdapter;
import org.tizen.common.lv.manager.LVLocaleManager;
import org.tizen.common.lv.manager.LVResourceManager;
import org.tizen.common.lv.manager.LVStringManager;
import org.tizen.common.lv.model.LVLocaleVO;
import org.tizen.common.lv.model.LVStringVO;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.StringUtil;

public class LVManager {
    private static Map<IProject, LVManager> managers = new HashMap<IProject, LVManager>();
    private static Map<Class<? extends ITizenProject>, ITizenLocalizer> localizerMap = new HashMap<Class<? extends ITizenProject>, ITizenLocalizer>();
    private static LVManager defaultManager = null;
    private IProject project;
    private ITizenLocalizer localizer;
    private LVLocaleManager localeManager;
    private LVStringManager stringManager;
    private LVResourceManager resourceManager;

    public LVManager() {
        this.project = null;
        this.localizer = null;
        this.localeManager = new LVLocaleManager();
        this.stringManager = new LVStringManager();
        this.resourceManager = new LVResourceManager();
    }

    public LVManager(IProject project) {
        this.project = project;
        this.localizer = this.getLocalizer();
        this.localeManager = new LVLocaleManager(project);
        this.stringManager = new LVStringManager(project);
        this.resourceManager = new LVResourceManager(project);
    }

    public static LVManager getManager(IProject project) {
        LVManager manager = null;
        if (project != null && ProjectUtil.isTizenProject((IProject)project) && !ProjectUtil.isTizenNativeProject((IProject)project)) {
            if (managers.containsKey(project)) {
                manager = managers.get(project);
            } else {
                manager = new LVManager(project);
                managers.put(project, manager);
                manager.getLocalizer().readLocalizedContent(project);
            }
            return manager;
        }
        manager = LVManager.getDefaultManager();
        return manager;
    }

    public static LVManager getDefaultManager() {
        if (defaultManager == null) {
            defaultManager = new LVManager();
        }
        return defaultManager;
    }

    public ITizenLocalizer getLocalizer() {
        ITizenLocalizer localizer = null;
        if (this.project != null) {
            ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)this.project);
            Class<?> tizenPrjClass = tizenProject.getClass();
            if (localizerMap.containsKey(tizenPrjClass)) {
                localizer = localizerMap.get(tizenPrjClass);
            } else {
                localizer = this.loadLocalizer(this.project);
                localizerMap.put(tizenPrjClass, localizer);
                LVLocaleManager.getSupportLocalesMap(localizer);
            }
        }
        return localizer;
    }

    private ITizenLocalizer loadLocalizer(IProject project) {
        IConfigurationElement[] ces;
        ITizenLocalizer localizer = null;
        IExtensionRegistry x = RegistryFactory.getRegistry();
        IConfigurationElement[] iConfigurationElementArray = ces = x.getConfigurationElementsFor("org.tizen.common.lv.localizer.adapter");
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            String className;
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if ("adapter".equals(ce.getName()) && (className = ce.getAttribute("class")) != null) {
                try {
                    ITizenLocalizerAdapter adapter;
                    Object obj = ce.createExecutableExtension("class");
                    if (obj instanceof ITizenLocalizerAdapter && (adapter = (ITizenLocalizerAdapter)obj).canHandle(project) && (localizer = adapter.getTizenLocalizer()) != null) {
                        break;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return localizer;
    }

    public Map<String, LVLocaleVO> getSupportLocaleMap() {
        if (this.localizer == null) {
            return new HashMap<String, LVLocaleVO>();
        }
        return LVLocaleManager.getSupportLocalesMap(this.localizer);
    }

    public List<LVLocaleVO> getTargetLocaleList() {
        return this.localeManager.getTargetLocaleList();
    }

    public List<String> getTargetLocaleLanguageTagList() {
        return this.localeManager.getTargetLocaleLanguageTagList();
    }

    public void addTargetLocales(LVLocaleVO[] newLocales, boolean bFolderCreating) {
        this.localeManager.add(newLocales);
        if (bFolderCreating) {
            this.localizer.createLocaleFolder(this.project, newLocales);
        }
    }

    public void addTargetLocales(LVLocaleVO[] newLocales) {
        this.addTargetLocales(newLocales, true);
    }

    public void removeTargetLocale(LVLocaleVO[] oldLocales) {
        this.localeManager.remove(oldLocales);
        LVLocaleVO[] lVLocaleVOArray = oldLocales;
        int n = oldLocales.length;
        int n2 = 0;
        while (n2 < n) {
            LVLocaleVO locale = lVLocaleVOArray[n2];
            this.stringManager.delete(locale);
            ++n2;
        }
        this.localizer.deleteLocaleFolder(this.project, oldLocales);
    }

    public List<LVLocaleVO> getTargetLocaleListWithoutDefault() {
        ArrayList<LVLocaleVO> localeList = new ArrayList<LVLocaleVO>();
        if (this.project != null) {
            List<LVLocaleVO> targetLocaleList = this.localeManager.getTargetLocaleList();
            for (LVLocaleVO locale : targetLocaleList) {
                if (locale == LVLocaleManager.defaultLocale) continue;
                localeList.add(locale);
            }
        }
        return localeList;
    }

    public static LVLocaleVO getDefaultLocale() {
        return LVLocaleManager.defaultLocale;
    }

    public List<LVStringVO> getDefaultList() {
        return this.stringManager.getDefaultList();
    }

    public List<LVStringVO> getStringList(LVLocaleVO locale) {
        return this.stringManager.getList(locale);
    }

    public List<LVStringVO> getStringList(String id) {
        return this.stringManager.getList(id);
    }

    public void addStrings(List<LVStringVO> list) {
        this.addStrings(list, true);
    }

    public void addStrings(List<LVStringVO> list, boolean fUpdate) {
        LVStringVO defaultSVO = null;
        for (LVStringVO svo : list) {
            if (svo.getLocale().equals(LVManager.getDefaultLocale())) {
                defaultSVO = svo;
            }
            this.stringManager.add(svo);
        }
        if (defaultSVO != null) {
            List<LVStringVO> stringList = this.getStringList(defaultSVO.getId());
            for (LVStringVO svo : stringList) {
                if (!StringUtil.isEmpty((CharSequence)svo.getValue())) continue;
                svo.setValue(defaultSVO.getValue());
            }
        }
        if (fUpdate) {
            this.localizer.updateStrings(this.project);
        }
    }

    public void removeStrings(LVLocaleVO locale) {
        this.stringManager.delete(locale);
        this.localizer.removeStringsByLocale(this.project, locale);
    }

    public void removeString(String id) {
        this.stringManager.delete(id);
        this.localizer.removeStringsById(this.project, id);
    }

    public void updateString(LVStringVO svo) {
        this.localizer.updateString(this.project, svo);
    }

    public void projectDeleted(IResourceChangeEvent event) {
        IProject project;
        IResource resource = event.getResource();
        if (resource != null && 4 == resource.getType() && managers.containsKey(project = (IProject)resource)) {
            managers.get(project).clear();
        }
    }

    public void updateDelta(IResourceDelta delta) {
        this.resourceManager.updateDelta(delta);
    }

    public void clear() {
        if (this.localeManager != null) {
            this.localeManager.clear();
            this.localeManager = null;
        }
        if (this.stringManager != null) {
            this.stringManager.clear();
            this.stringManager = null;
        }
        if (this.resourceManager != null) {
            this.resourceManager.clear();
            this.resourceManager = null;
        }
        managers.remove(this.project);
        this.project = null;
    }

    public boolean isValidKey(String key) {
        return this.localizer.isValidKey(key);
    }

    public LVResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void ImportContent(File file) {
        this.localizer.ImportLocalizedString(this.project, file);
    }

    public void exportContent(File file) {
        this.localizer.exportLocalizedString(this.project, file);
    }
}

