/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.UpAction;
import org.tizen.common.externals.decorator.PackageDecorator;
import zipeditor.LocalFileEditorInput;
import zipeditor.Messages;
import zipeditor.PreferenceInitializer;
import zipeditor.TableFrame;
import zipeditor.TableViewerFrameSource;
import zipeditor.Utils;
import zipeditor.ZipContentProvider;
import zipeditor.ZipEditorActionBarContributor;
import zipeditor.ZipEditorDragAdapter;
import zipeditor.ZipEditorDropAdapter;
import zipeditor.ZipEditorPlugin;
import zipeditor.ZipLabelProvider;
import zipeditor.ZipOutlinePage;
import zipeditor.ZipSorter;
import zipeditor.actions.ActionMessages;
import zipeditor.actions.CollapseAllAction;
import zipeditor.actions.NewFolderAction;
import zipeditor.actions.OpenActionGroup;
import zipeditor.actions.RenameNodeAction;
import zipeditor.actions.ReverseSelectionAction;
import zipeditor.actions.SelectAllAction;
import zipeditor.actions.SelectPatternAction;
import zipeditor.actions.ToggleViewModeAction;
import zipeditor.actions.ZipActionGroup;
import zipeditor.model.IModelListener;
import zipeditor.model.Node;
import zipeditor.model.ZipModel;

public class ZipEditor
extends EditorPart
implements IPropertyChangeListener,
ZipModel.IErrorReporter {
    private StructuredViewer fZipViewer;
    private IToolBarManager fToolBar;
    private ZipActionGroup fZipActionGroup;
    private OpenActionGroup fOpenActionGroup;
    private Map fActions = new HashMap();
    private IResourceChangeListener fInputFileListener;
    private ZipModel fModel;
    private long fModelModified;
    private ZipOutlinePage fOutlinePage;
    private FrameList fFrameList;
    private IMemento fState;
    private boolean fCheckedDeletion;
    private ISelectionChangedListener fOutlineSelectionChangedListener;
    private DisposeListener fTableDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            ZipEditor.this.storeTableColumnPreferences();
        }
    };
    public static final String ACTION_TOGGLE_MODE = "ToggleViewMode";
    public static final String ACTION_COLLAPSE_ALL = "CollapseAll";
    public static final String ACTION_SELECT_ALL = "SelectAll";
    public static final String ACTION_SELECT_PATTERN = "SelectPattern";
    public static final String ACTION_REVERSE_SELECTION = "ReverseSelection";
    public static final String ACTION_NEW_FOLDER = "NewFolder";
    public static final String ACTION_BACK = "Back";
    public static final String ACTION_FORWARD = "Forward";
    public static final String ACTION_UP = "Up";
    public static final String ACTION_GO_INTO = "GoInto";
    public static final String ACTION_RENAME = "Rename";

    public Image getTitleImage() {
        IEditorInput editorInput = this.getEditorInput();
        IFile file = null;
        if (editorInput instanceof IFileEditorInput) {
            file = ((IFileEditorInput)editorInput).getFile();
        }
        if (file != null && file.exists()) {
            String fileExtension = file.getFileExtension();
            if ("WGT".equalsIgnoreCase(fileExtension)) {
                return PackageDecorator.IMAGE_WGT;
            }
            if ("TPK".equalsIgnoreCase(fileExtension) || "TEP".equalsIgnoreCase(fileExtension)) {
                return PackageDecorator.IMAGE_TPK;
            }
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorInput input = this.doGetEditorInput();
        if (input instanceof IFileEditorInput) {
            this.internalSave(((IFileEditorInput)input).getFile().getLocation(), monitor);
        } else if (input instanceof IPathEditorInput) {
            this.internalSave(((IPathEditorInput)input).getPath(), monitor);
        } else if (input instanceof IURIEditorInput) {
            this.internalSave((IPath)new Path(((IURIEditorInput)input).getURI().getPath()), monitor);
        } else {
            this.fModel.logError("The input " + input + " cannot be saved");
        }
    }

    private void internalSave(IPath locationPath, IProgressMonitor monitor) {
        block18: {
            Node root = this.getRootNode();
            monitor.beginTask(Messages.getString("ZipEditor.3"), 100);
            monitor.worked(1);
            int totalWork = Utils.computeTotalNumber(root.getChildren(), monitor);
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 99);
            monitor.setTaskName(Messages.getString("ZipEditor.2"));
            monitor.subTask(locationPath.lastSegment());
            subMonitor.beginTask(String.valueOf(Messages.getString("ZipEditor.2")) + locationPath, totalWork);
            InputStream in = null;
            try {
                try {
                    in = root.getModel().save(ZipModel.typeFromName(locationPath.lastSegment()), (IProgressMonitor)subMonitor);
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(locationPath);
                    IEditorInput newInput = null;
                    newInput = file != null ? this.internalSaveWorkspaceFile(file, in, monitor) : this.internalSaveLocalFile(locationPath.toFile(), in);
                    this.doFirePropertyChange(257);
                    this.setInput(newInput);
                    if (Utils.isUIThread()) {
                        this.setPartName(newInput.getName());
                    } else {
                        final String newName = newInput.getName();
                        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ZipEditor.this.setPartName(newName);
                            }
                        });
                    }
                    this.doRevert();
                }
                catch (Exception e) {
                    if (Utils.isUIThread()) {
                        this.doShowErrorDialog(e);
                    } else {
                        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ZipEditor.this.doShowErrorDialog(e);
                            }
                        });
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    subMonitor.done();
                    monitor.done();
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                subMonitor.done();
                monitor.done();
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            subMonitor.done();
            monitor.done();
        }
    }

    private void doShowErrorDialog(Throwable e) {
        ZipEditorPlugin.showErrorDialog(this.getSite().getShell(), Messages.getFormattedString("ZipEditor.12", this.getEditorInput().getName()), e);
    }

    private IEditorInput internalSaveWorkspaceFile(IFile file, InputStream in, IProgressMonitor monitor) throws Exception {
        if (file.exists()) {
            file.setContents(in, true, true, monitor);
        } else {
            file.create(in, true, monitor);
        }
        return new FileEditorInput(file);
    }

    private IEditorInput internalSaveLocalFile(File file, InputStream in) throws Exception {
        Utils.readAndWrite(in, new FileOutputStream(file), true);
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getParentFile().getAbsolutePath()));
        fileStore = fileStore.getChild(file.getName());
        return new LocalFileEditorInput(fileStore);
    }

    public void doSaveAs() {
        IFile original;
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getShell());
        IEditorInput input = this.doGetEditorInput();
        IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
        if (original != null) {
            dialog.setOriginalFile(original);
        }
        dialog.create();
        if (dialog.open() == 1) {
            return;
        }
        final IPath filePath = dialog.getResult();
        if (filePath == null) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                ZipEditor.this.internalSave(ResourcesPlugin.getWorkspace().getRoot().getFile(filePath).getLocation(), monitor);
            }
        };
        try {
            this.getSite().getWorkbenchWindow().run(true, true, op);
        }
        catch (Exception e) {
            this.fModel.logError(e);
        }
    }

    public void doRevert() {
        if (this.fModel != null) {
            this.fModel.dispose();
        }
        this.fModel = null;
        this.doFirePropertyChange(257);
        this.setViewerInput(this.fZipViewer);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        this.fInputFileListener = new InputFileListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fInputFileListener);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void setInput(IEditorInput input) {
        if (input != this.getEditorInput()) {
            super.setInput(input);
            this.doFirePropertyChange(258);
            if (this.fOutlinePage != null) {
                this.fOutlinePage.setInput(this.fModel.getRoot());
            }
        }
    }

    private void doFirePropertyChange(final int property) {
        if (Utils.isUIThread()) {
            this.firePropertyChange(property);
        } else {
            this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ZipEditor.this.firePropertyChange(property);
                }
            });
        }
    }

    public void close() {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ZipEditor.this.getSite().getPage().closeEditor((IEditorPart)ZipEditor.this, false);
            }
        });
    }

    public void dispose() {
        if (this.fInputFileListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fInputFileListener);
            this.fInputFileListener = null;
        }
        if (this.fOutlinePage != null) {
            this.fOutlinePage.removeSelectionChangedListener(this.fOutlineSelectionChangedListener);
            this.fOutlinePage.dispose();
        }
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fActions.clear();
        this.fActions = null;
        this.fOpenActionGroup.dispose();
        this.fZipActionGroup.dispose();
        super.dispose();
    }

    private ZipModel createModel() {
        Object[] info = this.getEditorInputFileInfo(true);
        File file = (File)info[0];
        InputStream in = (InputStream)info[1];
        boolean isReadOnly = (Boolean)info[2];
        if (in != null && file != null && !file.exists()) {
            try {
                file = File.createTempFile("tmp", null);
                file.deleteOnExit();
                Utils.readAndWrite(in, new FileOutputStream(file), true);
                in = new FileInputStream(file);
            }
            catch (IOException e) {
                ZipEditorPlugin.log(e);
            }
        }
        return new ZipModel(file, in, isReadOnly, this);
    }

    @Override
    public void reportError(IStatus message) {
        ZipEditorActionBarContributor contributor = (ZipEditorActionBarContributor)this.getEditorSite().getActionBarContributor();
        contributor.reportError((IEditorPart)this, message);
    }

    private Object[] getEditorInputFileInfo(boolean getInputStream) {
        IEditorInput input = this.doGetEditorInput();
        IPath path = null;
        InputStream in = null;
        File file = null;
        Boolean readonly = Boolean.TRUE;
        if (input instanceof IFileEditorInput) {
            path = ((IFileEditorInput)input).getFile().getLocation();
            file = path.toFile();
            if (getInputStream) {
                try {
                    in = ((IFileEditorInput)input).getFile().getContents();
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
            readonly = new Boolean(((IFileEditorInput)input).getFile().isReadOnly());
        } else {
            if (input instanceof IPathEditorInput) {
                path = ((IPathEditorInput)input).getPath();
                file = path.toFile();
                readonly = new Boolean(!file.canWrite());
            }
            if (input instanceof IStorageEditorInput) {
                try {
                    if (path == null && (path = ((IStorageEditorInput)input).getStorage().getFullPath()) != null) {
                        file = path.toFile();
                    }
                    if (getInputStream) {
                        in = ((IStorageEditorInput)input).getStorage().getContents();
                    }
                    readonly = new Boolean(((IStorageEditorInput)input).getStorage().isReadOnly());
                }
                catch (CoreException e) {
                    ZipEditorPlugin.log((Object)e);
                }
            }
            if (path == null && input instanceof IURIEditorInput) {
                try {
                    file = new File(((IURIEditorInput)input).getURI());
                    path = new Path(file.getAbsolutePath());
                    readonly = new Boolean(!file.canWrite() && file.canRead());
                    if (getInputStream) {
                        in = ((IURIEditorInput)input).getURI().toURL().openStream();
                    }
                }
                catch (Exception e) {
                    ZipEditorPlugin.log(e);
                }
            }
        }
        return new Object[]{file, in, readonly};
    }

    private IEditorInput doGetEditorInput() {
        IEditorInput input = this.getEditorInput();
        return input instanceof DelegateEditorInput ? ((DelegateEditorInput)input).delegate : input;
    }

    public boolean isDirty() {
        return this.fModel != null && this.fModel.isDirty() && !this.fModel.isReadonly();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        control.setLayout((Layout)layout);
        this.createContent(control, this.getMode());
    }

    private void createContent(Composite parent, int mode) {
        this.createControls(parent, mode);
        this.createActions(mode);
        this.fillToolBar(this.fToolBar, mode);
        this.addViewerListener(this.getViewer());
    }

    private void createControls(Composite parent, int mode) {
        this.fToolBar = this.createToolBar(parent);
        this.fZipViewer = this.createZipViewer(parent, mode);
    }

    private ToolBarManager createToolBar(Composite parent) {
        ToolBarManager bar = new ToolBarManager(0x800100);
        ToolBar control = bar.createControl(parent);
        control.setLayoutData((Object)new GridData(768));
        return bar;
    }

    private void fillToolBar(IToolBarManager bar, int mode) {
        if ((mode & 2) == 0 && (mode & 4) > 0) {
            bar.add(this.getAction(ACTION_BACK));
            bar.add(this.getAction(ACTION_FORWARD));
            bar.add(this.getAction(ACTION_UP));
            bar.add((IContributionItem)new Separator());
        }
        bar.add(this.getAction(ACTION_TOGGLE_MODE));
        this.fOpenActionGroup.fillToolBarManager(bar);
        this.fZipActionGroup.fillToolBarManager(bar, mode);
        bar.add((IContributionItem)new Separator());
        if ((mode & 2) > 0) {
            bar.add((IContributionItem)new Separator());
            bar.add(this.getAction(ACTION_COLLAPSE_ALL));
        }
        bar.update(false);
    }

    public void updateView(int mode, boolean savePreferences) {
        Composite parent = this.fZipViewer.getControl().getParent();
        ISelection selection = this.fZipViewer.getSelection();
        ((ZipContentProvider)this.fZipViewer.getContentProvider()).disposeModel(false);
        Control[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!savePreferences) {
                children[i].removeDisposeListener(this.fTableDisposeListener);
            }
            children[i].dispose();
            ++i;
        }
        this.createContent(parent, mode);
        parent.layout();
        this.fZipViewer.setSelection(selection);
        this.fZipViewer.getControl().setFocus();
        ((ZipContentProvider)this.fZipViewer.getContentProvider()).disposeModel(true);
    }

    private StructuredViewer createZipViewer(Composite parent, int mode) {
        Object viewer = null;
        viewer = (mode & 2) > 0 ? new TreeViewer(parent) : this.createTableViewer(parent);
        viewer.setContentProvider((IContentProvider)new ZipContentProvider(mode));
        viewer.setLabelProvider((IBaseLabelProvider)new ZipLabelProvider());
        viewer.setSorter((ViewerSorter)new ZipSorter("editor"));
        viewer.setComparer((IElementComparer)new NodeComparer());
        viewer.getControl().setLayoutData((Object)new GridData(1808));
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        final IEditorInput originalInput = this.doGetEditorInput();
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ZipEditor.this.handleContextMenuAboutToShow(manager);
                if (!(ZipEditor.this.getEditorInput() instanceof DelegateEditorInput)) {
                    ZipEditor.super.setInput(new DelegateEditorInput(originalInput));
                }
            }
        });
        Menu contextMenu = manager.createContextMenu(viewer.getControl());
        contextMenu.addListener(23, new Listener(){

            public void handleEvent(Event event) {
                if (ZipEditor.this.getEditorInput() instanceof DelegateEditorInput) {
                    ZipEditor.super.setInput(originalInput);
                }
            }
        });
        viewer.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.fZipViewer);
        viewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ZipEditorPlugin.getDefault().checkFilesForModification(ZipEditor.this.fModel);
                ZipEditor.this.firePropertyChange(257);
            }
        });
        this.setViewerInput((StructuredViewer)viewer);
        this.initDragAndDrop((StructuredViewer)viewer);
        return viewer;
    }

    private void addViewerListener(StructuredViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ZipEditor.this.handleViewerDoubleClick();
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ZipEditor.this.handleViewerSelectionChanged(event.getSelection());
            }
        });
    }

    private Object updateFrameList() {
        Node currentNode = null;
        int i = 0;
        int n = this.fFrameList.size();
        while (i < n) {
            TableFrame tableFrame = (TableFrame)this.fFrameList.getFrame(i);
            String path = tableFrame.getInput() != null ? ((Node)((Object)tableFrame.getInput())).getPath() : null;
            Node node = this.fModel.findNode(path);
            if (node != null) {
                tableFrame.setInput((Object)node);
                if (i == this.fFrameList.getCurrentIndex()) {
                    currentNode = node;
                }
            }
            ++i;
        }
        return currentNode;
    }

    private void setViewerInput(final StructuredViewer viewer) {
        Object input = null;
        if (this.fModel == null) {
            Object node;
            this.fModel = this.createModel();
            if (this.fModel.getZipPath() != null) {
                this.fModelModified = this.fModel.getZipPath().lastModified();
            }
            this.fModel.addModelListener(new ModelListener());
            input = this.fModel.getRoot();
            if (this.fFrameList != null && (node = this.updateFrameList()) != null) {
                input = node;
            }
        } else {
            input = this.fModel.getRoot();
        }
        if (input != null) {
            if (Utils.isUIThread()) {
                viewer.setInput(input);
                if (this.fFrameList != null) {
                    viewer.refresh(true);
                }
            } else {
                viewer.getControl().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        viewer.setInput((Object)ZipEditor.this.fModel.getRoot());
                    }
                });
            }
            if (this.fOutlinePage != null) {
                this.fOutlinePage.setInput(this.fModel.getRoot());
            }
        } else if (Utils.isUIThread()) {
            this.setViewerInputAgain(viewer);
        } else {
            viewer.getControl().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ZipEditor.this.setViewerInputAgain(viewer);
                }
            });
        }
    }

    private void setViewerInputAgain(final StructuredViewer viewer) {
        viewer.getControl().getDisplay().timerExec(100, new Runnable(){

            @Override
            public void run() {
                ZipEditor.this.setViewerInput(viewer);
            }
        });
    }

    private void handleContextMenuAboutToShow(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("open.ext"));
        manager.add((IContributionItem)new Separator());
        manager.add(this.getAction(ACTION_NEW_FOLDER));
        manager.add((IContributionItem)new Separator());
        this.fOpenActionGroup.setContext(new ActionContext(this.fZipViewer.getSelection()));
        this.fOpenActionGroup.fillContextMenu(manager);
        this.fZipActionGroup.setContext(new ActionContext(this.fZipViewer.getSelection()));
        this.fZipActionGroup.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void handleViewerDoubleClick() {
        Node[] nodes = this.getSelectedNodes();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        if (nodes.length == 1 && nodes[0].isFolder()) {
            if (this.fZipViewer instanceof TreeViewer) {
                ((TreeViewer)this.fZipViewer).setExpandedState((Object)nodes[0], !((TreeViewer)this.fZipViewer).getExpandedState((Object)nodes[0]));
                return;
            }
            if (this.fZipViewer instanceof TableViewer) {
                ((GoIntoAction)this.getAction(ACTION_GO_INTO)).run();
                return;
            }
        }
        Utils.openFilesFromNodes(nodes);
    }

    private void handleViewerSelectionChanged(ISelection selection) {
        this.activateActions();
        this.fZipActionGroup.setContext(new ActionContext(selection));
        this.fZipActionGroup.updateActionBars();
        this.fOpenActionGroup.setContext(new ActionContext(selection));
        this.fOpenActionGroup.updateActionBars();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        int size = structuredSelection.size();
        this.setStatusText(size == 0 ? null : (size == 1 ? structuredSelection.getFirstElement() : Messages.getFormattedString("ZipEditor.9", new Integer(size))));
        if (size == 1) {
            this.synchronizeOutlineSelection(this.getSelectedNodes()[0]);
        }
        if (this.fFrameList != null) {
            ((TableFrame)this.fFrameList.getCurrentFrame()).setSelection((ISelection)structuredSelection);
        }
    }

    private void handleOutlineSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.fOutlinePage.getSelection();
        if (selection.size() != 1) {
            return;
        }
        this.fZipViewer.setSelection((ISelection)selection, true);
    }

    private void synchronizeOutlineSelection(Node node) {
        if (node == null || this.fOutlinePage == null || !this.fOutlinePage.isLinkingEnabled()) {
            return;
        }
        this.fOutlinePage.removeSelectionChangedListener(this.fOutlineSelectionChangedListener);
        this.fOutlinePage.setSelection((ISelection)new StructuredSelection((Object)node));
        this.fOutlinePage.addSelectionChangedListener(this.fOutlineSelectionChangedListener);
    }

    private void setStatusText(Object object) {
        IActionBars actionBars;
        IEditorSite activeSite;
        Object object2 = activeSite = this.getSite().getPage().getActivePart() != null ? this.getSite().getPage().getActivePart().getSite() : this.getEditorSite();
        Object object3 = activeSite instanceof IEditorSite ? activeSite.getActionBars() : (actionBars = activeSite instanceof IViewSite ? ((IViewSite)activeSite).getActionBars() : null);
        if (actionBars != null) {
            actionBars.getStatusLineManager().setMessage(object instanceof Node ? ((Node)((Object)object)).getName() : (object != null ? object.toString() : null));
        }
    }

    private TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 65538);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        this.createTableColumns(table);
        table.addDisposeListener(this.fTableDisposeListener);
        return viewer;
    }

    private void createTableColumns(Table table) {
        IPreferenceStore store = this.getPreferenceStore();
        int sortColumn = store.getInt("SORT_BY");
        int sortDirection = store.getInt("SORT_DIRECTION");
        Integer[] visibleColumns = (Integer[])PreferenceInitializer.split(store.getString("VISIBLE_COLUMNS"), ",", Integer.class);
        int i = 0;
        while (i < visibleColumns.length) {
            int type = visibleColumns[i];
            this.createTableColumn(table, Messages.getString("ZipNodeProperty." + type), type, sortColumn, sortDirection);
            ++i;
        }
        TableLayout layout = new TableLayout();
        TableColumn[] columns = table.getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            int width = store.getInt("SORT_COLUMN_WIDTH" + columns[i2].getData());
            if (width == 0) {
                width = 150;
            }
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(width));
            ++i2;
        }
        table.setLayout((Layout)layout);
    }

    private TableColumn createTableColumn(Table table, String text, int colType, int sortColumn, int sortDirection) {
        int style = colType == 6 || colType == 4 ? 131072 : 16384;
        TableColumn column = new TableColumn(table, style);
        column.setText(text);
        column.setData((Object)new Integer(colType));
        column.setMoveable(true);
        column.setImage(this.getSortImage(sortColumn == colType ? sortDirection : 0));
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZipEditor.this.handleSortColumnSelected((TableColumn)e.widget);
            }
        });
        return column;
    }

    public void storeTableColumnPreferences() {
        if (!(this.fZipViewer instanceof TableViewer)) {
            return;
        }
        Table table = ((TableViewer)this.fZipViewer).getTable();
        IPreferenceStore store = this.getPreferenceStore();
        TableColumn[] columns = table.getColumns();
        int[] order = table.getColumnOrder();
        int i = 0;
        while (i < columns.length) {
            store.setValue("SORT_COLUMN_WIDTH" + columns[i].getData(), columns[i].getWidth());
            ++i;
        }
        i = 0;
        while (i < order.length) {
            order[i] = (Integer)columns[order[i]].getData();
            ++i;
        }
        store.setValue("VISIBLE_COLUMNS", PreferenceInitializer.join(order, ","));
    }

    private void handleSortColumnSelected(TableColumn column) {
        IPreferenceStore store = this.getPreferenceStore();
        int sortColumn = store.getInt("SORT_BY");
        int sortDirection = store.getInt("SORT_DIRECTION");
        if ((Integer)column.getData() == sortColumn) {
            sortDirection = sortDirection == 128 ? 1024 : 128;
            column.setImage(this.getSortImage(sortDirection));
        } else {
            sortColumn = (Integer)column.getData();
            sortDirection = 128;
            column.setImage(this.getSortImage(128));
            TableColumn[] columns = column.getParent().getColumns();
            int i = 0;
            while (i < columns.length) {
                if (columns[i] != column) {
                    columns[i].setImage(this.getSortImage(0));
                }
                ++i;
            }
        }
        store.setValue("SORT_DIRECTION", sortDirection);
        store.setValue("SORT_BY", sortColumn);
        ((ZipSorter)this.fZipViewer.getSorter()).update();
        this.fZipViewer.refresh();
    }

    private Image getSortImage(int direction) {
        if (!this.getPreferenceStore().getBoolean("editorSORT_ENABLED")) {
            direction = 0;
        }
        switch (direction) {
            default: {
                return ZipEditorPlugin.getImage("icons/sort_none.gif");
            }
            case 128: {
                return ZipEditorPlugin.getImage("icons/sort_asc.gif");
            }
            case 1024: 
        }
        return ZipEditorPlugin.getImage("icons/sort_desc.gif");
    }

    private void createActions(int mode) {
        this.fZipActionGroup = new ZipActionGroup(this);
        this.fOpenActionGroup = new OpenActionGroup(this.getViewer(), false);
        this.setAction(ACTION_NEW_FOLDER, (IAction)new NewFolderAction(this.getViewer()));
        ToggleViewModeAction toggleViewModeAction = new ToggleViewModeAction(this, ActionMessages.getString("ToggleViewModeAction.0"), "editor", 2);
        toggleViewModeAction.setToolTipText(ActionMessages.getString("ToggleViewModeAction.1"));
        toggleViewModeAction.setImageDescriptor(ZipEditorPlugin.getImageDescriptor("icons/elcl18/togglemode.png"));
        toggleViewModeAction.setDisabledImageDescriptor(ZipEditorPlugin.getImageDescriptor("icons/dlcl18/togglemode.png"));
        this.setAction(ACTION_TOGGLE_MODE, (IAction)toggleViewModeAction);
        this.setAction(ACTION_COLLAPSE_ALL, (IAction)new CollapseAllAction(this.getViewer()));
        this.setAction(ACTION_SELECT_ALL, (IAction)new SelectAllAction(this.getViewer()));
        this.setAction(ACTION_SELECT_PATTERN, (IAction)new SelectPatternAction(this.getViewer()));
        this.setAction(ACTION_REVERSE_SELECTION, (IAction)new ReverseSelectionAction(this.getViewer()));
        this.setAction(ACTION_RENAME, (IAction)new RenameNodeAction(this.getViewer()));
        this.fFrameList = this.createFrameList(mode);
        if (this.fFrameList != null) {
            this.setAction(ACTION_BACK, (IAction)new BackAction(this.fFrameList));
            this.setAction(ACTION_FORWARD, (IAction)new ForwardAction(this.fFrameList));
            this.setAction(ACTION_UP, (IAction)new UpAction(this.fFrameList));
            this.setAction(ACTION_GO_INTO, (IAction)new GoIntoAction(this.fFrameList));
        }
        this.activateActions();
    }

    private FrameList createFrameList(int mode) {
        if (!(this.fZipViewer instanceof TableViewer)) {
            return null;
        }
        TableViewerFrameSource frameSource = new TableViewerFrameSource((TableViewer)this.fZipViewer);
        FrameList frameList = new FrameList((IFrameSource)frameSource);
        frameList.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String inputName = ZipEditor.this.getEditorInput().getName();
                TableFrame frame = (TableFrame)((FrameList)event.getSource()).getCurrentFrame();
                Node node = (Node)((Object)frame.getInput());
                if (node != null) {
                    String frameName = node.getPath();
                    frameName = String.valueOf(inputName) + (frameName.length() > 0 ? " - " + frameName : new String());
                    ZipEditor.this.setPartName(frameName);
                }
            }
        });
        frameSource.connectTo(frameList);
        this.setPartName(this.getEditorInput().getName());
        if (this.fState != null && (mode & 4) > 0) {
            TableFrame currentFrame = (TableFrame)frameList.getCurrentFrame();
            currentFrame.restoreState(this.fState, this.fModel);
            if (this.fModel.getRoot() == currentFrame.getInput()) {
                this.fZipViewer.setSelection(currentFrame.getSelection());
            } else {
                frameList.gotoFrame((Frame)currentFrame);
            }
        }
        return frameList;
    }

    private void setAction(String name, IAction action) {
        this.fActions.put(name, action);
    }

    private IAction getAction(String name) {
        return (IAction)this.fActions.get(name);
    }

    private void initDragAndDrop(StructuredViewer viewer) {
        int ops = 17;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new ZipEditorDragAdapter((ISelectionProvider)viewer));
        viewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)new ZipEditorDropAdapter(viewer));
    }

    public IPreferenceStore getPreferenceStore() {
        return ZipEditorPlugin.getDefault().getPreferenceStore();
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new ZipOutlinePage();
                if (this.fOutlineSelectionChangedListener == null) {
                    this.fOutlineSelectionChangedListener = new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            ZipEditor.this.handleOutlineSelectionChanged();
                        }
                    };
                }
                this.fOutlinePage.addSelectionChangedListener(this.fOutlineSelectionChangedListener);
                this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ZipEditor.this.fOutlinePage.setInput(ZipEditor.this.fModel.getRoot());
                    }
                });
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(adapter);
    }

    public Node[] getSelectedNodes() {
        return Utils.getSelectedNodes(this.fZipViewer.getSelection());
    }

    public void setFocus() {
        if (this.fZipViewer != null) {
            this.fZipViewer.getControl().setFocus();
        }
        this.activateActions();
        this.checkIfFileHasBeenChangedLocaly(this.doGetEditorInput());
    }

    private void checkIfFileHasBeenChangedLocaly(IEditorInput editorInput) {
        boolean fileModified;
        Object[] info = this.getEditorInputFileInfo(false);
        File file = (File)info[0];
        boolean readOnly = (Boolean)info[2];
        boolean fileDeleted = file != null && !file.exists();
        boolean bl = fileModified = file != null && file.exists() && file.lastModified() > this.fModelModified;
        if (editorInput instanceof IFileEditorInput) {
            boolean bl2 = fileModified = !((IFileEditorInput)editorInput).getFile().isSynchronized(1);
        }
        if (fileModified) {
            if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.getString("ZipEditor.4"), (String)Messages.getString("ZipEditor.5"))) {
                if (editorInput instanceof IFileEditorInput) {
                    try {
                        ((IFileEditorInput)editorInput).getFile().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        this.fModel.logError((Object)e);
                    }
                }
                this.doRevert();
            }
        } else if (fileDeleted && !readOnly && !this.fCheckedDeletion) {
            this.fCheckedDeletion = true;
            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), Messages.getString("ZipEditor.6"), null, Messages.getFormattedString("ZipEditor.7", editorInput.getName()), 3, new String[]{Messages.getString("ZipEditor.13"), Messages.getString("ZipEditor.14"), IDialogConstants.CANCEL_LABEL}, 0);
            switch (dialog.open()) {
                case 0: {
                    this.close();
                    break;
                }
                case 1: {
                    this.doSave((IProgressMonitor)new NullProgressMonitor());
                }
            }
        } else if (!fileDeleted) {
            this.fCheckedDeletion = false;
        }
    }

    private void activateActions() {
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(ACTION_SELECT_ALL));
        this.getEditorSite().getActionBars().setGlobalActionHandler("zipeditor.command.selectPattern", this.getAction(ACTION_SELECT_PATTERN));
        this.getEditorSite().getActionBars().setGlobalActionHandler("zipeditor.command.reverseSelection", this.getAction(ACTION_REVERSE_SELECTION));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getId(), this.getAction(ACTION_RENAME));
        this.fZipActionGroup.setContext(new ActionContext(this.fZipViewer.getSelection()));
        this.fZipActionGroup.fillActionBars(this.getEditorSite().getActionBars());
        this.getEditorSite().getActionBars().updateActionBars();
    }

    public StructuredViewer getViewer() {
        return this.fZipViewer;
    }

    public Node getRootNode() {
        return (Node)((Object)this.fZipViewer.getInput());
    }

    public int getMode() {
        return this.getPreferenceStore().getInt("editorVIEW_MODE");
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("editorSORT_ENABLEDsorting_changed".equals(event.getProperty())) {
            this.updateView(this.getMode(), true);
        }
    }

    public void saveState(IMemento memento) {
        if (this.fFrameList != null) {
            ((TableFrame)this.fFrameList.getCurrentFrame()).saveState(memento);
        }
    }

    public void restoreState(IMemento memento) {
        this.fState = memento;
    }

    private class DelegateEditorInput
    implements IEditorInput {
        private IEditorInput delegate;

        private DelegateEditorInput(IEditorInput delegate) {
            this.delegate = delegate;
        }

        public boolean exists() {
            return this.delegate.exists();
        }

        public ImageDescriptor getImageDescriptor() {
            return this.delegate.getImageDescriptor();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public IPersistableElement getPersistable() {
            return this.delegate.getPersistable();
        }

        public String getToolTipText() {
            return this.delegate.getToolTipText();
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    private class InputFileListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private InputFileListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                IResourceDelta delta = event.getDelta();
                try {
                    delta.accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    ZipEditorPlugin.log((Object)e);
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                IEditorInput input = ZipEditor.this.doGetEditorInput();
                if (input instanceof IFileEditorInput && file.equals((Object)((IFileEditorInput)input).getFile())) {
                    if (delta.getKind() == 2 || delta.getKind() == 262144) {
                        ZipEditor.this.close();
                    }
                    return false;
                }
            }
            return true;
        }
    }

    private class ModelListener
    extends UIJob
    implements IModelListener {
        private IModelListener.ModelChangeEvent fModelChangeEvent;
        private String fOriginalPartName;
        private Object jobFamily;

        public ModelListener() {
            super(Messages.getString("ZipEditor.11"));
            this.jobFamily = new Object();
        }

        @Override
        public void modelChanged(IModelListener.ModelChangeEvent event) {
            Job[] jobs;
            if (this.fModelChangeEvent != null && !event.isInitFinished()) {
                return;
            }
            this.fModelChangeEvent = event;
            long scheduleTime = 0L;
            if (event.isInitializing() && !event.isInitStarted() && !event.isInitFinished()) {
                scheduleTime = 2000L;
            }
            if (event.isInitFinished() && (jobs = Platform.getJobManager().find(this.jobFamily)) != null) {
                int i = 0;
                while (i < jobs.length) {
                    jobs[i].cancel();
                    ++i;
                }
            }
            this.setPriority(10);
            this.schedule(scheduleTime);
        }

        public boolean belongsTo(Object family) {
            return family == this.jobFamily;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                this.doRun();
            }
            this.fModelChangeEvent = null;
            return Status.OK_STATUS;
        }

        private void doRun() {
            if (!ZipEditor.this.fZipViewer.getControl().isDisposed()) {
                ZipEditor.this.fZipViewer.getControl().setRedraw(false);
                ZipEditor.this.fZipViewer.refresh();
                ZipEditor.this.fZipViewer.getControl().setRedraw(true);
            }
            if (ZipEditor.this.fOutlinePage != null && !ZipEditor.this.fOutlinePage.getControl().isDisposed()) {
                if (ZipEditor.this.fOutlinePage.getInput() == null) {
                    ZipEditor.this.fOutlinePage.setInput(ZipEditor.this.fModel.getRoot());
                } else {
                    ZipEditor.this.fOutlinePage.refresh();
                }
            }
            ZipEditor.this.firePropertyChange(257);
            if (this.fModelChangeEvent != null && this.fModelChangeEvent.isInitializing()) {
                String suffix = Messages.getString("ZipEditor.10");
                if (!ZipEditor.this.getPartName().endsWith(suffix)) {
                    this.fOriginalPartName = ZipEditor.this.getPartName();
                    ZipEditor.this.setPartName(String.valueOf(this.fOriginalPartName) + suffix);
                }
            } else if (this.fOriginalPartName != null) {
                ZipEditor.this.setPartName(this.fOriginalPartName);
                this.fOriginalPartName = null;
            }
        }
    }

    static class NodeComparer
    implements IElementComparer {
        NodeComparer() {
        }

        public boolean equals(Object a, Object b) {
            return a instanceof Node && b instanceof Node ? ((Node)((Object)a)).getFullPath().equals(((Node)((Object)b)).getFullPath()) : a.equals(b);
        }

        public int hashCode(Object element) {
            return ((Node)((Object)element)).getFullPath().hashCode();
        }
    }
}

