/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.autoemul.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.autoemul.DeviceEntry;
import org.tizen.common.autoemul.DeviceEntryManager;
import org.tizen.common.autoemul.messages.AutoEmulMessages;
import org.tizen.common.autoemul.preferences.AutoEmulPreferencesManager;
import org.tizen.common.autoemul.wizard.AutoEmulGenWizardDialog;
import org.tizen.common.autoemul.wizard.AutoEmulWizard;

public class AutoEmulDialogPage
extends WizardPage {
    private Shell shell;
    private Table table;
    public TableViewer tableViewer;
    private IProject iproject;

    protected AutoEmulDialogPage(String pageName, Shell shell, IProject iproject) {
        super(pageName);
        this.shell = shell;
        this.iproject = iproject;
        this.setTitle(AutoEmulMessages.SELECT_EMULATOR_DIALOGPAGE_TITLE);
        this.setDescription(AutoEmulMessages.SELECT_EMULATOR_DEFAULT_DESCRIPTION);
        this.setErrorMessage(null);
    }

    public void performHelp() {
    }

    public void createControl(Composite parentComposite) {
        Composite composite = new Composite(parentComposite, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(768);
        gridData.minimumHeight = 0;
        composite.setLayoutData((Object)gridData);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(composite, 67584);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    DeviceEntry d = (DeviceEntry)o;
                    AutoEmulGenWizardDialog.selectionDeviceName(d.getEntryName());
                    ++n2;
                }
            }
        });
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnPixel100 = tableViewerColumn.getColumn();
        layout.setColumnData((Widget)tblclmnPixel100, (ColumnLayoutData)new ColumnPixelData(100, true, true));
        tblclmnPixel100.setText(AutoEmulMessages.SELECT_EMULATOR_ITEM_NAME);
        TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnWeight2 = tableViewerColumn_1.getColumn();
        layout.setColumnData((Widget)tblclmnWeight2, (ColumnLayoutData)new ColumnWeightData(2, 20, true));
        tblclmnWeight2.setText(AutoEmulMessages.SELECT_EMULATOR_ITEM_RESULUTION);
        TableViewerColumn tableViewerColumn_2 = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnWeight4 = tableViewerColumn_2.getColumn();
        layout.setColumnData((Widget)tblclmnWeight4, (ColumnLayoutData)new ColumnWeightData(4, 20, true));
        tblclmnWeight4.setText(AutoEmulMessages.SELECT_EMULATOR_ITEM_STATUS);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableViewerProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                AutoEmulWizard wizard = (AutoEmulWizard)AutoEmulDialogPage.this.getWizard();
                AutoEmulGenWizardDialog dialog = (AutoEmulGenWizardDialog)wizard.getContainer();
                dialog.PressedFinished();
            }
        });
        DeviceEntryManager deviceEntryManager = DeviceEntryManager.getDeviceEntryManager();
        ArrayList<DeviceEntry> testList2 = deviceEntryManager.getNewDeviceEntryListFromXML();
        AutoEmulWizard wizard = (AutoEmulWizard)this.getWizard();
        AutoEmulGenWizardDialog dialog = (AutoEmulGenWizardDialog)wizard.getContainer();
        if (testList2.size() != 0) {
            deviceEntryManager.setHighlightListener(this.shell, this.table);
            this.tableViewer.setInput(testList2);
            String latestDeviceInfo = AutoEmulPreferencesManager.getLatestDeviceInfo(this.iproject);
            if (latestDeviceInfo != null && latestDeviceInfo.length() >= 0) {
                int index = deviceEntryManager.getIndexFromName(latestDeviceInfo);
                if (index != -1) {
                    this.tableViewer.setSelection((ISelection)new StructuredSelection(this.tableViewer.getElementAt(index)), true);
                } else {
                    this.tableViewer.setSelection((ISelection)new StructuredSelection(this.tableViewer.getElementAt(0)), true);
                }
            } else {
                this.tableViewer.setSelection((ISelection)new StructuredSelection(this.tableViewer.getElementAt(0)), true);
            }
            wizard.canFinish();
        } else {
            dialog.setFocusBtnEmulatorManager();
            wizard.canFinish();
            this.setDescription(AutoEmulMessages.SELECT_EMULATOR_INFO_EMPTYLIST);
        }
        this.setHelpContextIDs(parentComposite);
        this.setControl((Control)parentComposite);
    }

    private void setHelpContextIDs(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tizen.nativecommon.AutomationEmulatorWizard");
    }

    public void setDefaultDescription() {
        this.setDescription(AutoEmulMessages.SELECT_EMULATOR_DEFAULT_DESCRIPTION);
    }

    private class TableViewerProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableViewerProvider() {
        }

        public Image getColumnImage(Object arg0, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof DeviceEntry) {
                DeviceEntry de = (DeviceEntry)element;
                switch (columnIndex) {
                    case 0: {
                        return de.getEntryName();
                    }
                    case 1: {
                        return de.getEntryResolution();
                    }
                    case 2: {
                        return de.getEntryStatus();
                    }
                }
            }
            return null;
        }
    }
}

