/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.handlers;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.run.RestTestEngine;
import org.tizen.common.rest.ui.dialogs.RestDialog;
import org.tizen.common.rest.ui.handlers.RESTCommonHandler;
import org.tizen.common.rest.ui.views.RestViewer;
import org.tizen.common.rest.ui.views.RestViewerManager;

public class RESTDialogHandler
extends RESTCommonHandler {
    @Override
    public Object execute(ExecutionEvent event) {
        super.execute(event);
        return null;
    }

    @Override
    public Object execute() {
        this.openRESTDialog();
        return null;
    }

    public void openRESTDialog() {
        RESTDialogHandler.openRESTDialog(this.shell, this.viewer, this.selection, this.openType);
    }

    public static void openRESTDialog(Shell shell, RestViewer viewer, IStructuredSelection selection, int openType) {
        RestDialog restDialog;
        if (!RestDialog.isCreated() && (restDialog = new RestDialog(shell, selection, openType)).open() == 0) {
            IRestUiModel[] modelsFromTree = null;
            IRestUiModel[] modelsOnDialog = restDialog.getModelsOnDialog();
            IRestUiModel target = null;
            Map<Param, Param> paramsPairs = restDialog.getParamsPairs();
            Param[] newParams = restDialog.getNewParams();
            if (openType == RestDialog.OPEN_MODIFY) {
                modelsFromTree = restDialog.getModelListFromTree();
                RestViewerManager.updateModel(modelsFromTree, modelsOnDialog);
                RestViewerManager.updateParam(modelsFromTree, paramsPairs, newParams);
            } else {
                if (openType == RestDialog.OPEN_NEW_CHILD) {
                    target = (IRestUiModel)selection.getFirstElement();
                }
                RestViewerManager.addModel(target, modelsOnDialog);
                RestViewerManager.updateParam(modelsOnDialog, paramsPairs, newParams);
            }
            if (restDialog.hasToRun()) {
                if (target == null) {
                    target = openType == RestDialog.OPEN_MODIFY ? modelsFromTree[0] : modelsOnDialog[0];
                }
                StructuredSelection ss = new StructuredSelection((Object)target);
                RestTestEngine.run(shell, (IStructuredSelection)ss);
            }
            if (target == null || target instanceof Application) {
                viewer.reloadTreeViewer();
            } else {
                viewer.refreshTreeViewer(target);
            }
        }
    }
}

