/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.xml.XMLSerializer;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.model.NamespaceFilter;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.ui.views.RestViewer;
import org.tizen.common.rest.util.XsdGenEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.wiztools.xsdgen.ParseException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class OutputUtil {
    private static final String CONSOLE_NAME = "REST Console";
    public static final Gson gsonForPrettyPrinting = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
    private static final JsonParser jsonParser = new JsonParser();
    private static JAXBContext context;

    static {
        try {
            context = JAXBContext.newInstance((Class[])new Class[]{Application.class});
        }
        catch (JAXBException e) {
            RestPlugin.log(e);
        }
    }

    private OutputUtil() {
    }

    public static void println(MessageConsoleStream out, String message) {
        out.println(message);
    }

    public static void printlnToJson(MessageConsoleStream out, Object obj) {
        String result = OutputUtil.toJson(obj);
        out.println(result);
    }

    public static String toJson(Object o) {
        Gson gson = new Gson();
        return gson.toJson(o);
    }

    public static <T> T fromJson(Class<T> c, String str) {
        JsonDeserializer<NameValuePair> de = new JsonDeserializer<NameValuePair>(){

            public NameValuePair deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject object = json.getAsJsonObject();
                String name = object.get("name").getAsString();
                String value = object.get("value").getAsString();
                return new BasicNameValuePair(name, value);
            }
        };
        Gson gson = new GsonBuilder().registerTypeAdapter(NameValuePair.class, (Object)de).create();
        return (T)gson.fromJson(str, c);
    }

    public static String toPrettyJson(String json) throws Exception {
        if (json != null) {
            JsonElement je = jsonParser.parse(json);
            return gsonForPrettyPrinting.toJson(je);
        }
        return "No Content";
    }

    public static String toPrettyXml(String input, int indent) {
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", indent);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Throwable throwable) {
            try {
                StreamSource xmlInput = new StreamSource(new StringReader(input));
                StringWriter stringWriter = new StringWriter();
                StreamResult xmlOutput = new StreamResult(stringWriter);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
                transformer.transform(xmlInput, xmlOutput);
                return xmlOutput.getWriter().toString();
            }
            catch (Throwable throwable2) {
                return input;
            }
        }
    }

    public static String toPrettyXml(String input) {
        return OutputUtil.toPrettyXml(input, 4);
    }

    public static MessageConsoleStream newConsoleStream() {
        MessageConsole console = OutputUtil.findConsole();
        return console.newMessageStream();
    }

    public static MessageConsole findConsole() {
        MessageConsole myConsole = null;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (CONSOLE_NAME.equals(existing[i].getName())) {
                MessageConsole console;
                myConsole = console = (MessageConsole)existing[i];
                break;
            }
            ++i;
        }
        if (myConsole == null) {
            myConsole = new MessageConsole(CONSOLE_NAME, null);
            conMan.addConsoles(new IConsole[]{myConsole});
        }
        try {
            IWorkbenchPage page;
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                String id = "org.eclipse.ui.console.ConsoleView";
                IConsoleView view = (IConsoleView)page.showView(id);
                view.display((IConsole)myConsole);
            }
        }
        catch (PartInitException e) {
            RestPlugin.log(e);
        }
        myConsole.activate();
        return myConsole;
    }

    public static RestViewer findRestViewer() {
        RestViewer view = null;
        try {
            IWorkbenchPage page;
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                String id = "org.tizen.common.rest.ui.views.RestViewer";
                view = (RestViewer)page.showView(id);
            }
        }
        catch (PartInitException e) {
            RestPlugin.log(e);
        }
        return view;
    }

    public static <T extends IWadlModel> T clone(T model) throws JAXBException {
        JAXBContext sourceJAXBContext = JAXBContext.newInstance((Class[])new Class[]{model.getClass()});
        JAXBContext targetJAXBContext = JAXBContext.newInstance((Class[])new Class[]{model.getClass()});
        return (T)((IWadlModel)targetJAXBContext.createUnmarshaller().unmarshal((Source)new JAXBSource(sourceJAXBContext, model)));
    }

    public static Application loadWadl(InputStream inputStream) throws JAXBException {
        Unmarshaller um = context.createUnmarshaller();
        Application app = null;
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
            NamespaceFilter inFilter = new NamespaceFilter();
            inFilter.setParent(reader);
            InputSource source = new InputSource(inputStream);
            SAXSource saxSource = new SAXSource(inFilter, source);
            app = (Application)um.unmarshal((Source)saxSource);
        }
        catch (SAXException e) {
            RestPlugin.log(e);
        }
        catch (Exception e) {
            RestPlugin.log(e);
        }
        return app;
    }

    public static Application loadWadl(File file) throws JAXBException {
        Application app;
        block14: {
            app = null;
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(file);
                    app = OutputUtil.loadWadl(is);
                }
                catch (FileNotFoundException e) {
                    RestPlugin.log(e);
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return app;
    }

    public static void saveWadl(File file, Application app) throws JAXBException {
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.setProperty("com.sun.xml.bind.xmlHeaders", (Object)RestUIMessages.AutoGen_Commnet);
        m.marshal((Object)app, file);
    }

    public static Document parseXml(String xmlString) {
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl");
        Document document = null;
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS lsImpl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSParser parser = lsImpl.createLSParser((short)1, null);
            LSInput lsInput = lsImpl.createLSInput();
            lsInput.setStringData(xmlString);
            document = parser.parse(lsInput);
            document.normalize();
        }
        catch (ClassNotFoundException e) {
            RestPlugin.log(e);
        }
        catch (InstantiationException e) {
            RestPlugin.log(e);
        }
        catch (IllegalAccessException e) {
            RestPlugin.log(e);
        }
        catch (LSException e) {
            RestPlugin.log(e);
        }
        return document;
    }

    public static String toXmlFromJson(String jsonString) {
        String result = null;
        try {
            JSON json = JSONSerializer.toJSON((Object)jsonString);
            XMLSerializer xmlSerializer = new XMLSerializer();
            xmlSerializer.setTypeHintsEnabled(false);
            xmlSerializer.setRootName("response");
            xmlSerializer.setElementName("element");
            xmlSerializer.setArrayName("list");
            result = xmlSerializer.write(json, "UTF-8");
        }
        catch (Exception e) {
            RestPlugin.log(e);
        }
        return result;
    }

    public static Element toSchemaFromJson(String jsonString) {
        String xml = OutputUtil.toXmlFromJson(jsonString);
        return OutputUtil.toSchemaFromXml(xml);
    }

    public static Element toSchemaFromXml(String xmlString) {
        String schemaString = OutputUtil.convertXmlToSchema(xmlString);
        return OutputUtil.getDocumentElement(schemaString);
    }

    public static Element getDocumentElement(String xmlString) {
        Document doc;
        Element result = null;
        if (xmlString != null && (doc = OutputUtil.parseXml(xmlString)) != null) {
            result = doc.getDocumentElement();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String convertXmlToSchema(String xmlString) {
        String result = null;
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            XsdGenEx gen = new XsdGenEx().parse(xmlString);
            gen.write(os);
            result = os.toString();
        }
        catch (IOException e) {
            RestPlugin.log(e);
            if (os == null) return result;
            try {
                os.close();
                return result;
            }
            catch (IOException iOException) {}
            return result;
        }
        catch (ParseException e) {
            try {
                RestPlugin.log(e);
                if (os == null) return result;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.close();
                return result;
            }
            catch (IOException iOException) {}
            return result;
        }
        if (os == null) return result;
        try {
            os.close();
            return result;
        }
        catch (IOException iOException) {}
        return result;
    }

    public static Element getChildElementByTagNameAndAttribute(Element element, String tagName, String attrName, String attrValue) {
        if (element != null) {
            NodeList nl = element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node.getNodeType() == 1 && ((Element)node).getTagName().equals(tagName) && ((Element)node).getAttribute(attrName).equals(attrValue)) {
                    return (Element)node;
                }
                ++i;
            }
        }
        return null;
    }

    public static Element getChildElementByTagName(Element element, String tagName) {
        if (element != null) {
            NodeList nl = element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node.getNodeType() == 1 && ((Element)node).getTagName().equals(tagName)) {
                    return (Element)node;
                }
                ++i;
            }
        }
        return null;
    }

    public static Element[] getChildElementsByTagNames(Element element, String[] tagNames) {
        ArrayList<Node> buf = new ArrayList<Node>();
        if (element != null) {
            NodeList nl = element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node.getNodeType() == 1) {
                    String[] stringArray = tagNames;
                    int n = tagNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String tagName = stringArray[n2];
                        if (((Element)node).getTagName().equals(tagName)) {
                            buf.add(node);
                        }
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return buf.toArray(new Element[buf.size()]);
    }

    public static Element[] getChildElementsByTagName(Element element, String tagName) {
        ArrayList<Node> buf = new ArrayList<Node>();
        if (element != null) {
            NodeList nl = element.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node node = nl.item(i);
                if (node.getNodeType() == 1 && ((Element)node).getTagName().equals(tagName)) {
                    buf.add(node);
                }
                ++i;
            }
        }
        return buf.toArray(new Element[buf.size()]);
    }
}

