/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.realm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.verrari.AttributeContainer;
import org.tizen.common.verrari.Condition;
import org.tizen.common.verrari.Template;
import org.tizen.common.verrari.realm.DirectorySearchableRealm;

public class TizenWebUIFWRealm
extends DirectorySearchableRealm {
    public String[] getExistTemplates() {
        File root = this.getTizenWebUIFWRealmFile();
        ArrayList<String> array = new ArrayList<String>();
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (dir.isDirectory()) {
                boolean isTemplate = false;
                File[] fileArray2 = dir.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File list = fileArray2[n4];
                    if (list.isDirectory() && "META-INF".equals(list.getName())) {
                        File[] fileArray3 = list.listFiles();
                        int n5 = fileArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            File sublist = fileArray3[n6];
                            if (!sublist.isDirectory() && "MANIFEST.MF".equals(sublist.getName())) {
                                isTemplate = true;
                                break;
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                if (isTemplate) {
                    array.add(dir.getName());
                }
            }
            ++n2;
        }
        return array.toArray(new String[0]);
    }

    @Override
    public Template getTemplate(String id) throws IOException {
        String realmPath = this.getTizenWebUIFWRealmPath();
        if (!id.contains("web-ui-fw") || !this.isExistRealm(realmPath)) {
            return super.getTemplate(id);
        }
        if (id.contains("web-ui-fw")) {
            String[] templates = this.getExistTemplates();
            if (templates.length == 0) {
                return null;
            }
            if (templates.length == 1) {
                return this.getTemplate(new File(String.valueOf(realmPath) + File.separator + templates[0]));
            }
            if (templates.length > 1) {
                String num = StringUtil.getOnlyNumerics((String)id);
                String lastest = null;
                String[] stringArray = templates;
                int n = templates.length;
                int n2 = 0;
                while (n2 < n) {
                    String template = stringArray[n2];
                    try {
                        String temp = StringUtil.getOnlyNumerics((String)template);
                        if (num.equals(temp)) {
                            return this.getTemplate(new File(String.valueOf(realmPath) + File.separator + template));
                        }
                        Double current = Double.parseDouble(temp);
                        if (StringUtil.isEmpty(lastest)) {
                            lastest = template;
                        } else {
                            temp = StringUtil.getOnlyNumerics((String)lastest);
                            Double big = Double.parseDouble(temp);
                            if (big < current) {
                                lastest = template;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        this.logger.error("Template[" + template + "] not supported version style {}", (Object)e.toString());
                    }
                    ++n2;
                }
                if (!StringUtil.isEmpty(lastest)) {
                    return this.getTemplate(new File(String.valueOf(realmPath) + File.separator + lastest));
                }
            }
        }
        return super.getTemplate(id);
    }

    @Override
    public Collection<AttributeContainer> search(Condition condition) throws IOException {
        String protocol = "file://";
        String type = "directory";
        String urlStr = String.valueOf(protocol) + this.getTizenWebUIFWRealmPath();
        this.logger.debug("Type :{}, URL :{}", (Object)type, (Object)urlStr);
        this.setAttributes("search-query-type", type);
        this.setAttributes("search-query-url", urlStr);
        return super.search(condition);
    }

    public boolean isExistRealm(String realmPath) {
        return FileUtil.isExist((String)realmPath);
    }

    public File getTizenWebUIFWRealmFile() {
        return new File(this.getTizenWebUIFWRealmPath());
    }

    public String getTizenWebUIFWRealmPath() {
        String platformPath = InstallPathConfig.getPlatformVersionPath();
        return String.valueOf(platformPath) + File.separator + "web-ui-fw";
    }
}

