/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.pgm.opt.PathTreeFilterHandler;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.io.ThrowingPrintWriter;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Command(common=true, usage="usage_ShowDiffs")
class Diff
extends TextBuiltin {
    private DiffFormatter diffFmt;
    @Argument(index=0, metaVar="metaVar_treeish")
    private AbstractTreeIterator oldTree;
    @Argument(index=1, metaVar="metaVar_treeish")
    private AbstractTreeIterator newTree;
    @Option(name="--cached", usage="usage_cached")
    private boolean cached;
    @Option(name="--", metaVar="metaVar_paths", multiValued=true, handler=PathTreeFilterHandler.class)
    private TreeFilter pathFilter = TreeFilter.ALL;
    @Option(name="-p", usage="usage_showPatch")
    boolean showPatch;
    @Option(name="-M", usage="usage_detectRenames")
    private Boolean detectRenames;
    @Option(name="-l", usage="usage_renameLimit")
    private Integer renameLimit;
    @Option(name="--name-status", usage="usage_nameStatus")
    private boolean showNameAndStatusOnly;

    Diff() {
    }

    @Option(name="--no-renames", usage="usage_noRenames")
    void noRenames(boolean on) {
        this.detectRenames = Boolean.FALSE;
    }

    @Option(name="--algorithm", metaVar="metaVar_diffAlg", usage="usage_diffAlgorithm")
    void setAlgorithm(DiffAlgorithm.SupportedAlgorithm s) {
        this.diffFmt.setDiffAlgorithm(DiffAlgorithm.getAlgorithm(s));
    }

    @Option(name="--ignore-space-at-eol")
    void ignoreSpaceAtEol(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_TRAILING);
    }

    @Option(name="--ignore-leading-space")
    void ignoreLeadingSpace(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_LEADING);
    }

    @Option(name="-b", aliases={"--ignore-space-change"})
    void ignoreSpaceChange(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_CHANGE);
    }

    @Option(name="-w", aliases={"--ignore-all-space"})
    void ignoreAllSpace(boolean on) {
        this.diffFmt.setDiffComparator(RawTextComparator.WS_IGNORE_ALL);
    }

    @Option(name="-U", aliases={"--unified"}, metaVar="metaVar_linesOfContext")
    void unified(int lines) {
        this.diffFmt.setContext(lines);
    }

    @Option(name="--abbrev", metaVar="metaVar_n")
    void abbrev(int lines) {
        this.diffFmt.setAbbreviationLength(lines);
    }

    @Option(name="--full-index")
    void abbrev(boolean on) {
        this.diffFmt.setAbbreviationLength(40);
    }

    @Option(name="--src-prefix", usage="usage_srcPrefix")
    void sourcePrefix(String path) {
        this.diffFmt.setOldPrefix(path);
    }

    @Option(name="--dst-prefix", usage="usage_dstPrefix")
    void dstPrefix(String path) {
        this.diffFmt.setNewPrefix(path);
    }

    @Option(name="--no-prefix", usage="usage_noPrefix")
    void noPrefix(boolean on) {
        this.diffFmt.setOldPrefix("");
        this.diffFmt.setNewPrefix("");
    }

    @Override
    protected void init(Repository repository, String gitDir) {
        super.init(repository, gitDir);
        this.diffFmt = new DiffFormatter(new BufferedOutputStream(this.outs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws Exception {
        this.diffFmt.setRepository(this.db);
        try {
            if (this.cached) {
                if (this.oldTree == null) {
                    ObjectId head = this.db.resolve("HEAD^{tree}");
                    if (head == null) {
                        Diff.die(MessageFormat.format(CLIText.get().notATree, "HEAD"));
                    }
                    CanonicalTreeParser p = new CanonicalTreeParser();
                    ObjectReader reader = this.db.newObjectReader();
                    try {
                        p.reset(reader, head);
                    }
                    finally {
                        reader.release();
                    }
                    this.oldTree = p;
                }
                this.newTree = new DirCacheIterator(this.db.readDirCache());
            } else if (this.oldTree == null) {
                this.oldTree = new DirCacheIterator(this.db.readDirCache());
                this.newTree = new FileTreeIterator(this.db);
            } else if (this.newTree == null) {
                this.newTree = new FileTreeIterator(this.db);
            }
            TextProgressMonitor pm = new TextProgressMonitor();
            pm.setDelayStart(2L, TimeUnit.SECONDS);
            this.diffFmt.setProgressMonitor(pm);
            this.diffFmt.setPathFilter(this.pathFilter);
            if (this.detectRenames != null) {
                this.diffFmt.setDetectRenames(this.detectRenames);
            }
            if (this.renameLimit != null && this.diffFmt.isDetectRenames()) {
                RenameDetector rd = this.diffFmt.getRenameDetector();
                rd.setRenameLimit(this.renameLimit);
            }
            if (this.showNameAndStatusOnly) {
                Diff.nameStatus(this.outw, this.diffFmt.scan(this.oldTree, this.newTree));
                this.outw.flush();
            } else {
                this.diffFmt.format(this.oldTree, this.newTree);
                this.diffFmt.flush();
            }
        }
        finally {
            this.diffFmt.release();
        }
    }

    static void nameStatus(ThrowingPrintWriter out, List<DiffEntry> files) throws IOException {
        for (DiffEntry ent : files) {
            switch (ent.getChangeType()) {
                case ADD: {
                    out.println("A\t" + ent.getNewPath());
                    break;
                }
                case DELETE: {
                    out.println("D\t" + ent.getOldPath());
                    break;
                }
                case MODIFY: {
                    out.println("M\t" + ent.getNewPath());
                    break;
                }
                case COPY: {
                    out.format("C%1$03d\t%2$s\t%3$s", ent.getScore(), ent.getOldPath(), ent.getNewPath());
                    out.println();
                    break;
                }
                case RENAME: {
                    out.format("R%1$03d\t%2$s\t%3$s", ent.getScore(), ent.getOldPath(), ent.getNewPath());
                    out.println();
                }
            }
        }
    }
}

