/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.tizen.common.lv.LVConstants;
import org.tizen.common.lv.LvPlugin;
import org.tizen.common.lv.manager.LVManager;
import org.tizen.common.lv.message.LVMessages;
import org.tizen.common.lv.model.LVLocaleVO;
import org.tizen.common.lv.model.LVStringVO;
import org.tizen.common.lv.ui.LVContentTab;
import org.tizen.common.lv.ui.LocalizationView;
import org.tizen.common.lv.ui.dialog.LVExportWizardPage;
import org.tizen.common.lv.ui.dialog.LVImportWizardPage;
import org.tizen.common.lv.ui.dialog.LVLocalizeStringDialog;
import org.tizen.common.lv.ui.helper.LVDefaultStringListener;
import org.tizen.common.lv.ui.helper.LVStringEditingSupport;
import org.tizen.common.lv.ui.helper.LVStringLabelProvider;
import org.tizen.common.lv.ui.helper.LVTableUtil;
import org.tizen.common.ui.dialog.FileDialogUtils;
import org.tizen.common.ui.wizards.exports.AbstractFileExportWizardPage;
import org.tizen.common.ui.wizards.exports.TizenExportWizard;
import org.tizen.common.ui.wizards.imports.AbstractFileImportWizardPage;
import org.tizen.common.ui.wizards.imports.TizenImportWizard;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ViewUtil;

public class LVStringTab
extends LVContentTab
implements LVDefaultStringListener {
    private StackLayout stack;
    private TableViewer viewer;
    private Table table;
    private TableViewerColumn viewerCol1;
    private TableViewerColumn viewerCol2;
    private TableColumn col1;
    private TableColumn col2;
    private CTabItem currentTab = null;
    private int preSelected = -1;

    public LVStringTab(IProject project, CTabFolder folder) {
        super(project, folder, LVMessages.TAB_STRING);
    }

    @Override
    protected void initTable(Composite composite) {
        this.viewer = new TableViewer(composite, 66306);
        this.createColumns(this.viewer);
        this.table = this.viewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LVStringLabelProvider());
    }

    private void createColumns(TableViewer viewer) {
        this.viewerCol1 = LVTableUtil.createColumn(viewer, 0, LVConstants.WIDTH_COLS_STRING[0]);
        this.col1 = this.viewerCol1.getColumn();
        this.viewerCol2 = LVTableUtil.createColumn(viewer, 0, LVConstants.WIDTH_COLS_STRING[1], true);
        this.col2 = this.viewerCol2.getColumn();
        this.col2.setText("Value");
        this.viewerCol1.setEditingSupport((EditingSupport)new LVStringEditingSupport(viewer, 0, this));
        this.viewerCol2.setEditingSupport((EditingSupport)new LVStringEditingSupport(viewer, 1, this));
        this.setReversibleColumnText();
    }

    private void setReversibleColumnText() {
        String columnText = null;
        columnText = KEY_MODE ? "Locale" : "Id";
        this.col1.setText(columnText);
    }

    @Override
    protected void initInnerTab(CTabFolder parent) {
        super.initInnerTab(parent);
        this.itemDel.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                TableItem[] selection;
                LVStringTab tab;
                Table table;
                if (LVStringTab.this.table.getSelectionCount() <= 0) {
                    return;
                }
                LocalizationView view = (LocalizationView)ViewUtil.getView((String)"org.tizen.common.lv.view");
                IProject project = view.getProject();
                if (project == null) {
                    return;
                }
                int tabIndex = view.folder.getSelectionIndex();
                if (tabIndex == 1 && (table = (tab = (LVStringTab)view.tab_str).getTable()) != null && !table.isDisposed() && (selection = tab.getTable().getSelection()).length > 0) {
                    String[] labels = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
                    ArrayList<String> keys = new ArrayList<String>();
                    TableItem[] tableItemArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        LVStringVO svo = (LVStringVO)item.getData();
                        keys.add(svo.getId());
                        ++n2;
                    }
                    for (String key : keys) {
                        String message = String.format(LVMessages.DELETE_STRING_ID_MESSAGE, key);
                        int returnCode = FileDialogUtils.openFileDialog((String[])labels, (String)message, (int)3);
                        switch (returnCode) {
                            case 1: {
                                break;
                            }
                            default: {
                                LVManager.getManager(project).removeString(key);
                                LVStringTab.this.setDirty();
                            }
                        }
                    }
                }
            }
        });
        parent.setLayoutData((Object)new GridData(1808));
        this.stack = new StackLayout();
        parent.setLayout((Layout)this.stack);
        this.createInnerTabs(parent);
        parent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = LVStringTab.this.innerFolder.getSelection();
                if (LVStringTab.this.currentTab == item) {
                    return;
                }
                LVStringTab.this.currentTab = item;
                if (LVStringTab.this.currentTab == null) {
                    return;
                }
                LVStringTab.this.updateTableContents();
                ((LVStringTab)LVStringTab.this).stack.topControl = item.getControl();
            }
        });
        if (this.innerFolder.getItemCount() > 0) {
            CTabItem item = this.innerFolder.getItem(0);
            parent.setSelection(item);
            this.stack.topControl = item.getControl();
        }
    }

    @Override
    protected void initToolbar(CTabFolder folder) {
        super.initToolbar(folder);
        this.itemAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                Shell shell = SWTUtil.getActiveShell();
                LocalizationView view = (LocalizationView)ViewUtil.getView((String)"org.tizen.common.lv.view");
                IProject project = view.getProject();
                if (project == null) {
                    return;
                }
                LVLocalizeStringDialog dialog = new LVLocalizeStringDialog(shell, project);
                if (dialog.open() == 0) {
                    List<LVStringVO> svoList = dialog.getLocalizedContent();
                    LVManager.getManager(selectedProject).addStrings(svoList);
                    LVStringTab.this.setDirty();
                    view.folder.setSelection(1);
                }
            }
        });
        this.addImportToolItem();
        this.addExportToolItem();
    }

    private void addImportToolItem() {
        ToolItem itemImport = new ToolItem(this.toolbar, 8);
        itemImport.setToolTipText(LVMessages.LABEL_TOOLBAR_IMPORT);
        itemImport.setImage(ImageUtil.getImage((Plugin)LvPlugin.getDefault(), (String)"icons/elcl16/locale_import.png"));
        itemImport.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                LVImportWizardPage page = new LVImportWizardPage(LVStringTab.this.myProject, "LVImportWizardPage");
                TizenImportWizard wizard = new TizenImportWizard((AbstractFileImportWizardPage)page, LVMessages.LABEL_IMPORT_DLG_TITLE, null);
                WizardDialog dialog = new WizardDialog(SWTUtil.getActiveShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    LVStringTab.this.notifyLocaleChanged();
                }
            }
        });
    }

    private void addExportToolItem() {
        ToolItem itemExport = new ToolItem(this.toolbar, 8);
        itemExport.setToolTipText(LVMessages.LABEL_TOOLBAR_EXPORT);
        itemExport.setImage(ImageUtil.getImage((Plugin)LvPlugin.getDefault(), (String)"icons/elcl16/locale_export.png"));
        itemExport.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                LVExportWizardPage page = new LVExportWizardPage(LVStringTab.this.myProject, "LVExportWizardPage");
                TizenExportWizard wizard = new TizenExportWizard((AbstractFileExportWizardPage)page, LVMessages.LABEL_EXPORT_DLG_TITLE, null);
                WizardDialog dialog = new WizardDialog(SWTUtil.getActiveShell(), (IWizard)wizard);
                dialog.open();
            }
        });
    }

    private void resetTableContents(CTabItem tab) {
        if (tab != null) {
            if (KEY_MODE) {
                List<LVStringVO> svoList = LVManager.getManager(selectedProject).getStringList(tab.getText());
                this.viewer.setInput(svoList);
            } else if (tab.getText().equals(LVMessages.TAB_DEFAULT)) {
                List<LVStringVO> svoList = LVManager.getManager(selectedProject).getDefaultList();
                this.viewer.setInput(svoList);
            } else {
                List<LVLocaleVO> localeList = LVManager.getManager(selectedProject).getTargetLocaleList();
                for (LVLocaleVO locale : localeList) {
                    if (!locale.getLanguageTag().equals(tab.getText())) continue;
                    List<LVStringVO> svoList = LVManager.getManager(selectedProject).getStringList(locale);
                    this.viewer.setInput(svoList);
                    break;
                }
            }
        } else {
            this.viewer.setInput(new ArrayList());
        }
    }

    private void createInnerTabs(CTabFolder parent) {
        if (KEY_MODE) {
            List<LVStringVO> svoList = LVManager.getManager(selectedProject).getDefaultList();
            for (LVStringVO svo : svoList) {
                this.createInnerTab(parent, svo.getId());
            }
        } else {
            List<LVLocaleVO> locList = LVManager.getManager(selectedProject).getTargetLocaleList();
            for (LVLocaleVO loc : locList) {
                this.createInnerTab(parent, loc.getLanguageTag(), loc.getDetail(), loc.getFlag());
            }
        }
    }

    private CTabItem createInnerTab(CTabFolder parent, String text, String tooltip, Image image) {
        CTabItem innerTab = this.createInnerTab(parent, text);
        innerTab.setImage(image);
        innerTab.setToolTipText(tooltip);
        return innerTab;
    }

    private CTabItem createInnerTab(CTabFolder parent, String text) {
        CTabItem innerTab = new CTabItem(parent, 0);
        innerTab.setText(text);
        innerTab.setControl((Control)this.table);
        return innerTab;
    }

    @Override
    protected void projectChanged(IProject project) {
        super.projectChanged(project);
        this.changeActTool(project);
        this.myProject = project;
        this.setDirty();
        this.updateOuterTab();
    }

    @Override
    protected void updateOuterTab() {
        if (this.isDirty && this.folder.getSelectionIndex() == 1) {
            this.updateInnerTabs();
            this.updateTableContents();
            this.isDirty = false;
        }
    }

    private void updateInnerTabs() {
        int index;
        CTabItem[] cTabItemArray = this.innerFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            item.dispose();
            ++n2;
        }
        this.createInnerTabs(this.innerFolder);
        if (this.innerFolder.getItemCount() > 0 && (index = this.innerFolder.getSelectionIndex()) < 0) {
            if (this.preSelected != -1) {
                this.innerFolder.setSelection(this.preSelected);
                this.stack.topControl = this.innerFolder.getItem(this.preSelected).getControl();
                this.preSelected = -1;
            } else {
                this.innerFolder.setSelection(0);
                this.stack.topControl = this.innerFolder.getItem(0).getControl();
            }
        }
    }

    public Table getTable() {
        return this.table;
    }

    private void updateTableContents() {
        if (this.innerFolder.getSelectionIndex() < 0 && this.innerFolder.getItemCount() > 0) {
            this.innerFolder.setSelection(0);
        }
        this.setReversibleColumnText();
        this.resetTableContents(this.innerFolder.getSelection());
        this.viewer.refresh();
    }

    @Override
    public void viewmodeChanged() {
        this.updateOuterTab();
    }

    @Override
    protected void localeChanged() {
        this.isDirty = true;
        this.updateOuterTab();
    }

    @Override
    protected void outerTabSelected() {
        this.changeActAdd(selectedProject);
        this.changeActTool(selectedProject);
        if (this.myProject == selectedProject) {
            if (this.isDirty) {
                this.updateOuterTab();
                this.isDirty = false;
            }
        } else {
            this.myProject = selectedProject;
            this.setDirty();
            this.updateOuterTab();
        }
    }

    @Override
    protected void selectionChanged(ISelection selection) {
    }

    @Override
    public void resourceChanged() {
        this.updateOuterTab();
    }

    @Override
    public void stringValueChanged(LVStringVO svo, String value) {
        if (svo.getLocale().equals(LVManager.getDefaultLocale()) && StringUtil.isEmpty((CharSequence)value)) {
            DialogUtil.openErrorDialog((String)LVMessages.UI_ADD_L10N_STR_ERR_MSG_DEFAULT);
            return;
        }
        if (!svo.getValue().equals(value)) {
            this.preSelected = this.innerFolder.getSelectionIndex();
            svo.setValue(value);
            LVManager.getManager(this.myProject).updateString(svo);
        }
    }
}

