/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model.run;

import java.io.Serializable;
import java.sql.Date;
import java.text.SimpleDateFormat;
import org.tizen.common.rest.model.run.RequestModel;
import org.tizen.common.rest.model.run.ResponseModel;
import org.tizen.common.rest.util.StringUtil;

public class TestData
implements Serializable {
    private static final long serialVersionUID = -1614970624396920920L;
    private RequestModel requestModel;
    private ResponseModel responseModel;
    private long startTime;
    private long latency;

    public TestData(RequestModel requestModel, ResponseModel responseModel) {
        this.requestModel = requestModel;
        this.responseModel = responseModel;
    }

    public RequestModel getRequestModel() {
        return this.requestModel;
    }

    public void setRequestModel(RequestModel requestModel) {
        this.requestModel = requestModel;
    }

    public ResponseModel getResponseModel() {
        return this.responseModel;
    }

    public void setResponseModel(ResponseModel responseModel) {
        this.responseModel = responseModel;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getLatency() {
        return this.latency;
    }

    public void setLatency(long latency) {
        this.latency = latency;
    }

    public String toPrintableString() {
        ResponseModel resModel;
        StringBuilder builder = new StringBuilder();
        String lf = StringUtil.getLineSeparator();
        builder.append("########## REST API TEST ##########" + lf);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss");
        builder.append("\tStart time : " + format.format(new Date(this.getStartTime())) + lf);
        builder.append("\tResponse time : " + this.getLatency() + " ms" + lf);
        builder.append(lf);
        RequestModel reqModel = this.getRequestModel();
        if (reqModel != null) {
            String reqStr = reqModel.toPrintableString();
            builder.append(String.valueOf(reqStr) + lf);
        }
        if ((resModel = this.getResponseModel()) != null) {
            String resStr = this.getResponseModel().toPrintableString();
            builder.append(String.valueOf(resStr) + lf);
        }
        builder.append(lf);
        return builder.toString();
    }
}

