/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.run;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.model.run.AdvancedTreePath;
import org.tizen.common.rest.model.run.HistoryData;
import org.tizen.common.rest.model.run.RunHistory;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.run.HistoryChangeEvent;
import org.tizen.common.rest.run.IHistoryChangeListener;
import org.tizen.common.rest.util.OutputUtil;

public class RunHistoryManager {
    private static RunHistoryManager instance;
    private HistoryData historyData;
    private List<IHistoryChangeListener> listeners = new ArrayList<IHistoryChangeListener>();

    public static RunHistoryManager getInstance() {
        if (instance == null) {
            instance = new RunHistoryManager();
        }
        return instance;
    }

    private RunHistoryManager() {
        this.loadRunHistories();
    }

    private void loadRunHistories() {
        IPreferenceStore prefStore = RestPlugin.getDefault().getPreferenceStore();
        String historyStrs = prefStore.getString("PREF_KEY_RUN_HISTORY");
        try {
            this.historyData = OutputUtil.fromJson(HistoryData.class, historyStrs);
        }
        catch (Exception e) {
            RestPlugin.log(e);
        }
        if (this.historyData == null) {
            this.historyData = new HistoryData();
        }
        this.fireHistoryChanged();
    }

    private void saveRunHistories() {
        IPreferenceStore prefStore = RestPlugin.getDefault().getPreferenceStore();
        try {
            String str = OutputUtil.toJson(this.historyData);
            if (str != null && str.length() > 0) {
                prefStore.setValue("PREF_KEY_RUN_HISTORY", str);
            }
            this.fireHistoryChanged();
        }
        catch (Exception e) {
            RestPlugin.log(e);
        }
    }

    private void fireHistoryChanged() {
        HistoryChangeEvent e = new HistoryChangeEvent(this.historyData);
        for (IHistoryChangeListener listener : this.listeners) {
            listener.historyChanged(e);
        }
    }

    public void addHistoryChangedListener(IHistoryChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeHistoryChangedListener(IHistoryChangeListener listener) {
        this.listeners.remove(listener);
    }

    private static String generateModelId(RunHistory history) {
        return String.valueOf(history.getDisplayName()) + " [" + history.getId() + "]";
    }

    public Map<String, List<AdvancedTreePath>> getRunHistories() {
        return this.historyData.getHistories();
    }

    public List<AdvancedTreePath> getRunHistory(String key) {
        return this.historyData.getHistory(key);
    }

    public static List<AdvancedTreePath> generateRunHistory(ITreeSelection selection) {
        TreePath[] paths = selection.getPaths();
        if (paths.length > 0) {
            ArrayList<AdvancedTreePath> buf = new ArrayList<AdvancedTreePath>();
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                int count = path.getSegmentCount();
                RunHistory[] histories = new RunHistory[count];
                int i = 0;
                while (i < count) {
                    Object obj = path.getSegment(i);
                    if (!(obj instanceof IRestUiModel)) {
                        histories = null;
                        break;
                    }
                    IRestUiModel model = (IRestUiModel)obj;
                    histories[i] = new RunHistory(model);
                    ++i;
                }
                if (histories != null) {
                    AdvancedTreePath newPath = new AdvancedTreePath(histories);
                    buf.add(newPath);
                }
                ++n2;
            }
            return buf;
        }
        return null;
    }

    public List<AdvancedTreePath> putRunHistory(ITreeSelection selection) {
        TreePath[] paths = selection.getPaths();
        if (paths.length > 0) {
            ArrayList<AdvancedTreePath> buf = new ArrayList<AdvancedTreePath>();
            String id = null;
            boolean keyFound = false;
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                int count = path.getSegmentCount();
                RunHistory[] histories = new RunHistory[count];
                int i = 0;
                while (i < count) {
                    Object obj = path.getSegment(i);
                    if (!(obj instanceof IRestUiModel)) {
                        histories = null;
                        break;
                    }
                    IRestUiModel model = (IRestUiModel)obj;
                    histories[i] = new RunHistory(model);
                    ++i;
                }
                if (histories != null) {
                    AdvancedTreePath newPath = new AdvancedTreePath(histories);
                    buf.add(newPath);
                    if (!keyFound) {
                        RunHistory h = newPath.getLastSegment();
                        id = RunHistoryManager.generateModelId(h);
                        keyFound = true;
                    }
                }
                ++n2;
            }
            if (keyFound) {
                List<AdvancedTreePath> old = this.historyData.putHistory(id, buf);
                this.saveRunHistories();
                return old;
            }
        }
        return null;
    }

    public List<AdvancedTreePath> removeRunHistory(String key) {
        List<AdvancedTreePath> result = this.historyData.removeHistory(key);
        this.saveRunHistories();
        return result;
    }

    public void clearRunHistories() {
        this.historyData.clearHistories();
        this.saveRunHistories();
    }

    public void updateHistorySize(int newSize) {
        this.historyData.updateHistorySize(newSize);
    }
}

