/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import java.io.IOException;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.util.SWTUtil;
import org.tizen.sdblib.DeviceState;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.service.FileEntry;

public class ConnectionExplorerLabelProvider
extends LabelProvider {
    private final Logger logger = LoggerFactory.getLogger(ConnectionExplorerLabelProvider.class);
    private final Image fileImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/file.png").createImage();
    private final Image folderImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/directory.png").createImage();
    private final Image fileLinkImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/file_link.png").createImage();
    private final Image folderLinkImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/directory_link.png").createImage();
    private final Image otherImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/file.png").createImage();
    private final Image emulatorImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/emulator.png").createImage();
    private final Image emulatorSuspendedImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/emulator_suspend.png").createImage();
    private final Image emulatorLockedImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/emulator_lock.png").createImage();
    private final Image deviceImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/device.png").createImage();
    private final Image deviceSuspendedImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/device_suspend.png").createImage();
    private final Image deviceLockedImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/device_lock.png").createImage();
    private final Image tvImage = ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/obj16/tv.png").createImage();

    public ConnectionExplorerLabelProvider(Display display) {
    }

    public Image getImage(Object element) {
        if (element instanceof FileEntry) {
            FileEntry entry = (FileEntry)element;
            switch (entry.getType()) {
                case File: {
                    return this.fileImage;
                }
                case Link: {
                    return this.fileLinkImage;
                }
                case Directory: {
                    return this.folderImage;
                }
                case DirectoryLink: {
                    return this.folderLinkImage;
                }
                case RootEmulator: {
                    DeviceState state = entry.getDevice().getState();
                    if (state == DeviceState.SUSPENDED) {
                        return this.emulatorSuspendedImage;
                    }
                    if (state == DeviceState.LOCKED) {
                        return this.emulatorLockedImage;
                    }
                    return this.emulatorImage;
                }
                case RootDevice: {
                    try {
                        if ("tv".equals(entry.getDevice().getPlatformCapability().getProfileName())) {
                            return this.tvImage;
                        }
                    }
                    catch (IOException iOException) {
                        this.logger.error("Failed to get platform capability");
                    }
                    DeviceState deviceState = entry.getDevice().getState();
                    if (deviceState == DeviceState.SUSPENDED) {
                        return this.deviceSuspendedImage;
                    }
                    if (deviceState == DeviceState.LOCKED) {
                        return this.deviceLockedImage;
                    }
                    return this.deviceImage;
                }
            }
            return this.otherImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof FileEntry) {
            FileEntry entry = (FileEntry)element;
            if (entry.isRoot()) {
                return ConnectionExplorerLabelProvider.getDeviceSerialWithName(entry);
            }
            return entry.getName();
        }
        if (element instanceof IDevice) {
            IDevice device = (IDevice)element;
            return device.getDeviceName();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        SWTUtil.tryDispose((Resource[])new Resource[]{this.fileImage, this.folderImage, this.fileLinkImage, this.folderLinkImage, this.otherImage, this.emulatorImage, this.deviceImage});
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public static String getDeviceSerialWithName(IDevice device) {
        return ConnectionExplorerLabelProvider.combineSerialWithName(device.getSerialNumber(), device.getDeviceName());
    }

    public static String getDeviceSerialWithName(FileEntry entry) {
        return ConnectionExplorerLabelProvider.combineSerialWithName(entry.getDevice().getSerialNumber(), entry.getDevice().getDeviceName());
    }

    private static String combineSerialWithName(String serial, String name) {
        return String.format("%s (%s)", serial, name);
    }
}

