/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import zipeditor.model.Node;
import zipeditor.model.ZipModel;

public class TarNode
extends Node {
    private TarEntry tarEntry;
    private int groupId;
    private String groupName = new String();
    private int userId;
    private String userName = new String();
    private int mode;

    public TarNode(ZipModel model, TarEntry entry, String name, boolean isFolder) {
        this(model, name, isFolder);
        this.tarEntry = entry;
        if (this.tarEntry != null) {
            this.size = this.tarEntry.getSize();
            if (this.tarEntry.getModTime() != null) {
                this.time = this.tarEntry.getModTime().getTime();
            }
            this.groupId = this.tarEntry.getGroupId();
            this.groupName = this.tarEntry.getGroupName();
            this.userId = this.tarEntry.getUserId();
            this.userName = this.tarEntry.getUserName();
            this.mode = this.tarEntry.getMode();
        }
    }

    public TarNode(ZipModel model, String name, boolean isFolder) {
        super(model, name, isFolder);
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public int getMode() {
        return this.mode;
    }

    public void setGroupId(int groupId) {
        if (groupId == this.groupId) {
            return;
        }
        this.groupId = groupId;
        this.model.setDirty(true);
        this.model.notifyListeners();
    }

    public void setGroupName(String groupName) {
        if (groupName == this.groupName || groupName != null && groupName.equals(this.groupName)) {
            return;
        }
        this.groupName = groupName;
        this.model.setDirty(true);
        this.model.notifyListeners();
    }

    public void setUserId(int userId) {
        if (userId == this.userId) {
            return;
        }
        this.userId = userId;
        this.model.setDirty(true);
        this.model.notifyListeners();
    }

    public void setUserName(String userName) {
        if (userName == this.userName || userName != null && userName.equals(this.userName)) {
            return;
        }
        this.userName = userName;
        this.model.setDirty(true);
        this.model.notifyListeners();
    }

    @Override
    protected InputStream doGetContent() throws IOException {
        InputStream in = super.doGetContent();
        if (in != null) {
            return in;
        }
        if (this.tarEntry != null) {
            return new EntryStream(this.tarEntry, this.getTarFile());
        }
        return null;
    }

    private TarInputStream getTarFile() throws IOException {
        switch (this.model.getType()) {
            default: {
                return new TarInputStream((InputStream)new FileInputStream(this.model.getZipPath()));
            }
            case 4: {
                return new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(this.model.getZipPath())));
            }
            case 6: 
        }
        FileInputStream in = new FileInputStream(this.model.getZipPath());
        ((InputStream)in).skip(2L);
        return new TarInputStream((InputStream)new CBZip2InputStream((InputStream)in));
    }

    @Override
    public void reset() {
        super.reset();
        this.size = this.tarEntry.getSize();
        if (this.tarEntry.getModTime() != null) {
            this.time = this.tarEntry.getModTime().getTime();
        }
    }

    @Override
    public void update(Object entry) {
        if (!(entry instanceof TarEntry)) {
            return;
        }
        TarEntry tarEntry = (TarEntry)entry;
        this.time = tarEntry.getModTime().getTime();
    }

    @Override
    public Node create(ZipModel model, String name, boolean isFolder) {
        return new TarNode(model, name, isFolder);
    }

    private class EntryStream
    extends InputStream {
        private InputStream in;

        private EntryStream(TarEntry entry, TarInputStream in) throws IOException {
            TarEntry e = null;
            while ((e = in.getNextEntry()) != null) {
                if (!entry.equals(e)) continue;
                if (entry.getSize() < 10000000L) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    in.copyEntryContents((OutputStream)out);
                    this.in = new ByteArrayInputStream(out.toByteArray());
                    break;
                }
                File tmpFile = new File(TarNode.this.model.getTempDir(), Integer.toString((int)System.currentTimeMillis()));
                FileOutputStream out = new FileOutputStream(tmpFile);
                in.copyEntryContents((OutputStream)out);
                out.close();
                this.in = new FileInputStream(tmpFile);
                break;
            }
            in.close();
        }

        @Override
        public int read() throws IOException {
            return this.in != null ? this.in.read() : -1;
        }

        @Override
        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
            }
        }
    }
}

