/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.StringUtil;

public class FileUtil {
    private static final int BUFFER_SIZE = 8192;
    protected static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static boolean createDirectory(File dir) {
        return dir.mkdirs();
    }

    public static boolean createDirectory(String fullPath) {
        return FileUtil.createDirectory(new File(fullPath));
    }

    public static boolean createDirectory(String dirName, String destDir) {
        Assert.notNull(dirName);
        if (destDir == null) {
            destDir = System.getProperty("user.dir");
        }
        String fullPath = FilenameUtil.addTailingPath(destDir, dirName);
        return FileUtil.createDirectory(new File(fullPath));
    }

    public static boolean createTextFile(File file, String text, String encoding) throws IOException {
        if (!file.createNewFile()) {
            return false;
        }
        return FileUtil.writeTextFile(file, text, encoding);
    }

    public static IFile getIFile(IProject project, String path, String text, String encoding) throws IOException {
        File file = new File(path);
        if (!file.createNewFile()) {
            return null;
        }
        FileUtil.writeTextFile(file, text, encoding, true);
        IFile iFile = project.getFile(path.replace(project.getLocation().toString(), ""));
        return iFile;
    }

    public static boolean createTextFile(String fullPath, String text, String encoding) throws IOException {
        return FileUtil.createTextFile(new File(fullPath), text, encoding);
    }

    public static boolean createTextFile(String fileName, String text, String destDir, String encoding) throws IOException {
        Assert.notNull(fileName);
        if (destDir == null) {
            destDir = System.getProperty("user.dir");
        }
        String fullPath = FilenameUtil.addTailingPath(destDir, fileName);
        return FileUtil.createTextFile(fullPath, text, encoding);
    }

    public static boolean writeTextFile(File file, String text, String encoding) throws IOException {
        return FileUtil.writeTextFile(file, text, encoding, false);
    }

    public static boolean appendTextFile(File file, String text, String encoding) throws IOException {
        return FileUtil.writeTextFile(file, text, encoding, true);
    }

    private static boolean writeTextFile(File file, String text, String encoding, boolean doAppend) throws IOException {
        File parent;
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        if (!(parent = file.getAbsoluteFile().getParentFile()).exists() && !parent.mkdirs()) {
            throw new IOException("File write error. Cannot create directory - " + parent.getAbsolutePath());
        }
        BufferedWriter out = null;
        FileOutputStream fileOut = new FileOutputStream(file, doAppend);
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOut, encoding), 8192);
            out.write(text.toCharArray(), 0, text.length());
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(out);
            throw throwable;
        }
        IOUtil.tryClose(out);
        return true;
    }

    public static String readTextFile(File file, String encoding) throws IOException {
        return FileUtil.readTextStream(new FileInputStream(file), encoding);
    }

    public static String readTextStream(InputStream input, String encoding) throws IOException {
        String string;
        Assert.notNull(input);
        InputStreamReader in = null;
        encoding = StringUtil.nvl(encoding, System.getProperty("file.encoding"));
        try {
            in = new InputStreamReader(input, encoding);
            string = IOUtil.getString(new BufferedReader(in, 8192));
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(in);
            throw throwable;
        }
        IOUtil.tryClose(in);
        return string;
    }

    public static String getFileExtension(String fullName) {
        return StringUtil.getLastStringAfter(fullName, ".");
    }

    public static String getFileNameWithoutExtension(String fullName) {
        if (fullName == null) {
            return null;
        }
        int k = fullName.lastIndexOf(".");
        return k != -1 ? fullName.substring(0, k) : fullName;
    }

    public static String getFileNameFromPath(String path) {
        String result = StringUtil.getLastStringAfter(path, "/");
        if (result == null) {
            result = StringUtil.getLastStringAfter(path, "\\");
        }
        if (result == null) {
            result = path;
        }
        return result;
    }

    public static boolean recursiveDelete(File file) {
        boolean result = true;
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                result &= FileUtil.recursiveDelete(child);
                ++n2;
            }
        }
        return result &= file.delete();
    }

    public static boolean recursiveDelete(String path) {
        if (!FileUtil.isExist(path)) {
            return false;
        }
        File file = new File(path);
        return FileUtil.recursiveDelete(file);
    }

    public static void redirectStream(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[8192];
        BufferedInputStream bin = new BufferedInputStream(is, 8192);
        BufferedOutputStream bout = new BufferedOutputStream(os, 8192);
        int n = 0;
        while ((n = bin.read(buffer, 0, buffer.length)) >= 0) {
            bout.write(buffer, 0, n);
        }
        bout.flush();
    }

    public static void copyTo(String from, String to) throws IOException {
        FileUtil.copyTo(from, to, false);
    }

    public static void copyTo(String from, String to, boolean append) throws IOException {
        File fromFile = new File(from);
        File toFile = new File(to);
        FileUtil.copyTo(fromFile, toFile, append);
    }

    public static void copyTo(File fromFile, File toFile, boolean append) throws IOException {
        File parent = toFile.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("File copy error. Cannot create directory - " + parent.getAbsolutePath());
        }
        if (FilenameUtil.equals(fromFile, toFile)) {
            throw new IOException("Unable to write file " + fromFile + " on itself.");
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(fromFile);
            in = new BufferedInputStream(in, 8192);
            out = new FileOutputStream(toFile, append);
            out = new BufferedOutputStream(out, 8192);
            IOUtil.redirect(in, out);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(in, out);
            throw throwable;
        }
        IOUtil.tryClose(in, out);
    }

    public static void copyRecursively(String from, String to) throws IOException {
        FileUtil.copyRecursively(from, to, true);
    }

    public static void copyRecursively(String from, String to, boolean overwrite) throws IOException {
        FileUtil.copyRecursively(from, to, overwrite, new File[0]);
    }

    public static void copyRecursively(String from, String to, boolean overwrite, File ... filters) throws IOException {
        File fromDir = new File(from);
        File toDir = new File(to);
        if (!fromDir.exists()) {
            logger.warn("Directory {} does not exist.", (Object)fromDir.getCanonicalPath());
            return;
        }
        FileUtil.checkDirectory(fromDir, toDir);
        FileUtil.copyRecursivelyWithoutDirChecking(fromDir, toDir, overwrite, filters);
    }

    private static void checkDirectory(File fromDir, File toDir) throws IOException {
        if (!toDir.exists()) {
            toDir.mkdirs();
        } else if (toDir.isFile()) {
            throw new IOException("destination directory " + toDir.toString() + " is a file.");
        }
        if (!fromDir.exists()) {
            throw new IOException("source directory " + fromDir.toString() + " does not exist.");
        }
        if (fromDir.isFile()) {
            throw new IOException("source directory " + fromDir.toString() + " is a file.");
        }
    }

    private static void copyRecursivelyWithoutDirChecking(File fromDir, File toDir, boolean overwrite, File ... filters) throws IOException {
        HashSet<String> filterSet = new HashSet<String>();
        if (filters != null) {
            File[] fileArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                File filter = fileArray[n2];
                filterSet.add(filter.getCanonicalPath());
                ++n2;
            }
        }
        Stack<File> fromFileStack = new Stack<File>();
        Stack<File> toFileStack = new Stack<File>();
        fromFileStack.add(fromDir);
        toFileStack.add(toDir);
        while (!fromFileStack.isEmpty()) {
            File fromFile = (File)fromFileStack.pop();
            File toFile = (File)toFileStack.pop();
            if (fromFile.isDirectory()) {
                File[] newFromFiles;
                toFile.mkdirs();
                File[] fileArray = newFromFiles = fromFile.listFiles();
                int n = newFromFiles.length;
                int n3 = 0;
                while (n3 < n) {
                    File newFromFile = fileArray[n3];
                    fromFileStack.push(newFromFile);
                    toFileStack.push(new File(toFile, newFromFile.getName()));
                    ++n3;
                }
                continue;
            }
            if (!fromFile.isFile() || toFile.exists() && toFile.isFile() && !overwrite || filterSet.size() != 0 && filterSet.contains(fromFile.getCanonicalPath())) continue;
            FileUtil.copyTo(fromFile, toFile, false);
        }
    }

    public static boolean equals(File file1, File file2) throws IOException {
        if (file1 == null || file2 == null) {
            return false;
        }
        String strFile1 = file1.getCanonicalPath();
        String strFile2 = file2.getCanonicalPath();
        if (strFile1 == null || strFile2 == null) {
            return false;
        }
        return strFile1.equals(strFile2);
    }

    public static boolean checkParentDirectory(File file) {
        Assert.notNull(file);
        File parent = file.getParentFile();
        if (parent == null) {
            return false;
        }
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return true;
    }

    public static boolean checkParentDirectory(String filename) {
        Assert.notNull(filename);
        return FileUtil.checkParentDirectory(new File(filename));
    }

    public static List<File> findFiles(File rootPath, String pattern, boolean recursive) throws FileNotFoundException {
        Assert.notNull(rootPath);
        FileUtil.validateDirectory(rootPath);
        List<File> result = FileUtil.getFileListing(rootPath, pattern, recursive);
        if (result != null) {
            Collections.sort(result);
        }
        return result;
    }

    private static List<File> getFileListing(File rootPath, String pattern, boolean recursive) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = rootPath.listFiles();
        if (filesAndDirs == null) {
            return result;
        }
        File[] fileArray = filesAndDirs;
        int n = filesAndDirs.length;
        int n2 = 0;
        while (n2 < n) {
            List<File> deeperList;
            File file = fileArray[n2];
            String name = file.getName();
            if (name.matches(pattern) && file.isFile()) {
                result.add(file);
            } else if (recursive && (deeperList = FileUtil.getFileListing(file, pattern, recursive)) != null) {
                result.addAll(deeperList);
            }
            ++n2;
        }
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        Assert.notNull(aDirectory, "Directory should not be null.");
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        Assert.isTrue(aDirectory.isDirectory(), "Is not a directory: " + aDirectory);
        Assert.isTrue(aDirectory.canRead(), "Directory cannot be read: " + aDirectory);
    }

    public static String readFromFile(URL source) throws IOException {
        if (!new File(source.getFile()).exists()) {
            throw new FileNotFoundException();
        }
        return FileUtil.readFromFile(source.openStream());
    }

    public static String readFromFile(InputStream in) throws IOException {
        char[] chars = new char[4092];
        InputStreamReader contentsReader = null;
        StringBuffer buffer = new StringBuffer();
        try {
            int c;
            contentsReader = new InputStreamReader(in);
            while ((c = contentsReader.read(chars)) != -1) {
                buffer.append(chars, 0, c);
                if (c != -1) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose(contentsReader);
            throw throwable;
        }
        IOUtil.tryClose(contentsReader);
        return buffer.toString();
    }

    public static String appendPath(String originalPath, String appendPath) {
        if (OSChecker.isWindows()) {
            return FileUtil.appendPath(originalPath, appendPath, true);
        }
        return FileUtil.appendPath(originalPath, appendPath, false);
    }

    public static String appendPath(String originalPath, String appendPath, boolean isWindows) {
        char separatorChar = isWindows ? (char)'\\' : '/';
        char targetChar = isWindows ? (char)'/' : '\\';
        originalPath = originalPath.replace(targetChar, separatorChar);
        appendPath = appendPath.replace(targetChar, separatorChar);
        return FileUtil.trimLastPath(originalPath, separatorChar).concat(FileUtil.trimFirstPath(appendPath, separatorChar));
    }

    public static String convertToOSPath(String input, boolean isWindows) {
        return FileUtil.appendPath(input, "", isWindows);
    }

    public static String convertToOSPath(String input) {
        if (OSChecker.isWindows()) {
            return FileUtil.convertToOSPath(input, true);
        }
        return FileUtil.convertToOSPath(input, false);
    }

    private static String trimLastPath(String originalPath, char targetChar) {
        if (StringUtil.isEmpty(originalPath)) {
            return "";
        }
        char lastChar = originalPath.charAt(originalPath.length() - 1);
        if (lastChar == targetChar) {
            return originalPath.substring(0, originalPath.length() - 1);
        }
        return originalPath;
    }

    private static String trimFirstPath(String originalPath, char targetChar) {
        if (StringUtil.isEmpty(originalPath)) {
            return "";
        }
        char firstChar = originalPath.charAt(0);
        if (firstChar != targetChar) {
            return ("" + targetChar).concat(originalPath);
        }
        return originalPath;
    }

    public static boolean isExist(String path) {
        if (StringUtil.isEmpty(path)) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public static long getFolderSize(File directory) {
        long length = 0L;
        if (!directory.exists()) {
            return length;
        }
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            length = file.isFile() ? (length += file.length()) : (length += FileUtil.getFolderSize(file));
            ++n2;
        }
        return length;
    }
}

