/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.lv.LVConstants;
import org.tizen.common.lv.manager.LVManager;
import org.tizen.common.lv.message.LVMessages;
import org.tizen.common.lv.model.LVLocaleVO;
import org.tizen.common.lv.model.LVStringVO;
import org.tizen.common.lv.ui.dialog.LVAbstractDialog;
import org.tizen.common.lv.ui.helper.LVDefaultStringListener;
import org.tizen.common.lv.ui.helper.LVStringEditingSupport;
import org.tizen.common.lv.ui.helper.LVStringLabelProvider;
import org.tizen.common.lv.ui.helper.LVTableUtil;

public class LVLocalizeStringDialog
extends LVAbstractDialog
implements LVDefaultStringListener {
    private final Logger logger = LoggerFactory.getLogger(LVLocalizeStringDialog.class);
    private IProject project = null;
    private List<LVLocaleVO> targetLocaleList;
    private Composite compTop;
    private Label label;
    private Text text;
    private TableViewer viewer;
    private TableViewerColumn viewerLocaleCol;
    private TableViewerColumn viewerValueCol;
    private TableColumn locCol;
    private TableColumn valCol;
    private LVStringLabelProvider lvStringLabelProvider;
    private LVStringVO defaultVO;
    private List<LVStringVO> localizedContent;

    public LVLocalizeStringDialog(Shell parentShell, IProject project) {
        this(parentShell, LVMessages.UI_ADD_LV_TITLE, LVMessages.UI_ADD_STR_DESC);
        this.project = project;
        this.targetLocaleList = LVManager.getManager(project).getTargetLocaleList();
        this.lvStringLabelProvider = new LVStringLabelProvider(true);
    }

    public LVLocalizeStringDialog(Shell parentShell, String title, String desc) {
        super(parentShell, title, desc);
    }

    @Override
    public void stringValueChanged(LVStringVO svo, String value) {
        this.changeStringOKActivation(svo, value);
    }

    @Override
    protected void createInput(Composite composite) {
        this.compTop = new Composite(composite, 0);
        this.compTop.setLayoutData((Object)new GridData(768));
        this.compTop.setLayout((Layout)new GridLayout(2, false));
        this.label = new Label(this.compTop, 0);
        this.label.setText(LVMessages.LABEL_ADD_STRING);
        this.text = new Text(this.compTop, 2048);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LVLocalizeStringDialog.this.viewer != null) {
                    List svoList = (List)LVLocalizeStringDialog.this.viewer.getInput();
                    LVStringVO defaultSVO = null;
                    for (LVStringVO svo : svoList) {
                        if (!svo.getLocale().equals(LVManager.getDefaultLocale())) continue;
                        defaultSVO = svo;
                        break;
                    }
                    LVLocalizeStringDialog.this.changeStringOKActivation(defaultSVO, defaultSVO.getValue());
                }
            }
        });
    }

    @Override
    protected void createTable(Composite composite) {
        this.viewer = new TableViewer(composite, 68354);
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.createStrColumns(this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList<LVStringVO> svoList = new ArrayList<LVStringVO>();
        for (LVLocaleVO locale : this.targetLocaleList) {
            svoList.add(new LVStringVO(locale, "", ""));
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)this.lvStringLabelProvider);
        this.viewer.setInput(svoList);
    }

    private void createStrColumns(TableViewer viewer) {
        this.viewerLocaleCol = LVTableUtil.createColumn(viewer, 0, LVConstants.WIDTH_COLS_LOCALIZE[0]);
        this.locCol = this.viewerLocaleCol.getColumn();
        this.locCol.setText(LVConstants.COLS_ADD_STRING[0]);
        this.viewerValueCol = LVTableUtil.createColumn(viewer, 0, LVConstants.WIDTH_COLS_LOCALIZE[1], true);
        this.viewerValueCol.setEditingSupport((EditingSupport)new LVStringEditingSupport(viewer, 1, this));
        this.valCol = this.viewerValueCol.getColumn();
        this.valCol.setText(LVConstants.COLS_ADD_STRING[1]);
    }

    private void changeStringOKActivation(LVStringVO svo, String value) {
        if (this.text != null && svo != null) {
            String id = this.text.getText();
            Button button = this.getButton(0);
            if (button != null && !button.isDisposed()) {
                boolean isOk = true;
                if (svo.getLocale().equals(LVManager.getDefaultLocale())) {
                    this.defaultVO = svo;
                }
                svo.setValue(value);
                if (this.defaultVO == null || this.defaultVO.getValue().isEmpty()) {
                    isOk = false;
                    this.setErrorMessage(LVMessages.UI_ADD_L10N_STR_ERR_MSG_DEFAULT);
                }
                if (LVManager.getManager(this.project).isValidKey(id)) {
                    List<LVStringVO> defaultList = LVManager.getManager(this.project).getDefaultList();
                    for (LVStringVO s : defaultList) {
                        if (!s.getId().equals(id)) continue;
                        isOk = false;
                        this.setErrorMessage(LVMessages.UI_ADD_L10N_STR_MSG_SAME_ID);
                        break;
                    }
                } else {
                    if (id.isEmpty()) {
                        this.setErrorMessage(LVMessages.UI_ADD_L10N_STR_ERR_MSG_ID_EMPTY);
                    } else {
                        this.setErrorMessage(LVMessages.UI_ADD_L10N_STR_ERR_MSG_ID);
                    }
                    isOk = false;
                }
                if (isOk) {
                    this.setErrorMessage(null);
                }
                button.setEnabled(isOk);
            }
        }
    }

    protected void okPressed() {
        String id = this.text.getText();
        List svoList = (List)this.viewer.getInput();
        for (LVStringVO svo : svoList) {
            svo.setId(id);
        }
        this.localizedContent = svoList;
        super.okPressed();
    }

    public List<LVStringVO> getLocalizedContent() {
        return this.localizedContent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    public void create() {
        super.create();
        this.setMessage(LVMessages.UI_ADD_L10N_STR_MSG);
    }
}

