/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import zipeditor.ZipEditor;
import zipeditor.actions.EditorAction;

public class ToggleViewModeAction
extends EditorAction {
    private String fPreferenceKey;
    private int fModeConstant;
    private int fMode;

    public ToggleViewModeAction(ZipEditor editor, String text, String preferencePrefix, int modeConstant) {
        super(text, editor);
        this.fPreferenceKey = String.valueOf(preferencePrefix) + "VIEW_MODE";
        this.fModeConstant = modeConstant;
        this.fMode = editor.getPreferenceStore().getInt(this.fPreferenceKey);
        this.checkDependencies();
        this.setChecked((this.fMode & this.fModeConstant) > 0);
    }

    public void run() {
        this.fMode = this.fMode & ~this.fModeConstant | (this.isChecked() ? this.fModeConstant : 0);
        this.checkDependencies();
        this.fEditor.getPreferenceStore().setValue(this.fPreferenceKey, this.fMode);
        this.fEditor.updateView(this.fMode, true);
    }

    private void checkDependencies() {
        boolean allInOneLayer;
        boolean foldersVisible = (this.fMode & 4) > 0;
        boolean bl = allInOneLayer = (this.fMode & 8) > 0;
        if (!foldersVisible && !allInOneLayer) {
            this.fMode |= 8;
        }
    }
}

