/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.model.run.AdvancedTreePath;
import org.tizen.common.rest.model.run.RunHistory;
import org.tizen.common.rest.run.RunHistoryManager;
import org.tizen.common.rest.ui.RestImageRegistry;

public class RESTDynamicRunAs
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IContributionItem[] items;
    private IServiceLocator mServiceLocator;
    private static String RUNAS_KEY = "org.tizen.common.rest.runas";
    public static String RUNAS_PARAM_KEY = "historyKey";

    public RESTDynamicRunAs() {
    }

    public RESTDynamicRunAs(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        CommandContributionItemParameter contributionParameter;
        RunHistoryManager rManager = RunHistoryManager.getInstance();
        Map<String, List<AdvancedTreePath>> map = rManager.getRunHistories();
        Iterator<Map.Entry<String, List<AdvancedTreePath>>> iter = map.entrySet().iterator();
        HashMap<String, String> parameters = null;
        int size = map.entrySet().size();
        int i = size - 1;
        if (size > 0) {
            this.items = new IContributionItem[size + 2];
            while (iter.hasNext()) {
                Map.Entry<String, List<AdvancedTreePath>> entry = iter.next();
                String key = entry.getKey();
                List<AdvancedTreePath> value = entry.getValue();
                parameters = new HashMap<String, String>();
                parameters.put(RUNAS_PARAM_KEY, key);
                contributionParameter = new CommandContributionItemParameter(this.mServiceLocator, null, RUNAS_KEY, parameters, this.getImage(value), null, null, key, null, null, 8, null, true);
                this.items[i--] = new CommandContributionItem(contributionParameter);
            }
            this.items[size] = new Separator();
        } else {
            size = -1;
            this.items = new IContributionItem[1];
        }
        contributionParameter = new CommandContributionItemParameter(this.mServiceLocator, null, RUNAS_KEY, 8);
        contributionParameter.label = RestUIMessages.UI_CLEAR_HISTORY;
        this.items[size + 1] = new CommandContributionItem(contributionParameter);
        return this.items;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.mServiceLocator = serviceLocator;
    }

    private ImageDescriptor getImage(List<AdvancedTreePath> history) {
        ImageDescriptor result = RestImageRegistry.IMG_DESC_RUN;
        if (history != null && history.size() > 0) {
            AdvancedTreePath path = history.get(0);
            RunHistory h = path.getLastSegment();
            String dispName = h.getDisplayName();
            if ("Service".equals(dispName)) {
                result = RestImageRegistry.IMG_DESC_MODEL_APPLICATION;
            } else if ("BaseURL".equals(dispName)) {
                result = RestImageRegistry.IMG_DESC_MODEL_RESOURCES;
            } else if ("Path".equals(dispName)) {
                result = RestImageRegistry.IMG_DESC_MODEL_RESOURCE;
            } else if ("API".equals(dispName)) {
                result = RestImageRegistry.IMG_DESC_MODEL_METHOD;
            }
        }
        return result;
    }
}

