/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.preferences;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.ui.dialogs.AbstractStringsAddDialog;
import org.tizen.common.rest.ui.dialogs.PrefVariableAddDialog;
import org.tizen.common.rest.ui.preferences.AbstractTablePreferencePage;
import org.tizen.common.rest.ui.preferences.TableEditorValidator;

public class UserVariablesPreferencePage
extends AbstractTablePreferencePage {
    public static final String ID_PREFERENCE = "org.tizen.common.rest.ui.preferences.userVariables";
    private TableEditorValidator validator = new TableEditorValidator(0){

        @Override
        public boolean validate(TableItem item, Text text) {
            String str = text.getText();
            boolean containDot = str.contains(".");
            if (containDot) {
                MessageDialog.openWarning((Shell)UserVariablesPreferencePage.this.getShell(), (String)"Invalid input", (String)"Dot(.) is not a valid identifier");
            }
            return !containDot;
        }
    };
    private Combo profileCombo;
    private Button profileDelBtn;
    private Button profileNewBtn;
    private Button profileImportBtn;
    private Button profileExportAllBtn;
    private int lastSelectedComboIndex;

    public UserVariablesPreferencePage() {
        super(RestUIMessages.UserVariablesPreferencePage_description);
    }

    @Override
    protected boolean openAddPopup(Table table) {
        PrefVariableAddDialog dialog = new PrefVariableAddDialog(this.getShell());
        String[] result = (String[])dialog.open();
        if (result != null && result.length == 2) {
            TableItem item = new TableItem(table, 0);
            item.setText(result);
            table.setSelection(item);
            return true;
        }
        return false;
    }

    @Override
    protected Composite createContentArea(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.createProfileArea(composite);
        Table table = this.createTable(composite);
        this.createButtonGroup(composite);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserVariablesPreferencePage.this.updateButtonsEnableState();
            }
        });
        this.updateButtonsEnableState();
        this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Table table = UserVariablesPreferencePage.this.getTable();
                if (table != null && e.widget == table) {
                    Rectangle clientArea = table.getClientArea();
                    Point pt = new Point(e.x, e.y);
                    int index = table.getTopIndex();
                    while (index < table.getItemCount()) {
                        boolean visible = false;
                        TableItem item = table.getItem(index);
                        Rectangle rect1 = item.getTextBounds(0);
                        Rectangle rect2 = item.getTextBounds(1);
                        int itemIndex = -1;
                        if (rect1.contains(pt)) {
                            itemIndex = 0;
                        } else if (rect2.contains(pt)) {
                            itemIndex = 1;
                        }
                        if (itemIndex == 0) {
                            UserVariablesPreferencePage.this.initInPlaceEditor(item, itemIndex, UserVariablesPreferencePage.this.validator);
                            return;
                        }
                        if (itemIndex == 1) {
                            UserVariablesPreferencePage.this.initInPlaceEditor(item, itemIndex);
                            return;
                        }
                        if (!visible && (rect1.intersects(clientArea) || rect2.intersects(clientArea))) {
                            visible = true;
                        }
                        if (!visible) {
                            return;
                        }
                        ++index;
                    }
                }
            }
        });
        return composite;
    }

    private void createProfileArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        GridData data = new GridData(768);
        comp.setLayoutData((Object)data);
        this.createLabel(comp, RestUIMessages.UserVariablesPreferencePage_active_profile_label);
        this.profileCombo = new Combo(comp, 12);
        GridData gd = new GridData(768);
        this.profileCombo.setLayoutData((Object)gd);
        this.profileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UserVariablesPreferencePage.this.checkModified(e, RestUIMessages.UserVariablesPreferencePage_selelction_change_title, RestUIMessages.UserVariablesPreferencePage_selelction_change_message)) {
                    UserVariablesPreferencePage.this.loadTableData();
                    UserVariablesPreferencePage.this.updateButtonsState();
                    UserVariablesPreferencePage.this.lastSelectedComboIndex = UserVariablesPreferencePage.this.profileCombo.getSelectionIndex();
                    UserVariablesPreferencePage.this.setModified(false);
                } else {
                    UserVariablesPreferencePage.this.profileCombo.select(UserVariablesPreferencePage.this.lastSelectedComboIndex);
                }
            }
        });
        this.profileDelBtn = this.createButton(comp, RestUIMessages.UserVariablesPreferencePage_remove_label, 0, 0);
        gd = new GridData();
        gd.widthHint = 80;
        this.profileDelBtn.setLayoutData((Object)gd);
        this.profileDelBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserVariablesPreferencePage.this.setModified(true);
                if (UserVariablesPreferencePage.this.checkModified(e, RestUIMessages.UserVariablesPreferencePage_remove_profile_title, RestUIMessages.UserVariablesPreferencePage_remove_profile_message) && UserVariablesPreferencePage.this.profileCombo.getSelectionIndex() > -1) {
                    String selected = UserVariablesPreferencePage.this.profileCombo.getText();
                    UserVariablesPreferencePage.this.profileCombo.remove(UserVariablesPreferencePage.this.profileCombo.getSelectionIndex());
                    UserVariablesPreferencePage.this.setValue("PREF_KEY_USER_VARIABLES." + selected, "");
                    UserVariablesPreferencePage.this.selectComboByValue(UserVariablesPreferencePage.this.profileCombo.getItems(), "Default");
                    UserVariablesPreferencePage.this.saveComboData();
                    UserVariablesPreferencePage.this.loadTableData();
                    UserVariablesPreferencePage.this.setModified(false);
                    UserVariablesPreferencePage.this.updateButtonsState();
                }
            }
        });
        Composite buttonsComp = new Composite(comp, 0);
        layout = new GridLayout(3, false);
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        buttonsComp.setLayout((Layout)layout);
        data = new GridData();
        data.horizontalSpan = 3;
        buttonsComp.setLayoutData((Object)data);
        this.profileNewBtn = this.createButton(buttonsComp, RestUIMessages.UserVariablesPreferencePage_new_label, 0, 0);
        gd = new GridData();
        gd.widthHint = 80;
        this.profileNewBtn.setLayoutData((Object)gd);
        this.profileNewBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewProfileDialog dlg;
                String[] strs;
                if (UserVariablesPreferencePage.this.checkModified(e, RestUIMessages.UserVariablesPreferencePage_new_profile_title, RestUIMessages.UserVariablesPreferencePage_new_profile_message) && (strs = (String[])(dlg = new NewProfileDialog(UserVariablesPreferencePage.this.getShell())).open()) != null && strs.length > 0) {
                    String profile = strs[0];
                    UserVariablesPreferencePage.this.profileCombo.add(profile);
                    UserVariablesPreferencePage.this.selectComboByValue(UserVariablesPreferencePage.this.profileCombo.getItems(), profile);
                    UserVariablesPreferencePage.this.saveComboData();
                    UserVariablesPreferencePage.this.loadTableData();
                    UserVariablesPreferencePage.this.setModified(false);
                    UserVariablesPreferencePage.this.updateButtonsState();
                }
            }
        });
        this.profileImportBtn = this.createButton(buttonsComp, RestUIMessages.UserVariablesPreferencePage_import_label, 0, 0);
        gd = new GridData();
        gd.widthHint = 80;
        this.profileImportBtn.setLayoutData((Object)gd);
        this.profileImportBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UserVariablesPreferencePage.this.checkModified(e, RestUIMessages.UserVariablesPreferencePage_import_profile_title, RestUIMessages.UserVariablesPreferencePage_import_profile_message)) {
                    UserVariablesPreferencePage.this.importProfile();
                }
            }
        });
        this.profileExportAllBtn = this.createButton(buttonsComp, RestUIMessages.UserVariablesPreferencePage_export_all_label, 0, 0);
        gd = new GridData();
        gd.widthHint = 80;
        this.profileExportAllBtn.setLayoutData((Object)gd);
        this.profileExportAllBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UserVariablesPreferencePage.this.checkModified(e, RestUIMessages.UserVariablesPreferencePage_export_profile_title, RestUIMessages.UserVariablesPreferencePage_export_profile_message)) {
                    UserVariablesPreferencePage.this.exportAllProfiles();
                }
            }
        });
        this.loadComboData();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void importProfile() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.properties"});
        String filePath = dialog.open();
        if (filePath == null || filePath.length() <= 0) return;
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(filePath);
                Properties prop = new Properties();
                prop.load(reader);
                String profiles = prop.getProperty("PREF_KEY_USER_VARIABLES_PROFILE");
                if (profiles.length() > 0) {
                    String[] strs = profiles.split("\\|");
                    String[] originals = this.profileCombo.getItems();
                    ArrayList<String> list = new ArrayList<String>(Arrays.asList(originals));
                    String[] stringArray = strs;
                    int n = strs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        if (!list.contains(str)) {
                            list.add(str);
                        }
                        String key = "PREF_KEY_USER_VARIABLES." + str;
                        String value = prop.getProperty(key);
                        this.setValue(key, value);
                        ++n2;
                    }
                    profiles = this.gatherComboData(list.toArray(new String[list.size()]));
                    this.setValue("PREF_KEY_USER_VARIABLES_PROFILE", profiles);
                }
                String selected = prop.getProperty("PREF_KEY_USER_VARIABLES_SELECTED_PROFILE", "Default");
                this.setValue("PREF_KEY_USER_VARIABLES_SELECTED_PROFILE", selected);
                this.performDefaults();
                return;
            }
            catch (FileNotFoundException e) {
                RestPlugin.log(e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {
                    RestPlugin.log(e2);
                }
                return;
            }
            catch (IOException e) {
                RestPlugin.log(e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e3) {
                    RestPlugin.log(e3);
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    RestPlugin.log(e);
                }
            }
        }
    }

    private void exportAllProfiles() {
        block14: {
            FileDialog dialog = new FileDialog(this.getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.properties"});
            dialog.setOverwrite(true);
            String filePath = dialog.open();
            if (filePath != null && filePath.length() > 0) {
                FileWriter writer = null;
                try {
                    try {
                        String[] strs;
                        writer = new FileWriter(filePath);
                        Properties prop = new Properties();
                        String profiles = this.gatherComboData(this.profileCombo.getItems());
                        prop.setProperty("PREF_KEY_USER_VARIABLES_PROFILE", profiles);
                        String selected = this.getProfileComboSelectedValue();
                        prop.setProperty("PREF_KEY_USER_VARIABLES_SELECTED_PROFILE", selected);
                        String[] stringArray = strs = this.profileCombo.getItems();
                        int n = strs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String str = stringArray[n2];
                            String key = "PREF_KEY_USER_VARIABLES." + str;
                            String value = this.getValue(key);
                            prop.setProperty(key, value);
                            ++n2;
                        }
                        prop.store(writer, null);
                    }
                    catch (IOException e) {
                        RestPlugin.log(e);
                        if (writer == null) break block14;
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            RestPlugin.log(e2);
                        }
                    }
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            RestPlugin.log(e);
                        }
                    }
                }
            }
        }
    }

    protected boolean checkModified(SelectionEvent e, String confirmDialogTitle, String confirmDialogMessage) {
        boolean isOk = true;
        if (this.isModified()) {
            MessageDialog dialog = new MessageDialog(this.getShell(), confirmDialogTitle, null, confirmDialogMessage, 5, new String[]{"OK", "Cancel"}, 1);
            e.doit = isOk = dialog.open() == 0;
        }
        return isOk;
    }

    protected void updateButtonsState() {
        boolean enabled = false;
        String selected = this.getProfileComboSelectedValue();
        if (!"Default".equals(selected)) {
            enabled = true;
        }
        this.profileDelBtn.setEnabled(enabled);
    }

    private String getProfileComboSelectedValue() {
        String selected = "";
        int index = this.profileCombo.getSelectionIndex();
        if (index > -1) {
            selected = this.profileCombo.getItem(index);
        }
        return selected;
    }

    private void loadComboData() {
        if (this.profileCombo == null) {
            return;
        }
        String profiles = this.getValue("PREF_KEY_USER_VARIABLES_PROFILE");
        if (profiles.length() > 0) {
            String[] strs = profiles.split("\\|");
            this.profileCombo.setItems(strs);
            String selected = this.getValue("PREF_KEY_USER_VARIABLES_SELECTED_PROFILE");
            this.selectComboByValue(strs, selected);
        }
        this.updateButtonsState();
    }

    private void selectComboByValue(String[] comboItems, String selectedValue) {
        int selectedIndex = -1;
        int i = 0;
        while (i < comboItems.length) {
            if (selectedValue.equals(comboItems[i])) {
                selectedIndex = i;
                break;
            }
            ++i;
        }
        if (selectedIndex > -1) {
            this.lastSelectedComboIndex = selectedIndex;
            this.profileCombo.select(selectedIndex);
        }
    }

    @Override
    protected void performDefaults() {
        this.loadComboData();
        super.performDefaults();
    }

    private void saveComboData() {
        String[] strs = this.profileCombo.getItems();
        String comboData = this.gatherComboData(strs);
        this.setValue("PREF_KEY_USER_VARIABLES_PROFILE", comboData);
        String selected = this.getProfileComboSelectedValue();
        this.setValue("PREF_KEY_USER_VARIABLES_SELECTED_PROFILE", selected);
    }

    private String gatherComboData(String[] items) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            builder.append(String.valueOf(str) + "|");
            ++n2;
        }
        return builder.toString();
    }

    @Override
    public void performApply() {
        this.saveComboData();
        super.performApply();
    }

    @Override
    protected void createTableColumns(Table table) {
        TableLayout layout = new TableLayout();
        TableColumn col1 = new TableColumn(table, 0, 0);
        col1.setText("Key");
        ColumnWeightData data = new ColumnWeightData(50, true);
        layout.addColumnData((ColumnLayoutData)data);
        TableColumn col2 = new TableColumn(table, 0, 1);
        col2.setText("Value");
        data = new ColumnWeightData(50, true);
        layout.addColumnData((ColumnLayoutData)data);
        table.setLayout((Layout)layout);
    }

    @Override
    protected String getTableItemDataKey() {
        String result = "PREF_KEY_USER_VARIABLES." + this.getProfileComboSelectedValue();
        return result;
    }

    static class NewProfileDialog
    extends AbstractStringsAddDialog {
        private Text nameText;

        public NewProfileDialog(Shell parent) {
            super(parent, RestUIMessages.UserVariablesPreferencePage_new_dialog_title);
        }

        @Override
        protected void createContents(Shell shell) {
            Label lblValue = new Label((Composite)shell, 0);
            lblValue.setText(RestUIMessages.UserVariablesPreferencePage_new_dialog_label);
            this.nameText = this.createText((Composite)shell, 300, true);
            this.nameText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 13 && NewProfileDialog.this.updateOkButtonState()) {
                        NewProfileDialog.this.updateResult();
                        NewProfileDialog.this.close();
                    }
                }
            });
        }

        @Override
        protected String[] makeResult() {
            return new String[]{this.nameText.getText()};
        }

        @Override
        protected Control getFirstFocusControl() {
            return this.nameText;
        }
    }
}

