/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.preferences;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.common.sign.preferences.SigningPreferencePage;
import org.tizen.common.sign.preferences.SigningProfileItem;

public class ProfileCellModifier
implements ICellModifier {
    private TableViewer viewer;
    private SigningPreferencePage page;

    public ProfileCellModifier(TableViewer viewer, SigningPreferencePage signingPreferencePage) {
        this.viewer = viewer;
        this.page = signingPreferencePage;
    }

    public boolean canModify(Object element, String property) {
        return false;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof SigningProfileItem) {
            SigningProfileItem item = (SigningProfileItem)element;
            if (property.equals("password")) {
                return item.getPassword();
            }
            if (property.equals("key")) {
                return item.getKeyLocation();
            }
            if (property.equals("ca")) {
                return item.getCAPath();
            }
            if (property.equals("rootca")) {
                return item.getRootCAPath();
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        Object data = null;
        if (element instanceof TableItem) {
            data = ((TableItem)element).getData();
        }
        if (data instanceof SigningProfileItem) {
            SigningProfileItem item = (SigningProfileItem)data;
            String _value = (String)value;
            if (property.equals("password")) {
                item.setPassword(_value.toCharArray());
            } else if (property.equals("key")) {
                item.setKeyLocation(_value);
            } else if (property.equals("ca")) {
                item.setCAPath(_value);
            } else if (property.equals("rootca")) {
                item.setRootCAPath(_value);
            }
            this.viewer.update(data, null);
            this.page.validatePreferencePage();
        }
    }
}

