/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow.widgets;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.mihalis.opal.preferenceWindow.PreferenceWindow;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;

public class PWSpinner
extends PWWidget {
    private final int max;
    private final int min;

    public PWSpinner(String label, String propertyKey, int min, int max) {
        super(label, propertyKey, label == null ? 1 : 2, false);
        this.min = min;
        this.max = max;
    }

    @Override
    public Control build(Composite parent) {
        this.buildLabel(parent, 2);
        final Spinner spinner = new Spinner(parent, 2304);
        this.addControl((Control)spinner);
        spinner.setMinimum(this.min);
        spinner.setMaximum(this.max);
        Integer originalValue = (Integer)PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        spinner.setSelection(originalValue.intValue());
        spinner.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                PreferenceWindow.getInstance().setValue(PWSpinner.this.getPropertyKey(), new Integer(spinner.getSelection()));
            }
        });
        return spinner;
    }

    @Override
    public void check() {
        Object value = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (value == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), new Integer(this.min));
        } else {
            if (!(value instanceof Integer)) {
                throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be an Integer because it is associated to a spinner");
            }
            int valueAsInt = (Integer)value;
            if (valueAsInt < this.min || valueAsInt > this.max) {
                throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' is out of range (value is " + valueAsInt + ", range is " + this.min + "-" + this.max + ")");
            }
        }
    }
}

