/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.template;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.common.verrari.ITemplate;
import org.tizen.common.verrari.template.AbstractTemplate;
import org.tizen.common.verrari.template.TemplateTransformer;

public class TransformableTemplate
extends AbstractTemplate
implements ITemplate {
    protected final TemplateTransformer transformer;
    protected final ITemplate template;

    public TransformableTemplate(TemplateTransformer transformer, ITemplate template) {
        Assert.notNull((Object)template);
        this.transformer = transformer;
        this.template = template;
    }

    @Override
    public InputStream open() throws IOException {
        if (this.transformer == null) {
            return this.template.open();
        }
        String raw = IOUtil.getString((InputStream)this.template.open(), (boolean)true);
        String contents = this.transformer.templateTranslate(raw);
        this.logger.info("Transfor From :\n{}\n===>\n{}", (Object)raw, (Object)contents);
        ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes());
        this.logger.info("Input Stream :{}", (Object)in);
        return in;
    }
}

