/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import zipeditor.Messages;
import zipeditor.ZipEditorPlugin;
import zipeditor.ZipLabelProvider;

public abstract class MultiElementPropertyPage
extends PropertyPage {
    private IAdaptable[] fElements;
    protected String nonEqualStringLabel = Messages.getString("MultiElementPropertyPage.0");

    public void setElements(IAdaptable[] elements) {
        this.fElements = elements;
    }

    public void setElement(IAdaptable element) {
        if (element != null) {
            this.fElements = new IAdaptable[]{element};
        }
    }

    public IAdaptable[] getElements() {
        return this.fElements;
    }

    protected void setFieldText(Text field, PropertyAccessor accessor) {
        this.setFieldText(field, accessor, false);
    }

    protected void setFieldText(Text field, PropertyAccessor accessor, boolean summate) {
        Object[] values = new Object[this.fElements.length];
        Number sum = null;
        int i = 0;
        while (i < this.fElements.length) {
            values[i] = accessor.getPropertyValue(this.fElements[i]);
            if (summate && values[i] instanceof Number) {
                sum = new Long(((Number)values[i]).longValue() + (sum != null ? sum.longValue() : 0L));
            }
            ++i;
        }
        Object unequalValue = new Object();
        Object singularValue = values.length > 0 ? values[0] : null;
        int i2 = 1;
        while (i2 < values.length) {
            singularValue = values[i2];
            if (!(values[i2] == values[i2 - 1] || values[i2] != null && values[i2].equals(values[i2 - 1]))) {
                singularValue = unequalValue;
                break;
            }
            ++i2;
        }
        if (sum != null) {
            field.setText(this.formatLong(sum.longValue()));
        } else if (singularValue == unequalValue) {
            field.setText(this.nonEqualStringLabel);
        } else if (singularValue != null) {
            field.setText(singularValue.toString());
        }
    }

    protected String formatLong(long value) {
        return ZipLabelProvider.formatLong(value);
    }

    protected class MultiplePropertyAccessor
    implements PropertyAccessor {
        private PropertyDescriptor[] fDescriptors;
        private String fPropertyName;

        public MultiplePropertyAccessor(Class clazz) {
            try {
                this.fDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            }
            catch (Exception e) {
                ZipEditorPlugin.log(e);
            }
        }

        @Override
        public Object getPropertyValue(Object object) {
            int i = 0;
            while (i < this.fDescriptors.length) {
                if (this.fDescriptors[i].getName().equals(this.fPropertyName)) {
                    try {
                        return this.fDescriptors[i].getReadMethod().invoke(object, null);
                    }
                    catch (Exception e) {
                        ZipEditorPlugin.log(e);
                    }
                }
                ++i;
            }
            return null;
        }

        public PropertyAccessor getAccessor(String property) {
            this.fPropertyName = property;
            return this;
        }
    }

    protected static interface PropertyAccessor {
        public Object getPropertyValue(Object var1);
    }
}

