/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.transitionComposite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.transitionComposite.TRANSITIONS;
import org.mihalis.opal.transitionComposite.Transition;
import org.mihalis.opal.transitionComposite.TransitionFactory;

public class TransitionComposite
extends Composite {
    private final List<Control> controls;
    private int selection = 0;
    private TRANSITIONS transition = TRANSITIONS.NONE;

    public TransitionComposite(Composite parent, int style) {
        super(parent, style);
        this.controls = new ArrayList<Control>();
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ((Control)TransitionComposite.this.controls.get(TransitionComposite.this.selection)).setBounds(TransitionComposite.this.getClientArea());
            }
        });
    }

    public void addControl(Control control) {
        this.checkWidget();
        this.controls.add(control);
        if (this.controls.size() == 1) {
            control.setVisible(true);
        } else {
            control.setVisible(false);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 0;
        int height = 0;
        for (Control control : this.controls) {
            Point point = control.computeSize(wHint, hHint, changed);
            width = Math.max(width, point.x);
            height = Math.max(height, point.y);
        }
        return new Point(Math.max(width, wHint), Math.max(height, hHint));
    }

    public TRANSITIONS getTransition() {
        this.checkWidget();
        return this.transition;
    }

    public void moveToFirst() {
        this.checkWidget();
        this.changeSelectionTo(0);
    }

    public void moveToLast() {
        this.checkWidget();
        this.changeSelectionTo(this.controls.size() - 1);
    }

    public void moveToNext() {
        this.checkWidget();
        int index = this.selection + 1;
        if (index == this.controls.size()) {
            return;
        }
        this.changeSelectionTo(index);
    }

    public void moveToPrevious() {
        this.checkWidget();
        int index = this.selection - 1;
        if (index < 0) {
            return;
        }
        this.changeSelectionTo(index);
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index > this.controls.size() - 1) {
            return;
        }
        this.changeSelectionTo(index);
    }

    private void changeSelectionTo(int index) {
        Transition t = TransitionFactory.getTransitionFor(this.transition);
        t.performTransition(this.controls.get(this.selection), this.controls.get(index));
        this.selection = index;
        this.controls.get(this.selection).setBounds(this.getClientArea());
    }

    public void setSelection(Control control) {
        this.checkWidget();
        int i = 0;
        while (i < this.controls.size()) {
            if (this.controls.get(i) != null && this.controls.get(i).equals(control)) {
                this.changeSelectionTo(i);
                return;
            }
            ++i;
        }
    }

    public void setTransition(TRANSITIONS transition) {
        this.checkWidget();
        this.transition = transition;
    }
}

