/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.ArrayUtil;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IteratingRunner;
import org.tizen.common.util.ObjectUtil;

public class StringUtil {
    private static final Logger logger = LoggerFactory.getLogger(StringUtil.class);
    public static final String EMPTY_STRING = "";
    public static final String NULL_STRING = "<<null>>";
    public static final String EMPTY_BYTES_STRING = "<<EMPTY BYTES>>";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String TAB = "\t";
    protected static char CONTROL_CHARS_SHOWER = (char)46;
    protected static final char[] HEXA_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected static final int N_INT_BY_BYTE = 4;
    protected static final int WIDTH_PER_LINE = 16;
    protected static char TWO_BYTES_CHARS_SHOWER = (char)63;
    public static String ISO_8859_1 = "ISO-8859-1";

    public static InputStream toInputStream(String src) {
        if (src == null) {
            return null;
        }
        return new ByteArrayInputStream(src.getBytes());
    }

    public static String[] split(String str, String delimiters) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delimiters);
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[0]);
    }

    public static String getOnlyNumerics(String str) {
        if (str == null) {
            return null;
        }
        final StringBuilder sb = new StringBuilder();
        ArrayUtil.iterate(ArrayUtil.convertToWrapper(str.toCharArray()), new IteratingRunner<Character>(){

            @Override
            public void run(Character arg) {
                if (Character.isDigit(arg.charValue())) {
                    sb.append(arg);
                }
            }
        });
        return sb.toString();
    }

    public static String asString(Reader reader) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = reader.read()) != -1) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String asString(InputStream is) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = is.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String removeStart(String str, String remove) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static void appendHexa(StringBuilder buffer, int ch) {
        if (ch < 16) {
            buffer.append('0');
            buffer.append(HEXA_CHARS[0xF & ch]);
        } else {
            buffer.append(HEXA_CHARS[0xF & ch >> 4]);
            buffer.append(HEXA_CHARS[0xF & ch]);
        }
    }

    protected static void lineEnd(StringBuilder hexPart, StringBuilder textPart, StringBuilder ret) {
        hexPart.append("     |");
        textPart.append("|\n");
        ret.append((CharSequence)hexPart);
        ret.append((CharSequence)textPart);
        hexPart.delete(0, hexPart.capacity());
        textPart.delete(0, textPart.capacity());
    }

    public static String text2hexa(byte[] data) {
        if (data == null) {
            return NULL_STRING;
        }
        return StringUtil.text2hexa(data, 0, data.length);
    }

    public static String text2hexa(byte[] data, int offset, int length) {
        if (data == null) {
            return NULL_STRING;
        }
        if (data.length <= 0) {
            return EMPTY_BYTES_STRING;
        }
        ByteArrayInputStream reader = new ByteArrayInputStream(data, offset, length);
        StringBuilder ret = new StringBuilder();
        StringBuilder hexPart = new StringBuilder();
        StringBuilder textPart = new StringBuilder();
        int address = 0;
        int ch = -1;
        int printByte = 0;
        int cnt = 0;
        hexPart.append("          ");
        int i = 0;
        int n = 4;
        while (i < n) {
            hexPart.append("+-------");
            textPart.append("+---");
            ++i;
        }
        StringUtil.lineEnd(hexPart, textPart, ret);
        while ((ch = reader.read()) >= 0) {
            if (cnt == 0) {
                i = 3;
                while (i >= 0) {
                    printByte = 0xFF & address >> 8 * i;
                    StringUtil.appendHexa(hexPart, printByte);
                    --i;
                }
                hexPart.append("  ");
                address += 16;
            }
            StringUtil.appendHexa(hexPart, ch);
            if ((ch & 0x80) != 0 || ch < 32) {
                textPart.append(CONTROL_CHARS_SHOWER);
            } else {
                textPart.append((char)ch);
            }
            if (16 != ++cnt) continue;
            StringUtil.lineEnd(hexPart, textPart, ret);
            cnt = 0;
        }
        if (cnt != 0) {
            while (cnt < 16) {
                hexPart.append("  ");
                textPart.append(' ');
                ++cnt;
            }
            StringUtil.lineEnd(hexPart, textPart, ret);
        }
        return ret.toString();
    }

    public static boolean isEmpty(CharSequence str) {
        if (str == null) {
            return true;
        }
        int i = 0;
        int n = str.length();
        while (i < n) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int size(CharSequence str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    public static boolean hasLength(CharSequence str) {
        return StringUtil.size(str) > 0;
    }

    public static boolean hasText(CharSequence str) {
        return !StringUtil.isEmpty(str);
    }

    public static String nvl(String ... strs) {
        String val = ObjectUtil.nvl(strs);
        if (val == null) {
            return EMPTY_STRING;
        }
        return val;
    }

    public static String trimLeading(String str) {
        if (!StringUtil.hasLength(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        int i = 0;
        int n = chs.length;
        while (i < n) {
            if (!Character.isWhitespace(chs[i])) {
                return new String(chs, i, str.length() - i);
            }
            ++i;
        }
        return EMPTY_STRING;
    }

    public static String trimTrailing(String str) {
        if (!StringUtil.hasLength(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        int i = chs.length - 1;
        int j = chs.length;
        while (j > 0) {
            if (!Character.isWhitespace(chs[i])) {
                return new String(chs, 0, j);
            }
            --i;
            --j;
        }
        return EMPTY_STRING;
    }

    public static String trim(String str) {
        return StringUtil.trimTrailing(StringUtil.trimLeading(str));
    }

    public static String getMeaningful(String str) {
        if (str == null) {
            return EMPTY_STRING;
        }
        return StringUtil.trim(str).toLowerCase();
    }

    public static String mask(String str, String maskingStr) {
        if (str == null) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        int n = str.length();
        while (i < n) {
            buffer.append(maskingStr);
            ++i;
        }
        return buffer.toString();
    }

    public static String getParamater(String str, char delimeter, int escaper, int targetIndex) throws IOException {
        block11: {
            if (str != null) break block11;
            return null;
        }
        try {
            StringReader reader = new StringReader(str);
            StringWriter writer = null;
            int ch = 0;
            boolean status = false;
            int index = 0;
            if (targetIndex == 0) {
                writer = new StringWriter();
            }
            while ((ch = reader.read()) >= 0) {
                if (status) {
                    status = false;
                } else {
                    if (escaper == ch) {
                        status = true;
                        continue;
                    }
                    if (delimeter == ch) {
                        if (index == targetIndex) {
                            return writer.toString();
                        }
                        if (++index != targetIndex) continue;
                        writer = new StringWriter();
                        continue;
                    }
                }
                if (writer == null) continue;
                writer.write(ch);
            }
            if (index == targetIndex) {
                return writer.toString();
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String lastSubstring(String str, int indexFromLast) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        if (length < indexFromLast) {
            return str;
        }
        return str.substring(length - indexFromLast);
    }

    public static String getLastSegment(String str, String separator) {
        if (str == null) {
            return EMPTY_STRING;
        }
        int index = str.lastIndexOf(separator);
        if (index < 0) {
            return str;
        }
        return str.substring(index + separator.length());
    }

    public static String removeLastSegment(String str, String separator) {
        if (str == null) {
            return EMPTY_STRING;
        }
        int index = str.lastIndexOf(separator);
        if (index < 0) {
            return EMPTY_STRING;
        }
        return str.substring(0, index);
    }

    public static String multiply(String symbol, int n) {
        if (symbol == null) {
            return EMPTY_STRING;
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < n) {
            buffer.append(symbol);
            ++i;
        }
        return buffer.toString();
    }

    public static boolean containsWhitespace(CharSequence str) {
        int nChar = StringUtil.size(str);
        int i = 0;
        while (i < nChar) {
            if (Character.isWhitespace(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!StringUtil.hasLength(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        int i = 0;
        int n = chs.length;
        while (i < n) {
            if (leadingCharacter != chs[i]) {
                return new String(chs, i, str.length() - i);
            }
            ++i;
        }
        return EMPTY_STRING;
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (!StringUtil.hasLength(str)) {
            return str;
        }
        char[] chs = str.toCharArray();
        int i = chs.length - 1;
        int j = chs.length;
        while (j > 0) {
            if (trailingCharacter != chs[i]) {
                return new String(chs, 0, j);
            }
            --i;
            --j;
        }
        return EMPTY_STRING;
    }

    public static String trimCharacter(String str, char character) {
        return StringUtil.trimTrailingCharacter(StringUtil.trimLeadingCharacter(str, character), character);
    }

    public static String getWord(String doc, int index) {
        StringBuilder buffer = new StringBuilder();
        int position = index;
        if (doc.length() < index) {
            return EMPTY_STRING;
        }
        int i = position - 1;
        while (i >= 0) {
            char ch = doc.charAt(i);
            if (Character.isWhitespace((int)ch)) break;
            buffer.append(ch);
            --i;
        }
        buffer.reverse();
        i = position;
        int n = doc.length();
        while (i < n) {
            char ch = doc.charAt(i);
            if (Character.isWhitespace((int)ch)) break;
            buffer.append(ch);
            ++i;
        }
        return buffer.toString();
    }

    public static String getPreviousWord(String doc, int index) {
        StringBuilder buffer = new StringBuilder();
        if (index < 0 || doc.length() < index) {
            logger.debug("Index[{0}] is out of bound :[0:{1}]", (Object)index, (Object)doc.length());
            return EMPTY_STRING;
        }
        char ch = '\u0000';
        boolean bNeedWord = false;
        if (index < doc.length()) {
            ch = doc.charAt(index);
            bNeedWord = Character.isWhitespace((int)ch);
        }
        logger.debug("Character at index :'{0}'", (Object)Character.valueOf(ch));
        int i = index - 1;
        while (i >= 0) {
            ch = doc.charAt(i);
            if (Character.isWhitespace((int)ch)) {
                if (!bNeedWord) {
                    logger.debug("Meet space at column {0}", (Object)i);
                    break;
                }
            } else {
                bNeedWord = false;
                buffer.append(ch);
            }
            --i;
        }
        return buffer.reverse().toString();
    }

    public static <T extends Enum<T>> String[] enumNameToStringArray(T[] values) {
        int i = 0;
        String[] result = new String[values.length];
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            result[i++] = ((Enum)value).name();
            ++n2;
        }
        return result;
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String convertFirstLetterUpperCase(String str) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        char[] str_array = str.toCharArray();
        str_array[0] = Character.toUpperCase(str_array[0]);
        str = new String(str_array);
        return str;
    }

    public static String getLastStringAfter(String input, String lastIndexStr) {
        if (input == null) {
            return null;
        }
        int k = input.lastIndexOf(lastIndexStr);
        return k != -1 ? input.substring(k + 1, input.length()) : null;
    }

    public static String[] splitByCamelCase(String str) {
        if (StringUtil.isEmpty(str)) {
            return new String[0];
        }
        char[] c = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c[tokenStart]);
        int pos = tokenStart + 1;
        while (pos < c.length) {
            int type = Character.getType(c[pos]);
            if (type != currentType) {
                if (type == 2 && currentType == 1) {
                    int newTokenStart = pos - 1;
                    if (newTokenStart != tokenStart) {
                        list.add(new String(c, tokenStart, newTokenStart - tokenStart));
                        tokenStart = newTokenStart;
                    }
                } else {
                    list.add(new String(c, tokenStart, pos - tokenStart));
                    tokenStart = pos;
                }
                currentType = type;
            }
            ++pos;
        }
        list.add(new String(c, tokenStart, c.length - tokenStart));
        return list.toArray(new String[0]);
    }

    private static int minimum(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    public static int getLevenshteinDistance(CharSequence str1, CharSequence str2) {
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        int i = 0;
        while (i <= str1.length()) {
            distance[i][0] = i;
            ++i;
        }
        int j = 1;
        while (j <= str2.length()) {
            distance[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= str1.length()) {
            int j2 = 1;
            while (j2 <= str2.length()) {
                distance[i][j2] = StringUtil.minimum(distance[i - 1][j2] + 1, distance[i][j2 - 1] + 1, distance[i - 1][j2 - 1] + (str1.charAt(i - 1) == str2.charAt(j2 - 1) ? 0 : 1));
                ++j2;
            }
            ++i;
        }
        return distance[str1.length()][str2.length()];
    }

    public static String[] split(String str, Pattern pattern) {
        ArrayList<String> result = null;
        Matcher matcher = pattern.matcher(str);
        if (matcher.matches()) {
            result = new ArrayList<String>();
            int i = 0;
            while (i < matcher.groupCount()) {
                result.add(matcher.group(i + 1));
                ++i;
            }
        }
        return result == null ? null : result.toArray(new String[0]);
    }

    public static String convertToDefaultCharset(String text, String charset) throws UnsupportedEncodingException {
        Assert.notNull(text);
        Assert.notNull(charset);
        byte[] bytes = text.getBytes(charset);
        String defaultCharset = Charset.defaultCharset().name();
        return new String(bytes, defaultCharset);
    }
}

