/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.receiver;

import java.io.IOException;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.util.Log;

public class AppCmdReceiver
extends MultiLineReceiver {
    private AppCmdReturn appCmdReturn;
    private IShellOutputReceiver forwardReceiver;
    private final String APPCMD_EXITCODE_PREFIX = "appcmd_exitcode:";
    private final String APPCMD_RETURNSTR_PREFIX = "appcmd_returnstr:";

    public AppCmdReceiver(IShellOutputReceiver receiver) {
        this.forwardReceiver = receiver;
        this.appCmdReturn = new AppCmdReturn();
    }

    @Override
    public void processNewLines(String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).contains("appcmd_exitcode:")) {
                int exitcode;
                this.appCmdReturn.appCmdExitcode = exitcode = Integer.parseInt(line.substring("appcmd_exitcode:".length()));
            } else if (line.contains("appcmd_returnstr:")) {
                String returnStr;
                this.appCmdReturn.appCmdReturnStr = returnStr = line.substring("appcmd_returnstr:".length());
            } else {
                try {
                    if (this.forwardReceiver != null) {
                        this.forwardReceiver.append(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException iOException) {
                    Log.e("Device", "Fail to append message to forward receiver.");
                }
            }
            ++n2;
        }
    }

    public AppCmdReturn getAppCmdReturn() {
        return this.appCmdReturn;
    }

    public static class AppCmdReturn {
        protected int appCmdExitcode = -1;
        protected String appCmdReturnStr = null;

        public int getAppCmdExitcode() {
            return this.appCmdExitcode;
        }

        public String getAppCmdReturnStr() {
            return this.appCmdReturnStr;
        }
    }
}

