/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.parser;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.connection.logview.model.Log;
import org.tizen.common.connection.logview.parser.IDlogParser;
import org.tizen.sdblib.util.LogLevel;

public class DlogParser_Wearable_2_3
implements IDlogParser {
    public static final String DLOG_INFO_FORMAT_REGEX = "^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s+(\\d*):\\s*(\\d+)\\s([VDIWEF])\\/(.+)\\s+\\]$";
    public static final String DLOG_FULL_FORMAT_REGEX = "^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s+(\\d*):\\s*(\\d+)\\s([VDIWEF])\\/(.+)\\s+\\]\\s(.+)$";
    private Pattern pattern_info = Pattern.compile("^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s+(\\d*):\\s*(\\d+)\\s([VDIWEF])\\/(.+)\\s+\\]$");
    private Pattern pattern_full = Pattern.compile("^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s+(\\d*):\\s*(\\d+)\\s([VDIWEF])\\/(.+)\\s+\\]\\s(.+)$");
    private final String DLOG_COMMAND_FORMAT = "/usr/bin/dlogutil -v long *:%s";

    @Override
    public Log parse(String line) {
        Matcher matcher = this.pattern_info.matcher(line);
        if (matcher.matches()) {
            LogLevel logLevel = LogLevel.getByLetter((String)matcher.group(4));
            String pid = matcher.group(2);
            String tid = matcher.group(3);
            String tag = matcher.group(5).trim();
            String time = matcher.group(1);
            return new Log(logLevel, pid, tid, tag, time, "");
        }
        return null;
    }

    @Override
    public ArrayList<Log> parse(String[] lines) {
        ArrayList<Log> logs = new ArrayList<Log>();
        int i = 0;
        while (i < lines.length) {
            if (this.pattern_info.matcher(lines[i]).matches() && i + 1 < lines.length) {
                int body = 1;
                String merged = lines[i];
                while (i + body < lines.length && !lines[i + body].isEmpty()) {
                    merged = String.valueOf(merged) + " " + lines[i + body];
                    ++body;
                }
                Matcher matcher = this.pattern_full.matcher(merged);
                if (matcher.matches()) {
                    LogLevel logLevel = LogLevel.getByLetter((String)matcher.group(4));
                    String pid = matcher.group(2);
                    String tid = matcher.group(3);
                    String tag = matcher.group(5).trim();
                    String time = matcher.group(1);
                    String message = matcher.group(6);
                    logs.add(new Log(logLevel, pid, tid, tag, time, message));
                    i += body;
                }
            }
            ++i;
        }
        return logs;
    }

    @Override
    public String getDlogUtilCommandFormat() {
        return "/usr/bin/dlogutil -v long *:%s";
    }
}

