/*
 * Decompiled with CFR 0.152.
 */
package javaewah;

import javaewah.BitmapStorage;
import javaewah.BufferedRunningLengthWord;
import javaewah.EWAHCompressedBitmap;
import javaewah.EWAHIterator;

public class IteratingBufferedRunningLengthWord {
    private BufferedRunningLengthWord brlw;
    private long[] buffer;
    private int dirtyWordStartPosition;
    private EWAHIterator iterator;

    public IteratingBufferedRunningLengthWord(EWAHIterator iterator) {
        this.iterator = iterator;
        this.brlw = new BufferedRunningLengthWord(this.iterator.next());
        this.dirtyWordStartPosition = this.iterator.dirtyWords() + this.brlw.dirtywordoffset;
        this.buffer = this.iterator.buffer();
    }

    public void discardFirstWords(long x) {
        while (x > 0L) {
            if (this.brlw.RunningLength >= x) {
                this.brlw.RunningLength -= x;
                return;
            }
            this.brlw.RunningLength = 0L;
            long toDiscard = (x -= this.brlw.RunningLength) > (long)this.brlw.NumberOfLiteralWords ? (long)this.brlw.NumberOfLiteralWords : x;
            this.dirtyWordStartPosition = (int)((long)this.dirtyWordStartPosition + toDiscard);
            this.brlw.NumberOfLiteralWords = (int)((long)this.brlw.NumberOfLiteralWords - toDiscard);
            if ((x -= toDiscard) <= 0L && this.brlw.size() != 0L) continue;
            if (!this.iterator.hasNext()) break;
            this.brlw.reset(this.iterator.next());
            this.dirtyWordStartPosition = this.iterator.dirtyWords() + this.brlw.dirtywordoffset;
        }
    }

    public void discharge(BitmapStorage container) {
        this.brlw.dirtywordoffset = this.dirtyWordStartPosition - this.iterator.dirtyWords();
        EWAHCompressedBitmap.discharge(this.brlw, this.iterator, container);
    }

    public long getDirtyWordAt(int index) {
        return this.buffer[this.dirtyWordStartPosition + index];
    }

    public int getNumberOfLiteralWords() {
        return this.brlw.NumberOfLiteralWords;
    }

    public boolean getRunningBit() {
        return this.brlw.RunningBit;
    }

    public long getRunningLength() {
        return this.brlw.RunningLength;
    }

    public long size() {
        return this.brlw.size();
    }

    public void writeDirtyWords(int numWords, BitmapStorage container) {
        container.addStreamOfDirtyWords(this.buffer, this.dirtyWordStartPosition, numWords);
    }
}

