/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.engine.freemarker;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.verrari.ITemplate;
import org.tizen.common.verrari.ITemplateProvider;
import org.tizen.common.verrari.engine.freemarker.FreemarkerTemplateTransformer;
import org.tizen.common.verrari.template.TemplateProviderDelegate;
import org.tizen.common.verrari.template.TemplateTransformer;
import org.tizen.common.verrari.template.TransformableTemplate;

public class FreemarkerTemplateProvider
extends TemplateProviderDelegate
implements TemplateLoader {
    protected HashMap<Object, Reader> key2reader = new HashMap();
    protected TemplateTransformer transformer = new FreemarkerTemplateTransformer();

    public FreemarkerTemplateProvider(ITemplateProvider provider) {
        super(provider);
    }

    @Override
    public void setTransformer(TemplateTransformer transformer) {
        this.transformer = transformer;
    }

    @Override
    public ITemplate getTemplate(String key) {
        ITemplate raw = super.getTemplate(key);
        if (raw == null) {
            return raw;
        }
        return new TransformableTemplate(this.transformer, raw);
    }

    public Object findTemplateSource(String key) throws IOException {
        this.logger.info("Find template source for {}", (Object)key);
        ITemplate template = this.getTemplate(key);
        return template;
    }

    public long getLastModified(Object key) {
        return 0L;
    }

    public Reader getReader(Object templateObj, String encoding) throws IOException {
        InputStreamReader ret;
        block3: {
            StringReader stringReader;
            this.logger.info("Open template source for {}", templateObj);
            ITemplate template = (ITemplate)templateObj;
            ret = new InputStreamReader(template.open(), StringUtil.nvl((String[])new String[]{template.getEncoding(), encoding}));
            try {
                if (!this.logger.isTraceEnabled()) break block3;
                String contents = IOUtil.getString((Reader)ret);
                this.logger.trace("{} Template :{}", templateObj, (Object)contents);
                IOUtil.tryClose((Object[])new Object[]{ret});
                stringReader = new StringReader(contents);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{this.key2reader.put(templateObj, ret)});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{this.key2reader.put(templateObj, ret)});
            return stringReader;
        }
        InputStreamReader inputStreamReader = ret;
        IOUtil.tryClose((Object[])new Object[]{this.key2reader.put(templateObj, ret)});
        return inputStreamReader;
    }

    public void closeTemplateSource(Object templateObj) throws IOException {
        this.logger.info("Close template source for {}", templateObj);
        IOUtil.tryClose((Object[])new Object[]{this.key2reader.remove(templateObj)});
    }
}

