/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.gom.smartlaunch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.gom.launch.GomLaunchData;
import org.tizen.common.gom.smartlaunch.GomSmartLauncher;
import org.tizen.common.gom.smartlaunch.messages.GomMessages;
import org.tizen.common.gom.smartlaunch.ui.GomDialog;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.sdblib.IDevice;

public class GomSmartUILauncher {
    private static GomDialog gomDialog = null;
    private static final Logger logger = LoggerFactory.getLogger(GomSmartUILauncher.class);

    public static synchronized void openDialog() {
        if (gomDialog == null) {
            if (GomSmartUILauncher.existTizenProject()) {
                gomDialog = new GomDialog(SWTUtil.getShell());
                if (gomDialog.open() == 0 && GomSmartUILauncher.isExistDevice()) {
                    GomSmartLauncher.smartLaunch(GomSmartUILauncher.getLaunchData(gomDialog));
                }
                gomDialog = null;
            } else {
                MessageDialog.openError((Shell)SWTUtil.getShell(), (String)GomMessages.SMARTLAUNCH_FAIL, (String)GomMessages.SMARTLAUNCH_NO_PROJECT);
            }
        }
    }

    private static GomLaunchData getLaunchData(GomDialog dialog) {
        GomLaunchData data = new GomLaunchData(dialog.getProject(), dialog.getConfigurationName(), dialog.getBuildConfiguration(), dialog.getMode(), dialog.getLaunchShortcutExtension(), null);
        return data;
    }

    private static boolean existTizenProject() {
        boolean result = false;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects.length != 0) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (ProjectUtil.isTizenProject((IProject)project)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public static boolean isExistDevice() {
        boolean result = false;
        String message = null;
        IDevice selectedDevice = ConnectionPlugin.getDefault().getCurrentDevice();
        if (selectedDevice != null) {
            result = true;
        } else {
            message = GomMessages.SMARTLAUNCH_DISCONNECTED_DEVICE;
        }
        if (message != null) {
            logger.error(message);
            MessageDialog.openError((Shell)SWTUtil.getShell(), (String)GomMessages.SMARTLAUNCH_FAIL, (String)message);
        }
        return result;
    }
}

