/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import zipeditor.actions.ActionMessages;
import zipeditor.actions.StringMatcher;
import zipeditor.actions.ViewerAction;
import zipeditor.model.Node;

public class SelectPatternAction
extends ViewerAction {
    public static final String ID = "zipeditor.command.selectPattern";
    private String fPreviousValue;

    public SelectPatternAction(StructuredViewer viewer) {
        super(ActionMessages.getString("SelectPatternAction.0"), viewer);
        this.setId(ID);
        this.setActionDefinitionId(ID);
    }

    public void run() {
        InputDialog dlg = new InputDialog(this.getViewer().getControl().getShell(), ActionMessages.getString("SelectPatternAction.1"), ActionMessages.getString("SelectPatternAction.2"), this.fPreviousValue, null);
        if (dlg.open() != 0) {
            return;
        }
        String value = dlg.getValue();
        if (value != null) {
            Object root = this.getViewer().getInput();
            if (root instanceof Node) {
                ArrayList selection = new ArrayList();
                StringMatcher matcher = new StringMatcher(value, true, false);
                this.collectMatches((Node)((Object)root), matcher, selection);
                this.getViewer().setSelection((ISelection)new StructuredSelection(selection));
            }
            this.fPreviousValue = value;
        }
    }

    private void collectMatches(Node node, StringMatcher matcher, List selection) {
        Node[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            Node child = children[i];
            if (matcher.match(child.getName())) {
                selection.add(child);
            }
            this.collectMatches(child, matcher, selection);
            ++i;
        }
    }
}

