/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import zipeditor.ZipEditor;
import zipeditor.actions.AddAction;
import zipeditor.actions.CopyAction;
import zipeditor.actions.DeleteAction;
import zipeditor.actions.ExtractAction;
import zipeditor.actions.MultiPropertyDialogAction;
import zipeditor.actions.PreferencesAction;
import zipeditor.actions.RevertAction;
import zipeditor.actions.SaveAction;
import zipeditor.actions.SortAction;

public class ZipActionGroup
extends ActionGroup {
    private IAction fAddAction;
    private IAction fCopyAction;
    private IAction fCopyQualifiedAction;
    private IAction fDeleteAction;
    private IAction fExtractAction;
    private IAction fSortAction;
    private IAction fSaveAction;
    private IAction fRevertAction;
    private IAction fPreferencesAction;
    private IAction fPropertiesAction;
    private ZipEditor fEditor;
    private Clipboard fClipboard;

    public ZipActionGroup(ZipEditor editor) {
        this.fRevertAction = new RevertAction(editor);
        this.fRevertAction.setActionDefinitionId("org.eclipse.ui.file.revert");
        this.fSaveAction = new SaveAction(editor);
        this.fSaveAction.setActionDefinitionId("org.eclipse.ui.file.save");
        this.fPreferencesAction = new PreferencesAction(editor);
        this.fEditor = editor;
        this.fClipboard = new Clipboard(this.fEditor.getViewer().getControl().getDisplay());
    }

    public void fillContextMenu(IMenuManager menu) {
        this.lazilyCreateActions();
        menu.add((IContributionItem)new Separator());
        menu.add(this.fCopyAction);
        menu.add(this.fCopyQualifiedAction);
        menu.add(this.fDeleteAction);
        menu.add((IContributionItem)new Separator());
        menu.add(this.fSaveAction);
        menu.add(this.fRevertAction);
        menu.add((IContributionItem)new Separator());
        menu.add(this.fAddAction);
        menu.add(this.fExtractAction);
        menu.add((IContributionItem)new Separator());
        menu.add(this.fPropertiesAction);
        this.updateActionBars();
    }

    private void lazilyCreateActions() {
        if (this.fPropertiesAction == null) {
            this.fPropertiesAction = new MultiPropertyDialogAction((IShellProvider)this.fEditor.getSite(), (ISelectionProvider)this.fEditor.getViewer());
            this.fPropertiesAction.setActionDefinitionId("org.eclipse.ui.file.properties");
        }
        if (this.fAddAction == null) {
            this.fAddAction = new AddAction(this.fEditor.getViewer());
        }
        if (this.fExtractAction == null) {
            this.fExtractAction = new ExtractAction(this.fEditor.getViewer());
        }
        if (this.fCopyAction == null) {
            this.fCopyAction = new CopyAction(this.fEditor.getViewer(), false, this.fClipboard);
            this.fCopyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        }
        if (this.fCopyQualifiedAction == null) {
            this.fCopyQualifiedAction = new CopyAction(this.fEditor.getViewer(), true, this.fClipboard);
        }
        if (this.fDeleteAction == null) {
            this.fDeleteAction = new DeleteAction(this.fEditor.getViewer());
            this.fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        }
        if (this.fSortAction == null) {
            this.fSortAction = new SortAction(this.fEditor.getViewer(), "editor");
        }
    }

    public void fillToolBarManager(IToolBarManager manager, int mode) {
        this.lazilyCreateActions();
        manager.add((IContributionItem)new Separator());
        manager.add(this.fAddAction);
        manager.add(this.fExtractAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.fDeleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.fSortAction);
        if ((mode & 2) == 0) {
            manager.add((IContributionItem)new Separator());
            manager.add(this.fPreferencesAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.lazilyCreateActions();
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.fCopyAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.fDeleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.SAVE.getId(), this.fSaveAction);
        actionBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), this.fRevertAction);
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), this.fPropertiesAction);
        this.updateActionBars();
    }

    public void updateActionBars() {
        if (this.getContext() == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean empty = selection.isEmpty();
        this.lazilyCreateActions();
        this.fCopyAction.setEnabled(!empty);
        this.fCopyQualifiedAction.setEnabled(!empty);
        this.fDeleteAction.setEnabled(!empty);
        this.fSaveAction.setEnabled(this.fEditor.isDirty());
        this.fRevertAction.setEnabled(this.fEditor.isDirty());
        this.fPropertiesAction.setEnabled(!empty);
    }

    public void dispose() {
        super.dispose();
        this.fClipboard.dispose();
    }
}

