/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public class HTMLStyledTextParser
extends HTMLEditorKit.ParserCallback {
    private final List<StyleRange> listOfStyles;
    private final StyledText styledText;
    private int position;
    private final StringBuilder outputString;
    private StyleRange currentStyleRange;
    private TagType currentTagType;
    private int currentPosition;

    HTMLStyledTextParser(StyledText styledText) {
        this.styledText = styledText;
        this.position = -1;
        this.listOfStyles = new ArrayList<StyleRange>();
        this.currentStyleRange = null;
        this.currentTagType = null;
        this.currentPosition = 0;
        this.outputString = new StringBuilder();
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (t == HTML.Tag.B) {
            this.currentStyleRange = new StyleRange();
            this.currentTagType = TagType.B;
            this.currentPosition = this.position;
        }
        if (t == HTML.Tag.I) {
            this.currentStyleRange = new StyleRange();
            this.currentTagType = TagType.I;
            this.currentPosition = this.position;
        }
        if (t == HTML.Tag.U) {
            this.currentStyleRange = new StyleRange();
            this.currentTagType = TagType.U;
            this.currentPosition = this.position;
        }
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        boolean underline;
        int style;
        if (t != HTML.Tag.B && t != HTML.Tag.I && t != HTML.Tag.U) {
            return;
        }
        if (t == HTML.Tag.B) {
            if (TagType.B != this.currentTagType) {
                throw new RuntimeException("Error parsing [" + this.styledText.getText() + "] : bad syntax");
            }
            style = 1;
            underline = false;
        } else if (t == HTML.Tag.I) {
            if (TagType.I != this.currentTagType) {
                throw new RuntimeException("Error parsing [" + this.styledText.getText() + "] : bad syntax");
            }
            style = 2;
            underline = false;
        } else if (t == HTML.Tag.U) {
            if (TagType.U != this.currentTagType) {
                throw new RuntimeException("Error parsing [" + this.styledText.getText() + "] : bad syntax");
            }
            style = 0;
            underline = true;
        } else {
            style = 0;
            underline = false;
        }
        this.currentStyleRange.start = this.currentPosition;
        this.currentStyleRange.length = this.position - this.currentPosition + 1;
        this.currentStyleRange.fontStyle = style;
        this.currentStyleRange.underline = underline;
        this.listOfStyles.add(this.currentStyleRange);
        this.currentStyleRange = null;
        this.currentTagType = null;
    }

    @Override
    public void handleError(String errorMsg, int pos) {
        throw new RuntimeException("Parsing error: " + errorMsg + " at " + pos);
    }

    @Override
    public void handleText(char[] data, int pos) {
        this.outputString.append(data);
        this.position += data.length;
    }

    @Override
    public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (t == HTML.Tag.BR) {
            this.outputString.append("\n");
            this.position += t.toString().length();
        }
    }

    public void parse() throws IOException {
        ParserDelegator parser = new ParserDelegator();
        ((HTMLEditorKit.Parser)parser).parse(new StringReader(this.styledText.getText()), this, true);
        this.styledText.setText(this.outputString.toString());
        this.styledText.setStyleRanges(this.listOfStyles.toArray(new StyleRange[this.listOfStyles.size()]));
    }

    private static enum TagType {
        B,
        U,
        I;

    }
}

